/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypePatternItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.WorkTypePatternDaoInterface;
import jp.mosp.time.dao.settings.WorkTypePatternItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternDtoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternItemDtoInterface;

public class WorkTypePatternItemReferenceBean
extends PlatformBean
implements WorkTypePatternItemReferenceBeanInterface {
    private WorkTypePatternItemDaoInterface dao;
    private WorkTypePatternDaoInterface workTypePatternDao;
    private WorkTypeReferenceBeanInterface workTypeReference;

    public WorkTypePatternItemReferenceBean() {
    }

    public WorkTypePatternItemReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypePatternItemDaoInterface)this.createDao(WorkTypePatternItemDaoInterface.class);
        this.workTypePatternDao = (WorkTypePatternDaoInterface)this.createDao(WorkTypePatternDaoInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
    }

    public List<WorkTypePatternItemDtoInterface> getWorkTypePatternItemList(String patternCode, Date activateDate) throws MospException {
        return this.dao.findForList(patternCode, activateDate);
    }

    public String[][] getSelectArray(String patternCode, Date targetDate) throws MospException {
        return this.getSelectArray(patternCode, targetDate, false, false, false, false);
    }

    public String[][] getNameSelectArray(String patternCode, Date targetDate) throws MospException {
        return this.getSelectArray(patternCode, targetDate, true, false, false, false);
    }

    public String[][] getTimeSelectArray(String patternCode, Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(patternCode, targetDate, false, true, amHoliday, pmHoliday);
    }

    public String[][] getNameTimeSelectArray(String patternCode, Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(patternCode, targetDate, true, true, amHoliday, pmHoliday);
    }

    protected String[][] getSelectArray(String patternCode, Date targetDate, boolean isName, boolean viewTime, boolean amHoliday, boolean pmHoliday) throws MospException {
        WorkTypeDtoInterface workTypeDto;
        WorkTypePatternDtoInterface workTypePatternDto = this.workTypePatternDao.findForInfo(patternCode, targetDate);
        if (workTypePatternDto == null) {
            return this.getNoObjectDataPulldown();
        }
        List list = this.dao.findForList(workTypePatternDto.getPatternCode(), workTypePatternDto.getActivateDate());
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        ArrayList<WorkTypeDtoInterface> workTypeList = new ArrayList<WorkTypeDtoInterface>();
        for (WorkTypePatternItemDtoInterface dto : list) {
            workTypeDto = this.workTypeReference.findForInfo(dto.getWorkTypeCode(), targetDate);
            if (workTypeDto == null || workTypeDto.getInactivateFlag() != 0) continue;
            workTypeList.add(workTypeDto);
        }
        String[][] array = this.prepareSelectArray(workTypeList.size(), false);
        for (int i = 0; i < workTypeList.size(); ++i) {
            workTypeDto = (WorkTypeDtoInterface)workTypeList.get(i);
            array[i][0] = workTypeDto.getWorkTypeCode();
            array[i][1] = workTypeDto.getWorkTypeAbbr();
            if (isName && viewTime) {
                array[i][1] = this.workTypeReference.getWorkTypeNameAndTime(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate());
                continue;
            }
            if (!isName && viewTime) {
                array[i][1] = this.workTypeReference.getWorkTypeAbbrAndTime(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), amHoliday, pmHoliday);
                continue;
            }
            if (!isName || viewTime) continue;
            array[i][1] = workTypeDto.getWorkTypeName();
        }
        return array;
    }
}

