/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeDto;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.TimeNamingUtility;

public class WorkTypeReferenceBean
extends PlatformBean
implements WorkTypeReferenceBeanInterface {
    private WorkTypeDaoInterface dao;
    private WorkTypeItemDaoInterface workTypeItemDao;

    public WorkTypeReferenceBean() {
    }

    public WorkTypeReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeDaoInterface)this.createDao(WorkTypeDaoInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
    }

    public WorkTypeDtoInterface getWorkTypeInfo(String workTypeCode, Date targetDate) throws MospException {
        if (workTypeCode.equals("work_on_legal")) {
            return this.getWorkOnLegalHolidayWorkType();
        }
        if (workTypeCode.equals("work_on_prescribed")) {
            return this.getWorkOnPrescribedHolidayWorkType();
        }
        return this.findForInfo(workTypeCode, targetDate);
    }

    public List<WorkTypeDtoInterface> getWorkTypeHistory(String workTypeCode) throws MospException {
        return this.dao.findForHistory(workTypeCode);
    }

    public String getWorkTypeAbbr(String workTypeCode, Date targetDate) throws MospException {
        if (workTypeCode.equals("prescribed_holiday")) {
            return this.getPrescribedHolidayAbbrNaming();
        }
        if (workTypeCode.equals("legal_holiday")) {
            return this.getLegalHolidayAbbrNaming();
        }
        WorkTypeDtoInterface dto = this.getWorkTypeInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        return dto.getWorkTypeAbbr();
    }

    public String getParticularWorkTypeName(String workTypeCode) {
        if ("work_on_legal".equals(workTypeCode)) {
            return this.getWorkOnLegalHolidayNaming();
        }
        if ("work_on_prescribed".equals(workTypeCode)) {
            return this.getWorkOnPrescribedHolidayNaming();
        }
        if ("legal_holiday".equals(workTypeCode)) {
            return this.getLegalHolidayNaming();
        }
        if ("prescribed_holiday".equals(workTypeCode)) {
            return this.getPrescribedHolidayNaming();
        }
        return null;
    }

    public String getWorkTypeNameAndTime(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeName());
        sb.append(this.getWorkBeginAndWorkEnd(dto));
        return sb.toString();
    }

    public String getWorkTypeAbbrAndTime(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeAbbr());
        sb.append(this.getWorkBeginAndWorkEnd(dto));
        return sb.toString();
    }

    public String getWorkTypeAbbrAndTime(String workTypeCode, Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeAbbr());
        sb.append(this.getWorkBeginAndWorkEnd(dto, amHoliday, pmHoliday));
        return sb.toString();
    }

    public String[][] getSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, true, false, false, false);
    }

    public String[][] getCodedSelectArray(Date targetDate) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = new String[list.size()][2];
        int idx = 0;
        int codeLength = 0;
        for (WorkTypeDtoInterface dto : list) {
            if (dto.getWorkTypeCode().length() <= codeLength) continue;
            codeLength = dto.getWorkTypeCode().length();
        }
        for (WorkTypeDtoInterface dto : list) {
            array[idx][0] = dto.getWorkTypeCode();
            array[idx][1] = this.getCodedName(dto.getWorkTypeCode(), dto.getWorkTypeAbbr(), codeLength);
            ++idx;
        }
        return array;
    }

    public String[][] getTimeSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, false, true, false, false);
    }

    public String[][] getTimeSelectArray(Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(targetDate, false, true, amHoliday, pmHoliday);
    }

    public String[][] getNameTimeSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, true, true, false, false);
    }

    public String[][] getNameTimeSelectArray(Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(targetDate, true, true, amHoliday, pmHoliday);
    }

    public WorkTypeDtoInterface findForKey(String workTypeCode, Date activateDate) throws MospException {
        return this.dao.findForKey(workTypeCode, activateDate);
    }

    public String[][] getSelectAbbrArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, false, false, false, false);
    }

    public WorkTypeDtoInterface findForInfo(String workTypeCode, Date activateDate) throws MospException {
        return this.dao.findForInfo(workTypeCode, activateDate);
    }

    public List<WorkTypeEntity> getWorkTypeEntityHistory(String workTypeCode) throws MospException {
        ArrayList<WorkTypeEntity> history = new ArrayList<WorkTypeEntity>();
        List list = this.getWorkTypeHistory(workTypeCode);
        for (WorkTypeDtoInterface dto : list) {
            Date activateDate = dto.getActivateDate();
            List itemList = this.workTypeItemDao.findForWorkType(workTypeCode, activateDate);
            history.add(new WorkTypeEntity(dto, itemList));
        }
        return history;
    }

    public WorkTypeEntity getWorkTypeEntity(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.getWorkTypeInfo(workTypeCode, targetDate);
        if (dto != null) {
            List list = this.workTypeItemDao.findForWorkType(workTypeCode, dto.getActivateDate());
            return new WorkTypeEntity(dto, list);
        }
        if (workTypeCode == null) {
            dto = this.getInitDto();
        } else if (workTypeCode.equals("work_on_legal")) {
            dto = this.getWorkOnLegalHolidayWorkType();
        } else if (workTypeCode.equals("work_on_prescribed")) {
            dto = this.getWorkOnPrescribedHolidayWorkType();
        } else if (workTypeCode.equals("legal_holiday")) {
            dto = this.getLegalHolidayWorkType();
        } else if (workTypeCode.equals("prescribed_holiday")) {
            dto = this.getPrescribedHolidayWorkType();
        } else {
            dto = this.getInitDto();
            dto.setWorkTypeCode(workTypeCode);
        }
        return new WorkTypeEntity(dto, new ArrayList());
    }

    protected String[][] getSelectArray(Date targetDate, boolean isName, boolean viewTime, boolean amHoliday, boolean pmHoliday) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), false);
        for (int i = 0; i < list.size(); ++i) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)list.get(i);
            StringBuffer sb = new StringBuffer();
            if (isName) {
                sb.append(dto.getWorkTypeName());
            } else {
                sb.append(dto.getWorkTypeAbbr());
            }
            if (viewTime) {
                sb.append(this.getWorkBeginAndWorkEnd(dto, amHoliday, pmHoliday));
            }
            array[i][0] = dto.getWorkTypeCode();
            array[i][1] = sb.toString();
        }
        return array;
    }

    protected String getWorkBeginAndWorkEnd(WorkTypeDtoInterface dto) throws MospException {
        WorkTypeItemDtoInterface workBeginDto = this.workTypeItemDao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), "WorkStart");
        WorkTypeItemDtoInterface workEndDto = this.workTypeItemDao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), "WorkEnd");
        Date defaultTime = DateUtility.getDefaultTime();
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
        sb.append(DateUtility.getStringTime((Date)workBeginDto.getWorkTypeItemValue(), (Date)defaultTime));
        sb.append(this.mospParams.getName("Wave"));
        sb.append(DateUtility.getStringTime((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultTime));
        sb.append(this.mospParams.getName("BackWithCornerParentheses"));
        return sb.toString();
    }

    protected String getWorkBeginAndWorkEnd(WorkTypeDtoInterface dto, boolean amHoliday, boolean pmHoliday) throws MospException {
        Date defaultTime = DateUtility.getDefaultTime();
        WorkTypeEntity workTypeEntity = this.getWorkTypeEntity(dto.getWorkTypeCode(), dto.getActivateDate());
        if (amHoliday) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getBackStartTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getBackEndTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("BackWithCornerParentheses"));
            return sb.toString();
        }
        if (pmHoliday) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getFrontStartTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getFrontEndTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("BackWithCornerParentheses"));
            return sb.toString();
        }
        return this.getWorkBeginAndWorkEnd(dto);
    }

    protected WorkTypeDtoInterface getWorkOnLegalHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("work_on_legal");
        dto.setWorkTypeAbbr(this.getWorkOnLegalHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getWorkOnPrescribedHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("work_on_prescribed");
        dto.setWorkTypeAbbr(this.getWorkOnPrescribedHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getLegalHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("legal_holiday");
        dto.setWorkTypeName(this.getLegalHolidayNaming());
        dto.setWorkTypeAbbr(this.getLegalHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getPrescribedHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("prescribed_holiday");
        dto.setWorkTypeName(this.getPrescribedHolidayNaming());
        dto.setWorkTypeAbbr(this.getPrescribedHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getInitDto() {
        TmmWorkTypeDto dto = new TmmWorkTypeDto();
        return dto;
    }

    protected String getPrescribedHolidayAbbrNaming() {
        return this.mospParams.getName("PrescribedAbbreviation") + this.mospParams.getName("Holiday");
    }

    protected String getLegalHolidayAbbrNaming() {
        return this.mospParams.getName("LegalAbbreviation") + this.mospParams.getName("Holiday");
    }

    protected String getWorkOnPrescribedHolidayAbbrNaming() {
        return this.mospParams.getName("PrescribedAbbreviation") + this.mospParams.getName("WorkingHoliday");
    }

    protected String getWorkOnLegalHolidayAbbrNaming() {
        return this.mospParams.getName("LegalAbbreviation") + this.mospParams.getName("WorkingHoliday");
    }

    protected String getPrescribedHolidayNaming() {
        return TimeNamingUtility.prescribedHoliday((MospParams)this.mospParams);
    }

    protected String getLegalHolidayNaming() {
        return TimeNamingUtility.legalHoliday((MospParams)this.mospParams);
    }

    protected String getWorkOnPrescribedHolidayNaming() {
        return this.mospParams.getName("Prescribed") + this.mospParams.getName("Holiday") + this.mospParams.getName("GoingWork");
    }

    protected String getWorkOnLegalHolidayNaming() {
        return this.mospParams.getName("Legal") + this.mospParams.getName("Holiday") + this.mospParams.getName("GoingWork");
    }
}

