/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.WorkTypeRegistBeanInterface;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeDto;

public class WorkTypeRegistBean
extends PlatformBean
implements WorkTypeRegistBeanInterface {
    WorkTypeDaoInterface dao;

    public WorkTypeRegistBean() {
    }

    public WorkTypeRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeDaoInterface)this.createDao(WorkTypeDaoInterface.class);
    }

    public WorkTypeDtoInterface getInitDto() {
        return new TmmWorkTypeDto();
    }

    public void insert(WorkTypeDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(WorkTypeDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(WorkTypeDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeId());
        dto.setTmmWorkTypeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            WorkTypeDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmWorkTypeId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeId());
            dto.setTmmWorkTypeId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(WorkTypeDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeId());
    }

    protected void checkInsert(WorkTypeDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkTypeCode()));
    }

    protected void checkAdd(WorkTypeDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List scheduleDateList = this.getScheduleDateListForCheck(dto.getWorkTypeCode(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkTypeCode(), scheduleDateList);
    }

    protected void checkUpdate(WorkTypeDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmWorkTypeId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode());
        List scheduleDateList = this.getScheduleDateListForCheck(dto.getWorkTypeCode(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkTypeCode(), scheduleDateList);
    }

    protected void checkDelete(WorkTypeDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeId());
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmWorkTypeId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List scheduleDateList = this.getScheduleDateListForCheck(dto.getWorkTypeCode(), (PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkTypeCode(), scheduleDateList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getWorkTypeCode());
        }
        return list;
    }

    protected void validate(WorkTypeDtoInterface dto) {
    }

    protected void checkCodeIsUsed(String code, List<ScheduleDateDtoInterface> list) {
        for (ScheduleDateDtoInterface dto : list) {
            if (!code.equals(dto.getWorkTypeCode())) continue;
            this.addCodeIsUsedMessage(code, dto);
            break;
        }
    }

    protected void addCodeIsUsedMessage(String code, ScheduleDateDtoInterface dto) {
        this.mospParams.addErrorMessage("TMW0225", new String[]{code, dto.getScheduleCode()});
    }

    protected List<ScheduleDateDtoInterface> getScheduleDateListForCheck(String code, PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ScheduleDateDaoInterface scheduleDateDao = (ScheduleDateDaoInterface)this.createDao(ScheduleDateDaoInterface.class);
        List scheduleDateList = scheduleDateDao.findForActivateDate(dto.getActivateDate(), code);
        scheduleDateList.addAll(scheduleDateDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list), code));
        return scheduleDateList;
    }
}

