/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.calculation.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.base.TotalTimeBaseAction;
import jp.mosp.time.calculation.vo.CutoffErrorListVo;
import jp.mosp.time.comparator.settings.CutoffErrorListDateComparator;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;

public class CutoffErrorListAction
extends TotalTimeBaseAction {
    public static final String CMD_SHOW = "TM3140";
    public static final String CMD_SORT = "TM3148";
    public static final String CMD_PAGE = "TM3149";

    protected BaseVo getSpecificVo() {
        return new CutoffErrorListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        CutoffErrorListVo vo = (CutoffErrorListVo)this.mospParams.getVo();
        this.getCutoffParams();
        this.setCutoffInfo();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setList(this.getCutoffErrorList());
        vo.setComparatorName(CutoffErrorListDateComparator.class.getName());
        vo.setAscending(false);
        this.mospParams.addErrorMessage("TMW0201", new String[0]);
        this.sort();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        CutoffErrorListVo vo = (CutoffErrorListVo)this.mospParams.getVo();
        String[] aryLblDate = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblWorkPlace = new String[list.size()];
        String[] aryLblEmployee = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblPosition = new String[list.size()];
        String[] aryLblType = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        Date cutoffTermTargetDate = vo.getCutoffTermTargetDate();
        String[][] aryWorkPlase = this.reference().workPlace().getSelectArray(cutoffTermTargetDate, false, null);
        String[][] aryEmployment = this.reference().employmentContract().getSelectArray(cutoffTermTargetDate, false, null);
        String[][] arySection = this.reference().section().getSelectArray(cutoffTermTargetDate, false, null);
        String[][] aryPosition = this.reference().position().getSelectArray(cutoffTermTargetDate, false, null);
        for (int i = 0; i < list.size(); ++i) {
            CutoffErrorListDtoInterface dto = (CutoffErrorListDtoInterface)list.get(i);
            aryLblDate[i] = DateUtility.getStringDateAndDay((Date)dto.getDate());
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getEmployeeName(dto.getPersonalId());
            aryLblWorkPlace[i] = MospUtility.getCodeName((String)dto.getWorkPlaceCode(), (String[][])aryWorkPlase);
            aryLblEmployee[i] = MospUtility.getCodeName((String)dto.getEmploymentCode(), (String[][])aryEmployment);
            aryLblSection[i] = MospUtility.getCodeName((String)dto.getSectionCode(), (String[][])arySection);
            aryLblPosition[i] = MospUtility.getCodeName((String)dto.getPositionCode(), (String[][])aryPosition);
            aryLblType[i] = dto.getType();
            aryLblState[i] = dto.getState();
        }
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblWorkPlace(aryLblWorkPlace);
        vo.setAryLblEmployment(aryLblEmployee);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblPosition(aryLblPosition);
        vo.setAryLblType(aryLblType);
        vo.setAryLblState(aryLblState);
    }

    protected List<? extends BaseDtoInterface> getCutoffErrorList() {
        return (List)this.mospParams.getGeneralParam("TotalTimeError");
    }
}

