/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdDifferenceRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdDifferenceRequestDao
extends PlatformDao
implements DifferenceRequestDaoInterface {
    public static final String TABLE = "tmd_difference_request";
    public static final String COL_TMD_DIFFERENCE_REQUEST_ID = "tmd_difference_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_DATE = "request_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_DIFFERENCE_TYPE = "difference_type";
    public static final String COL_WORK_TYPE_CODE = "work_type_code";
    public static final String COL_START_DATE = "start_date";
    public static final String COL_REQUEST_START = "request_start";
    public static final String COL_REQUEST_END = "request_end";
    public static final String COL_REQUEST_REASON = "request_reason";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_difference_request_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdDifferenceRequestDto dto = new TmdDifferenceRequestDto();
        dto.setTmdDifferenceRequestId(this.getLong("tmd_difference_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestDate(this.getDate("request_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setDifferenceType(this.getString("difference_type"));
        dto.setWorkTypeCode(this.getString("work_type_code"));
        dto.setStartDate(this.getInt("start_date"));
        dto.setRequestStart(this.getTimestamp("request_start"));
        dto.setRequestEnd(this.getTimestamp("request_end"));
        dto.setRequestReason(this.getString("request_reason"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<DifferenceRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<DifferenceRequestDtoInterface> all = new ArrayList<DifferenceRequestDtoInterface>();
        while (this.next()) {
            all.add((DifferenceRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<DifferenceRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String personalId = String.valueOf(param.get("personalId"));
            String workTypeCode = String.valueOf(param.get("workTypeCode"));
            Date requestStartDate = (Date)param.get("requestStartDate");
            Date requestEndDate = (Date)param.get("requestEndDate");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"personal_id"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.lessEqual((String)"request_date"));
            if (!workTypeCode.equals("")) {
                sb.append(TmdDifferenceRequestDao.and());
                sb.append(TmdDifferenceRequestDao.equal((String)"work_type_code"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, requestEndDate);
            if (!workTypeCode.equals("")) {
                this.setParam(this.index++, workTypeCode);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            DifferenceRequestDtoInterface dto = (DifferenceRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdDifferenceRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            DifferenceRequestDtoInterface dto = (DifferenceRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdDifferenceRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        DifferenceRequestDtoInterface dto = (DifferenceRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdDifferenceRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getDifferenceType());
        this.setParam(this.index++, dto.getWorkTypeCode());
        this.setParam(this.index++, dto.getStartDate());
        this.setParam(this.index++, (Date)new Time(dto.getRequestStart().getTime()), true);
        this.setParam(this.index++, (Date)new Time(dto.getRequestEnd().getTime()), true);
        this.setParam(this.index++, dto.getRequestReason());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public List<DifferenceRequestDtoInterface> findForList(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"personal_id"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.lessEqual((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public DifferenceRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"personal_id"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"request_date"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append("workflow");
            sb.append(TmdDifferenceRequestDao.in());
            sb.append(TmdDifferenceRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdDifferenceRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            DifferenceRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (DifferenceRequestDtoInterface)this.mapping();
            }
            DifferenceRequestDtoInterface differenceRequestDtoInterface = dto;
            return differenceRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public DifferenceRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            DifferenceRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (DifferenceRequestDtoInterface)this.mapping();
            }
            DifferenceRequestDtoInterface differenceRequestDtoInterface = dto;
            return differenceRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<DifferenceRequestDtoInterface> findForWorkflowStatus(String personalId, int workflowStage, String workflowStatus, String routeCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"personal_id"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append("workflow");
            sb.append(TmdDifferenceRequestDao.in());
            sb.append(TmdDifferenceRequestDao.leftParenthesis());
            boolean useRoute = routeCode != null && routeCode.length() != 0;
            sb.append(this.workflowDao.getSubQueryForSetting(true, true, useRoute, true));
            sb.append(TmdDifferenceRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workflowStage);
            this.setParam(this.index++, workflowStatus);
            if (useRoute) {
                this.setParam(this.index++, routeCode);
            }
            this.setParam(this.index++, "6");
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<DifferenceRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdDifferenceRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.equal((String)"personal_id"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdDifferenceRequestDao.and());
            sb.append(TmdDifferenceRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdDifferenceRequestDao.getOrderByColumn((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

