/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayDataDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdHolidayDataDao
extends PlatformDao
implements HolidayDataDaoInterface {
    public static final String TABLE = "tmd_holiday";
    public static final String COL_TMD_HOLIDAY_ID = "tmd_holiday_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_HOLIDAY_CODE = "holiday_code";
    public static final String COL_HOLIDAY_TYPE = "holiday_type";
    public static final String COL_GIVING_DAY = "giving_day";
    public static final String COL_CANCEL_DAY = "cancel_day";
    public static final String COL_HOLIDAY_LIMIT_DATE = "holiday_limit_date";
    public static final String COL_HOLIDAY_LIMIT_MONTH = "holiday_limit_month";
    public static final String COL_HOLIDAY_LIMIT_DAY = "holiday_limit_day";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmd_holiday_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmdHolidayDataDto dto = new TmdHolidayDataDto();
        dto.setTmdHolidayId(this.getLong("tmd_holiday_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setHolidayCode(this.getString("holiday_code"));
        dto.setHolidayType(this.getInt("holiday_type"));
        dto.setGivingDay(this.getDouble("giving_day"));
        dto.setCancelDay(this.getDouble("cancel_day"));
        dto.setHolidayLimitDate(this.getDate("holiday_limit_date"));
        dto.setHolidayLimitMonth(this.getInt("holiday_limit_month"));
        dto.setHolidayLimitDay(this.getInt("holiday_limit_day"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<HolidayDataDtoInterface> mappingAll() throws MospException {
        ArrayList<HolidayDataDtoInterface> all = new ArrayList<HolidayDataDtoInterface>();
        while (this.next()) {
            all.add((HolidayDataDtoInterface)this.mapping());
        }
        return all;
    }

    public HolidayDataDtoInterface findForKey(String personalId, Date activateDate, String holidayCode, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"personal_id"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"activate_date"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_code"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, holidayCode);
            this.setParam(this.index++, holidayType);
            this.executeQuery();
            HolidayDataDtoInterface dto = null;
            if (this.next()) {
                dto = (HolidayDataDtoInterface)this.mapping();
            }
            HolidayDataDtoInterface holidayDataDtoInterface = dto;
            return holidayDataDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public HolidayDataDtoInterface findForInfo(String personalId, Date activateDate, String holidayCode, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"personal_id"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_code"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.lessEqual((String)"activate_date"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.greaterEqual((String)"holiday_limit_date"));
            sb.append(TmdHolidayDataDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, holidayCode);
            this.setParam(this.index++, holidayType);
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            HolidayDataDtoInterface dto = null;
            if (this.next()) {
                dto = (HolidayDataDtoInterface)this.mapping();
            }
            HolidayDataDtoInterface holidayDataDtoInterface = dto;
            return holidayDataDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayDataDtoInterface> findForInfoList(String personalId, Date activateDate, String inactivateFlag, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"personal_id"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.lessEqual((String)"activate_date"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.greaterEqual((String)"holiday_limit_date"));
            if (!inactivateFlag.isEmpty()) {
                sb.append(TmdHolidayDataDao.and());
                sb.append(TmdHolidayDataDao.equal((String)"inactivate_flag"));
            }
            sb.append(TmdHolidayDataDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, holidayType);
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, activateDate);
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayDataDtoInterface> findPersonTerm(String personalId, Date startDate, Date endDate, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            if (startDate != null) {
                sb.append(TmdHolidayDataDao.and());
                sb.append(TmdHolidayDataDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(TmdHolidayDataDao.and());
                sb.append(TmdHolidayDataDao.lessEqual((String)"activate_date"));
            }
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"personal_id"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            this.prepareStatement(sb.toString());
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, holidayType);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayDataDtoInterface> findForEarliestList(String personalId, Date activateDate, String holidayCode, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"personal_id"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_code"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.lessEqual((String)"activate_date"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.greaterEqual((String)"holiday_limit_date"));
            sb.append(TmdHolidayDataDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, holidayCode);
            this.setParam(this.index++, holidayType);
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            HolidayDataDtoInterface dto = (HolidayDataDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdHolidayId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            HolidayDataDtoInterface dto = (HolidayDataDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdHolidayId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        HolidayDataDtoInterface dto = (HolidayDataDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdHolidayId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getHolidayCode());
        this.setParam(this.index++, dto.getHolidayType());
        this.setParam(this.index++, dto.getGivingDay());
        this.setParam(this.index++, dto.getCancelDay());
        this.setParam(this.index++, dto.getHolidayLimitDate());
        this.setParam(this.index++, dto.getHolidayLimitMonth());
        this.setParam(this.index++, dto.getHolidayLimitDay());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public StringBuffer getQueryForMaxActivateDate() {
        StringBuffer sb = new StringBuffer();
        sb.append("activate_date");
        sb.append(" IN (");
        sb.append("SELECT ");
        sb.append("MAX(activate_date)");
        sb.append(TmdHolidayDataDao.from((String)"tmd_holiday") + " AS A ");
        sb.append(TmdHolidayDataDao.where());
        sb.append("tmd_holiday.personal_id");
        sb.append(" = A.personal_id");
        sb.append(TmdHolidayDataDao.and());
        sb.append(this.deleteFlagOff());
        sb.append(TmdHolidayDataDao.and());
        sb.append("activate_date");
        sb.append(" <= ?");
        sb.append(")");
        return sb;
    }

    public List<HolidayDataDtoInterface> findForActivateDate(Date activateDate, String holidayCode, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_code"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmdHolidayDataDao.getOrderByColumn((String)"holiday_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, holidayCode);
            this.setParam(this.index++, holidayType);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayDataDtoInterface> findForTerm(Date fromActivateDate, Date toActivateDate, String holidayCode, int holidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayDataDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(TmdHolidayDataDao.and());
                sb.append(TmdHolidayDataDao.greaterEqual((String)"holiday_limit_date"));
            }
            if (toActivateDate != null) {
                sb.append(TmdHolidayDataDao.and());
                sb.append(TmdHolidayDataDao.less((String)"activate_date"));
            }
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_code"));
            sb.append(TmdHolidayDataDao.and());
            sb.append(TmdHolidayDataDao.equal((String)"holiday_type"));
            sb.append(TmdHolidayDataDao.getOrderByColumns((String[])new String[]{"holiday_type", "holiday_code", "activate_date", "holiday_limit_date"}));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.setParam(this.index++, holidayCode);
            this.setParam(this.index++, holidayType);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

