/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdOvertimeRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdOvertimeRequestDao
extends PlatformDao
implements OvertimeRequestDaoInterface {
    public static final String TABLE = "tmd_overtime_request";
    public static final String COL_TMD_OVERTIME_REQUEST_ID = "tmd_overtime_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_DATE = "request_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_OVERTIME_TYPE = "overtime_type";
    public static final String COL_REQUEST_TIME = "request_time";
    public static final String COL_REQUEST_REASON = "request_reason";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_overtime_request_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdOvertimeRequestDto dto = new TmdOvertimeRequestDto();
        dto.setTmdOvertimeRequestId(this.getLong("tmd_overtime_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestDate(this.getDate("request_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setOvertimeType(this.getInt("overtime_type"));
        dto.setRequestTime(this.getInt("request_time"));
        dto.setRequestReason(this.getString("request_reason"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<OvertimeRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<OvertimeRequestDtoInterface> all = new ArrayList<OvertimeRequestDtoInterface>();
        while (this.next()) {
            all.add((OvertimeRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<OvertimeRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String personalId = String.valueOf(param.get("personalId"));
            String overtimeType = String.valueOf(param.get("overtimeType"));
            Date requestStartDate = (Date)param.get("requestStartDate");
            Date requestEndDate = (Date)param.get("requestEndDate");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.lessEqual((String)"request_date"));
            if (!overtimeType.equals("")) {
                sb.append(TmdOvertimeRequestDao.and());
                sb.append(TmdOvertimeRequestDao.equal((String)"overtime_type"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, requestEndDate);
            if (!overtimeType.equals("")) {
                this.setParam(this.index++, Integer.parseInt(overtimeType));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<OvertimeRequestDtoInterface> findForList(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<OvertimeRequestDtoInterface> findForList(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.lessEqual((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<OvertimeRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdOvertimeRequestDao.getOrderByColumn((String)"request_date", (String)"overtime_type"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdOvertimeRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdOvertimeRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdOvertimeRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getOvertimeType());
        this.setParam(this.index++, dto.getRequestTime());
        this.setParam(this.index++, dto.getRequestReason());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public OvertimeRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            OvertimeRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (OvertimeRequestDtoInterface)this.mapping();
            }
            OvertimeRequestDtoInterface overtimeRequestDtoInterface = dto;
            return overtimeRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public OvertimeRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestDate, int overtimeType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"request_date"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"overtime_type"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append("workflow");
            sb.append(TmdOvertimeRequestDao.in());
            sb.append(TmdOvertimeRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdOvertimeRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.setParam(this.index++, overtimeType);
            this.executeQuery();
            OvertimeRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (OvertimeRequestDtoInterface)this.mapping();
            }
            OvertimeRequestDtoInterface overtimeRequestDtoInterface = dto;
            return overtimeRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<OvertimeRequestDtoInterface> findForWorkflowStatus(String personalId, int workflowStage, String workflowStatus, String routeCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdOvertimeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdOvertimeRequestDao.and());
            sb.append(TmdOvertimeRequestDao.equal((String)"personal_id"));
            sb.append(TmdOvertimeRequestDao.and());
            sb.append("workflow");
            sb.append(TmdOvertimeRequestDao.in());
            sb.append(TmdOvertimeRequestDao.leftParenthesis());
            boolean useRoute = routeCode != null && routeCode.length() != 0;
            sb.append(this.workflowDao.getSubQueryForSetting(true, true, useRoute, true));
            sb.append(TmdOvertimeRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workflowStage);
            this.setParam(this.index++, workflowStatus);
            if (useRoute) {
                this.setParam(this.index++, routeCode);
            }
            this.setParam(this.index++, "2");
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

