/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubHolidayRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdSubHolidayRequestDao
extends PlatformDao
implements SubHolidayRequestDaoInterface {
    public static final String TABLE = "tmd_sub_holiday_request";
    public static final String COL_TMD_SUB_HOLIDAY_REQUEST_ID = "tmd_sub_holiday_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_DATE = "request_date";
    public static final String COL_HOLIDAY_RANGE = "holiday_range";
    public static final String COL_WORK_DATE = "work_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_WORK_DATE_SUB_HOLIDAY_TYPE = "work_date_sub_holiday_type";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_sub_holiday_request_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdSubHolidayRequestDto dto = new TmdSubHolidayRequestDto();
        dto.setTmdSubHolidayRequestId(this.getLong("tmd_sub_holiday_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestDate(this.getDate("request_date"));
        dto.setHolidayRange(this.getInt("holiday_range"));
        dto.setWorkDate(this.getDate("work_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setWorkDateSubHolidayType(this.getInt("work_date_sub_holiday_type"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<SubHolidayRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<SubHolidayRequestDtoInterface> all = new ArrayList<SubHolidayRequestDtoInterface>();
        while (this.next()) {
            all.add((SubHolidayRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<SubHolidayRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String personalId = String.valueOf(param.get("personalId"));
            Date requestStartDate = (Date)param.get("requestStartDate");
            Date requestEndDate = (Date)param.get("requestEndDate");
            Date workStartDate = (Date)param.get("workStartDate");
            Date workEndDate = (Date)param.get("workEndDate");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.greaterEqual((String)"work_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.lessEqual((String)"work_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, requestEndDate);
            this.setParam(this.index++, workStartDate);
            this.setParam(this.index++, workEndDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public SubHolidayRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            SubHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (SubHolidayRequestDtoInterface)this.mapping();
            }
            SubHolidayRequestDtoInterface subHolidayRequestDtoInterface = dto;
            return subHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForList(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForList(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForList(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.lessEqual((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForList(String personalId, Date workDate, int timesWork, int workDateSubHolidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"work_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"times_work"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"work_date_sub_holiday_type"));
            sb.append(TmdSubHolidayRequestDao.getOrderByColumn((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.setParam(this.index++, timesWork);
            this.setParam(this.index++, workDateSubHolidayType);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.getOrderByColumn((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubHolidayRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubHolidayRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdSubHolidayRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestDate());
        this.setParam(this.index++, dto.getHolidayRange());
        this.setParam(this.index++, dto.getWorkDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getWorkDateSubHolidayType());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public SubHolidayRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestDate, int holidayRange) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"request_date"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"holiday_range"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdSubHolidayRequestDao.in());
            sb.append(TmdSubHolidayRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdSubHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.setParam(this.index++, holidayRange);
            this.executeQuery();
            SubHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (SubHolidayRequestDtoInterface)this.mapping();
            }
            SubHolidayRequestDtoInterface subHolidayRequestDtoInterface = dto;
            return subHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForWorkflowStatus(String personalId, int workflowStage, String workflowStatus, String routeCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdSubHolidayRequestDao.in());
            sb.append(TmdSubHolidayRequestDao.leftParenthesis());
            boolean useRoute = routeCode != null && routeCode.length() != 0;
            sb.append(this.workflowDao.getSubQueryForSetting(true, true, useRoute, true));
            sb.append(TmdSubHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workflowStage);
            this.setParam(this.index++, workflowStatus);
            if (useRoute) {
                this.setParam(this.index++, routeCode);
            }
            this.setParam(this.index++, "5");
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayRequestDtoInterface> findForWorkDate(String personalId, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayRequestDao.and());
            sb.append(TmdSubHolidayRequestDao.equal((String)"work_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

