/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdWorkOnHolidayRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdWorkOnHolidayRequestDao
extends PlatformDao
implements WorkOnHolidayRequestDaoInterface {
    public static final String TABLE = "tmd_work_on_holiday_request";
    public static final String COL_TMD_WORK_ON_HOLIDAY_REQUEST_ID = "tmd_work_on_holiday_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_DATE = "request_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_WORK_ON_HOLIDAY_TYPE = "work_on_holiday_type";
    public static final String COL_SUBSTITUTE = "substitute";
    public static final String COL_WORK_TYPE_CODE = "work_type_code";
    public static final String COL_START_TIME = "start_time";
    public static final String COL_END_TIME = "end_time";
    public static final String COL_REQUEST_REASON = "request_reason";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_work_on_holiday_request_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdWorkOnHolidayRequestDto dto = new TmdWorkOnHolidayRequestDto();
        dto.setTmdWorkOnHolidayRequestId(this.getLong("tmd_work_on_holiday_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestDate(this.getDate("request_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setWorkOnHolidayType(this.getString("work_on_holiday_type"));
        dto.setSubstitute(this.getInt("substitute"));
        dto.setWorkTypeCode(this.getString("work_type_code"));
        dto.setStartTime(this.getTimestamp("start_time"));
        dto.setEndTime(this.getTimestamp("end_time"));
        dto.setRequestReason(this.getString("request_reason"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<WorkOnHolidayRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<WorkOnHolidayRequestDtoInterface> all = new ArrayList<WorkOnHolidayRequestDtoInterface>();
        while (this.next()) {
            all.add((WorkOnHolidayRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<WorkOnHolidayRequestDtoInterface> findForHistory(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.getOrderByColumn((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public WorkOnHolidayRequestDtoInterface findForInfo(String personalId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append("request_date");
            sb.append(" <= ? ");
            sb.append(TmdWorkOnHolidayRequestDao.getOrderByColumnDescLimit1((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            WorkOnHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkOnHolidayRequestDtoInterface)this.mapping();
            }
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDtoInterface = dto;
            return workOnHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public WorkOnHolidayRequestDtoInterface findForKey(String personalId, Date requestDate, int timesWork) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"times_work"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate, false);
            this.setParam(this.index++, timesWork);
            this.executeQuery();
            WorkOnHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkOnHolidayRequestDtoInterface)this.mapping();
            }
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDtoInterface = dto;
            return workOnHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkOnHolidayRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String personalId = String.valueOf(param.get("personalId"));
            String substitute = String.valueOf(param.get("substitute"));
            Date requestStartDate = (Date)param.get("requestStartDate");
            Date requestEndDate = (Date)param.get("requestEndDate");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.lessEqual((String)"request_date"));
            if (!substitute.equals("")) {
                sb.append(TmdWorkOnHolidayRequestDao.and());
                sb.append(TmdWorkOnHolidayRequestDao.equal((String)"substitute"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, requestEndDate);
            if (!substitute.equals("")) {
                this.setParam(this.index++, Integer.parseInt(substitute));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkOnHolidayRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.getOrderByColumn((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.comma());
            sb.append("workflow");
            sb.append(TmdWorkOnHolidayRequestDao.getDesc());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdWorkOnHolidayRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdWorkOnHolidayRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdWorkOnHolidayRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getWorkOnHolidayType());
        this.setParam(this.index++, dto.getSubstitute());
        this.setParam(this.index++, dto.getWorkTypeCode());
        this.setParam(this.index++, dto.getStartTime(), true);
        this.setParam(this.index++, dto.getEndTime(), true);
        this.setParam(this.index++, dto.getRequestReason());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public WorkOnHolidayRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdWorkOnHolidayRequestDao.in());
            sb.append(TmdWorkOnHolidayRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdWorkOnHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            WorkOnHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkOnHolidayRequestDtoInterface)this.mapping();
            }
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDtoInterface = dto;
            return workOnHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public WorkOnHolidayRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            WorkOnHolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkOnHolidayRequestDtoInterface)this.mapping();
            }
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDtoInterface = dto;
            return workOnHolidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkOnHolidayRequestDtoInterface> findForWorkflowStatus(String personalId, int workflowStage, String workflowStatus, String routeCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdWorkOnHolidayRequestDao.in());
            sb.append(TmdWorkOnHolidayRequestDao.leftParenthesis());
            boolean useRoute = routeCode != null && routeCode.length() != 0;
            sb.append(this.workflowDao.getSubQueryForSetting(true, true, useRoute, true));
            sb.append(TmdWorkOnHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workflowStage);
            this.setParam(this.index++, workflowStatus);
            if (useRoute) {
                this.setParam(this.index++, routeCode);
            }
            this.setParam(this.index++, "4");
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkOnHolidayRequestDtoInterface> findForList(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.leftParenthesis());
            sb.append(TmdWorkOnHolidayRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkOnHolidayRequestDtoInterface> findForSubstitute(String personalId, Date requestDate, int timesWork) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkOnHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"request_date"));
            sb.append(TmdWorkOnHolidayRequestDao.and());
            sb.append(TmdWorkOnHolidayRequestDao.equal((String)"times_work"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate, false);
            this.setParam(this.index++, timesWork);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

