/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmCutoffDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmmCutoffDao
extends PlatformDao
implements CutoffDaoInterface {
    public static final String TABLE = "tmm_cutoff";
    public static final String COL_TMM_CUTOFF_ID = "tmm_cutoff_id";
    public static final String COL_CUTOFF_CODE = "cutoff_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_CUTOFF_NAME = "cutoff_name";
    public static final String COL_CUTOFF_ABBR = "cutoff_abbr";
    public static final String COL_CUTOFF_DATE = "cutoff_date";
    public static final String COL_CUTOFF_TYPE = "cutoff_type";
    public static final String COL_NO_APPROVAL = "no_approval";
    public static final String COL_SELF_TIGHTENING = "self_tightening";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmm_cutoff_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmmCutoffDto dto = new TmmCutoffDto();
        dto.setTmmCutoffId(this.getLong("tmm_cutoff_id"));
        dto.setCutoffCode(this.getString("cutoff_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setCutoffName(this.getString("cutoff_name"));
        dto.setCutoffAbbr(this.getString("cutoff_abbr"));
        dto.setCutoffDate(this.getInt("cutoff_date"));
        dto.setCutoffType(this.getString("cutoff_type"));
        dto.setNoApproval(this.getInt("no_approval"));
        dto.setSelfTightening(this.getInt("self_tightening"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<CutoffDtoInterface> mappingAll() throws MospException {
        ArrayList<CutoffDtoInterface> all = new ArrayList<CutoffDtoInterface>();
        while (this.next()) {
            all.add((CutoffDtoInterface)this.mapping());
        }
        return all;
    }

    public List<CutoffDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmCutoffDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmCutoffDao.and());
            sb.append("inactivate_flag");
            sb.append(" = 0 ");
            sb.append(TmmCutoffDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmCutoffDao.getOrderByColumn((String)"cutoff_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CutoffDtoInterface> findForHistory(String cutoffCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmCutoffDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.equal((String)"cutoff_code"));
            sb.append(TmmCutoffDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, cutoffCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CutoffDtoInterface findForKey(String cutoffCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmCutoffDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.equal((String)"cutoff_code"));
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, cutoffCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            CutoffDtoInterface dto = null;
            if (this.next()) {
                dto = (CutoffDtoInterface)this.mapping();
            }
            CutoffDtoInterface cutoffDtoInterface = dto;
            return cutoffDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CutoffDtoInterface findForInfo(String cutoffCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmCutoffDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmCutoffDao.and());
            if (!cutoffCode.isEmpty()) {
                sb.append(TmmCutoffDao.equal((String)"cutoff_code"));
                sb.append(TmmCutoffDao.and());
            }
            sb.append("activate_date");
            sb.append(" <= ? ");
            sb.append(TmmCutoffDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (!cutoffCode.isEmpty()) {
                this.setParam(this.index++, cutoffCode);
            }
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            CutoffDtoInterface dto = null;
            if (this.next()) {
                dto = (CutoffDtoInterface)this.mapping();
            }
            CutoffDtoInterface cutoffDtoInterface = dto;
            return cutoffDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CutoffDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            Date activateDate = (Date)param.get("targetDate");
            String cutoffCode = String.valueOf(param.get("cutoffCode"));
            String cutoffName = String.valueOf(param.get("cutoffName"));
            String cutoffAbbr = String.valueOf(param.get("cutoffAbbr"));
            String cutoffDate = String.valueOf(param.get("cutoffDate"));
            String noApproval = String.valueOf(param.get("noApproval"));
            String selfTightening = String.valueOf(param.get("selfTightening"));
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmCutoffDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.like((String)"cutoff_code"));
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.like((String)"cutoff_name"));
            sb.append(TmmCutoffDao.and());
            sb.append(TmmCutoffDao.like((String)"cutoff_abbr"));
            if (!cutoffDate.isEmpty()) {
                sb.append(TmmCutoffDao.and());
                sb.append(TmmCutoffDao.equal((String)"cutoff_date"));
            }
            if (!noApproval.isEmpty()) {
                sb.append(TmmCutoffDao.and());
                sb.append(TmmCutoffDao.equal((String)"no_approval"));
            }
            if (!selfTightening.isEmpty()) {
                sb.append(TmmCutoffDao.and());
                sb.append(TmmCutoffDao.equal((String)"self_tightening"));
            }
            if (!inactivateFlag.isEmpty()) {
                sb.append(TmmCutoffDao.and());
                sb.append(TmmCutoffDao.equal((String)"inactivate_flag"));
            }
            if (activateDate != null) {
                sb.append(TmmCutoffDao.and());
                sb.append(this.getQueryForMaxActivateDate());
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, TmmCutoffDao.startWithParam((String)cutoffCode));
            this.setParam(this.index++, TmmCutoffDao.containsParam((String)cutoffName));
            this.setParam(this.index++, TmmCutoffDao.containsParam((String)cutoffAbbr));
            if (!cutoffDate.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(cutoffDate));
            }
            if (!noApproval.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(noApproval));
            }
            if (!selfTightening.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(selfTightening));
            }
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            if (activateDate != null) {
                this.setParam(this.index++, activateDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            CutoffDtoInterface dto = (CutoffDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmCutoffId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            CutoffDtoInterface dto = (CutoffDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmCutoffId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        CutoffDtoInterface dto = (CutoffDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmmCutoffId());
        this.setParam(this.index++, dto.getCutoffCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getCutoffName());
        this.setParam(this.index++, dto.getCutoffAbbr());
        this.setParam(this.index++, dto.getCutoffDate());
        this.setParam(this.index++, dto.getCutoffType());
        this.setParam(this.index++, dto.getNoApproval());
        this.setParam(this.index++, dto.getSelfTightening());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public StringBuffer getQueryForMaxActivateDate() {
        StringBuffer sb = new StringBuffer();
        sb.append("activate_date");
        sb.append(TmmCutoffDao.in());
        sb.append("(SELECT MAX(");
        sb.append("activate_date");
        sb.append(")");
        sb.append(TmmCutoffDao.from((String)"tmm_cutoff"));
        sb.append("AS A ");
        sb.append(TmmCutoffDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(TmmCutoffDao.and());
        sb.append("tmm_cutoff.cutoff_code");
        sb.append(" = A.cutoff_code");
        sb.append(TmmCutoffDao.and());
        sb.append("activate_date");
        sb.append(" <= ?)");
        return sb;
    }
}

