/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmScheduleDateDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmmScheduleDateDao
extends PlatformDao
implements ScheduleDateDaoInterface {
    public static final String TABLE = "tmm_schedule_date";
    public static final String COL_TMM_SCHEDULE_DATE_ID = "tmm_schedule_date_id";
    public static final String COL_SCHEDULE_CODE = "schedule_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_SCHEDULE_DATE = "schedule_date";
    public static final String COL_WORKS = "works";
    public static final String COL_WORK_TYPE_CODE = "work_type_code";
    public static final String COL_REMARK = "remark";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmm_schedule_date_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmmScheduleDateDto dto = new TmmScheduleDateDto();
        dto.setTmmScheduleDateId(this.getLong("tmm_schedule_date_id"));
        dto.setScheduleCode(this.getString("schedule_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setScheduleDate(this.getDate("schedule_date"));
        dto.setWorks(this.getInt("works"));
        dto.setWorkTypeCode(this.getString("work_type_code"));
        dto.setRemark(this.getString("remark"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<ScheduleDateDtoInterface> mappingAll() throws MospException {
        ArrayList<ScheduleDateDtoInterface> all = new ArrayList<ScheduleDateDtoInterface>();
        while (this.next()) {
            all.add((ScheduleDateDtoInterface)this.mapping());
        }
        return all;
    }

    public ScheduleDateDtoInterface findForKey(String scheduleCode, Date scheduleDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDateDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"schedule_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.setParam(this.index++, scheduleDate);
            this.executeQuery();
            ScheduleDateDtoInterface dto = null;
            if (this.next()) {
                dto = (ScheduleDateDtoInterface)this.mapping();
            }
            ScheduleDateDtoInterface scheduleDateDtoInterface = dto;
            return scheduleDateDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ScheduleDateDtoInterface> findForList(String scheduleCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDateDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"activate_date"));
            sb.append(TmmScheduleDateDao.getOrderByColumn((String)"schedule_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            ScheduleDateDtoInterface dto = (ScheduleDateDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmScheduleDateId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            ScheduleDateDtoInterface dto = (ScheduleDateDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmScheduleDateId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        ScheduleDateDtoInterface dto = (ScheduleDateDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmmScheduleDateId());
        this.setParam(this.index++, dto.getScheduleCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getScheduleDate());
        this.setParam(this.index++, dto.getWorks());
        this.setParam(this.index++, dto.getWorkTypeCode());
        this.setParam(this.index++, dto.getRemark());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public List<ScheduleDateDtoInterface> findForList(String scheduleCode, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDateDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"schedule_code"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.greaterEqual((String)"schedule_date"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.lessEqual((String)"schedule_date"));
            sb.append(TmmScheduleDateDao.getOrderByColumn((String)"schedule_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, scheduleCode);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ScheduleDateDtoInterface> findForActivateDate(Date activateDate, String targetCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDateDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"work_type_code"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmScheduleDateDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmScheduleDateDao.getOrderByColumn((String)"schedule_code", (String)"schedule_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, targetCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ScheduleDateDtoInterface> findForTerm(Date fromActivateDate, Date toActivateDate, String targetCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmScheduleDateDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(TmmScheduleDateDao.and());
                sb.append(TmmScheduleDateDao.greater((String)"activate_date"));
            }
            if (toActivateDate != null) {
                sb.append(TmmScheduleDateDao.and());
                sb.append(TmmScheduleDateDao.less((String)"activate_date"));
            }
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"work_type_code"));
            sb.append(TmmScheduleDateDao.and());
            sb.append(TmmScheduleDateDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmScheduleDateDao.getOrderByColumn((String)"work_type_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.setParam(this.index++, targetCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public StringBuffer getQueryForMaxActivateDate() {
        StringBuffer sb = new StringBuffer();
        sb.append("activate_date");
        sb.append(TmmScheduleDateDao.in());
        sb.append(TmmScheduleDateDao.leftParenthesis());
        sb.append(TmmScheduleDateDao.selectMax((String)"activate_date"));
        sb.append(TmmScheduleDateDao.from((String)"tmm_schedule_date"));
        sb.append(TmmScheduleDateDao.asTmpTable((String)"tmm_schedule_date"));
        sb.append(TmmScheduleDateDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(TmmScheduleDateDao.and());
        sb.append(TmmScheduleDateDao.equalTmpColumn((String)"tmm_schedule_date", (String)"schedule_code"));
        sb.append(TmmScheduleDateDao.and());
        sb.append(TmmScheduleDateDao.equalTmpColumn((String)"tmm_schedule_date", (String)"schedule_date"));
        sb.append(TmmScheduleDateDao.and());
        sb.append(TmmScheduleDateDao.lessEqual((String)"activate_date"));
        sb.append(TmmScheduleDateDao.rightParenthesis());
        return sb;
    }
}

