/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceTransactionDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.TotalTimeEntityInterface;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.TimeUtility;
import jp.mosp.time.utils.TotalTimeUtility;

public class TotalTimeEntity
implements TotalTimeEntityInterface {
    protected static final int PREDETERMINED_OVERTIME_WORK = 40;
    protected static final int LEGAL_OVERTIME_WORK = 45;
    protected String personalId;
    protected int calculationYear;
    protected int calculationMonth;
    protected String cutoffCode;
    protected Date cutoffFirstDate;
    protected Date cutoffLastDate;
    protected List<Date> targetDateList = Collections.emptyList();
    protected List<SuspensionDtoInterface> suspensionList;
    protected Set<HolidayDtoInterface> holidaySet;
    protected Map<Date, ApplicationDtoInterface> applicationMap;
    protected Map<Date, TimeSettingDtoInterface> timeSettingMap;
    protected Map<Date, String> scheduleMap;
    protected Map<Date, String> substitutedMap;
    protected Map<String, List<WorkTypeEntity>> workTypeEntityMap;
    protected List<AttendanceDtoInterface> attendanceList = Collections.emptyList();
    protected List<WorkOnHolidayRequestDtoInterface> workOnHolidayRequestList;
    protected List<HolidayRequestDtoInterface> holidayRequestList = Collections.emptyList();
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList;
    protected List<DifferenceRequestDtoInterface> differenceRequestList;
    protected List<SubstituteDtoInterface> substitubeList;
    protected List<SubHolidayDtoInterface> subHolidayList;
    protected Map<Long, WorkflowDtoInterface> workflowMap;
    protected Set<AttendanceTransactionDtoInterface> attendanceTransactionSet;
    protected Map<Date, String> attendanceTransactionMap;
    protected Map<Date, RequestEntity> requestEntityMap;
    protected int workTime = 0;
    protected int contractWorkTime = 0;
    protected double timesWorkDate = 0.0;
    protected int timesWork = 0;
    protected double legalWorkOnHoliday = 0.0;
    protected double specificWorkOnHoliday = 0.0;
    protected int timesAchievement = 0;
    protected int timesTotalWorkDate = 0;
    protected int directStart = 0;
    protected int directEnd = 0;
    protected int restTime = 0;
    protected int restLateNight = 0;
    protected int restWorkOnSpecificHoliday = 0;
    protected int restWorkOnHoliday = 0;
    protected int publicTime = 0;
    protected int privateTime = 0;
    protected int minutelyHolidayATime = 0;
    protected int minutelyHolidayBTime = 0;
    protected int overtime = 0;
    protected int overtimeIn = 0;
    protected int overtimeOut = 0;
    protected int lateNight = 0;
    protected int nightWorkWithinPrescribedWork = 0;
    protected int nightOvertimeWork = 0;
    protected int nightWorkOnHoliday = 0;
    protected int workOnSpecificHoliday = 0;
    protected int workOnHoliday = 0;
    protected int decreaseTime = 0;
    protected int fortyFiveHourOvertime = 0;
    protected int timesOvertime = 0;
    protected int timesWorkingHoliday = 0;
    protected int lateDays = 0;
    protected int lateThirtyMinutesOrMore = 0;
    protected int lateLessThanThirtyMinutes = 0;
    protected int lateTime = 0;
    protected int lateThirtyMinutesOrMoreTime = 0;
    protected int lateLessThanThirtyMinutesTime = 0;
    protected int timesLate = 0;
    protected int leaveEarlyDays = 0;
    protected int leaveEarlyThirtyMinutesOrMore = 0;
    protected int leaveEarlyLessThanThirtyMinutes = 0;
    protected int leaveEarlyTime = 0;
    protected int leaveEarlyThirtyMinutesOrMoreTime = 0;
    protected int leaveEarlyLessThanThirtyMinutesTime = 0;
    protected int timesLeaveEarly = 0;
    protected int timesHoliday = 0;
    protected int timesLegalHoliday = 0;
    protected int timesSpecificHoliday = 0;
    protected double timesPaidHoliday = 0.0;
    protected int paidHolidayHour = 0;
    protected double timesStockHoliday = 0.0;
    protected double timesCompensation = 0.0;
    protected double timesLegalCompensation = 0.0;
    protected double timesSpecificCompensation = 0.0;
    protected double timesLateCompensation = 0.0;
    protected double timesHolidaySubstitute = 0.0;
    protected double timesLegalHolidaySubstitute = 0.0;
    protected double timesSpecificHolidaySubstitute = 0.0;
    protected double totalSpecialHoliday = 0.0;
    protected double totalOtherHoliday = 0.0;
    protected double totalAbsence = 0.0;
    protected int totalAllowance = 0;
    protected int sixtyHourOvertime = 0;
    protected int workdayOvertimeIn = 0;
    protected int prescribedHolidayOvertimeIn = 0;
    protected int workdayOvertimeOut = 0;
    protected int prescribedOvertimeOut = 0;
    protected double timesAlternative = 0.0;
    protected double legalCompensationOccurred = 0.0;
    protected double specificCompensationOccurred = 0.0;
    protected double lateCompensationOccurred = 0.0;
    protected double legalCompensationUnused = 0.0;
    protected double specificCompensationUnused = 0.0;
    protected double lateCompensationUnused = 0.0;
    protected int statutoryHolidayWorkTimeIn = 0;
    protected int statutoryHolidayWorkTimeOut = 0;
    protected int prescribedHolidayWorkTimeIn = 0;
    protected int prescribedHolidayWorkTimeOut = 0;
    protected int shortUnpaid = 0;
    protected int weeklyOverFortyHourWorkTime = 0;
    protected int overtimeInNoWeeklyForty = 0;
    protected int overtimeOutNoWeeklyForty = 0;
    protected int weekDayOvertimeInNoWeeklyForty = 0;
    protected int weekDayOvertimeOutNoWeeklyForty = 0;
    protected int generalIntItem1 = 0;
    protected int generalIntItem2 = 0;
    protected int generalIntItem3 = 0;
    protected int generalIntItem4 = 0;
    protected int generalIntItem5 = 0;
    protected int generalDoubleItem1 = 0;
    protected int generalDoubleItem2 = 0;
    protected int generalDoubleItem3 = 0;
    protected int generalDoubleItem4 = 0;
    protected int generalDoubleItem5 = 0;
    protected Map<String, Float> specialHolidayMap;
    protected Map<String, Float> otherHolidayMap;
    protected Map<String, Float> absenceMap;
    protected boolean isCompleted = true;

    public TotalTimeEntity() {
        this.workOnHolidayRequestList = Collections.emptyList();
        this.overtimeRequestList = Collections.emptyList();
        this.workTypeChangeRequestList = Collections.emptyList();
        this.differenceRequestList = Collections.emptyList();
        this.substitubeList = Collections.emptyList();
        this.subHolidayRequestList = Collections.emptyList();
        this.subHolidayList = Collections.emptyList();
        this.holidaySet = Collections.emptySet();
        this.attendanceTransactionSet = Collections.emptySet();
        this.timeSettingMap = Collections.emptyMap();
    }

    public void total() {
        this.setInitFileds();
        this.totalAttendance();
        this.totalScheduledHoliday();
        this.totalPaidHoliday();
        this.totalHoliday();
        this.totalSubstituteHoliday();
        this.totalSubHoliday();
        this.totalOccurredSubHoliday();
        this.totalUnusedSubHoliday();
        this.addHolidayShortUnpaid();
        this.calcWeeklyForty();
        this.calcExtraOverTime();
        this.totalGeneralItem();
        this.setAttendanceTransactionMap();
        this.totalWorkTimes();
    }

    protected void totalAttendance() {
        for (Date targetDate : this.targetDateList) {
            RequestEntity entity;
            if (HumanUtility.isSuspension((List)this.suspensionList, (Date)targetDate) || !(entity = this.getRequestEntity(targetDate)).isAttendanceApplied()) continue;
            AttendanceDtoInterface dto = entity.getAttendanceDto();
            this.calcWorkTime(entity);
            this.calcHolidayRestTime(entity);
            this.calcOvertime(entity);
            this.calcLeaveLateTime(dto);
            this.calcHolidayWorkTime(dto);
            this.calcContractWorkTime(dto);
        }
    }

    protected void totalScheduledHoliday() {
        for (Date targetDate : this.targetDateList) {
            RequestEntity entity;
            if (HumanUtility.isSuspension((List)this.suspensionList, (Date)targetDate) || (entity = this.getRequestEntity(targetDate)).isAttendanceApplied() || entity.isWorkOnHolidaySubstitute(this.isCompleted)) continue;
            String workTypeCode = (String)this.scheduleMap.get(targetDate);
            if (TimeUtility.isPrescribedHoliday((String)workTypeCode)) {
                ++this.timesSpecificHoliday;
            }
            if (!TimeUtility.isLegalHoliday((String)workTypeCode)) continue;
            ++this.timesLegalHoliday;
        }
        this.timesHoliday = this.timesSpecificHoliday + this.timesLegalHoliday;
    }

    protected void totalSubstituteHoliday() {
        for (SubstituteDtoInterface dto : this.substitubeList) {
            Date targetDate = dto.getSubstituteDate();
            RequestEntity entity = this.getRequestEntity(targetDate);
            if (entity.isWorkOnHolidaySubstitute(this.isCompleted) || entity.isWorkOnHolidayNotSubstitute(this.isCompleted)) continue;
            int range = dto.getSubstituteRange();
            String substituteType = dto.getSubstituteType();
            float amount = 0.0f;
            if (range == 1) {
                amount += 1.0f;
            }
            if (range == 2 || range == 3) {
                amount = 0.5f;
            }
            this.timesHolidaySubstitute += (double)amount;
            if (TimeUtility.isLegalHoliday((String)substituteType)) {
                this.timesLegalHolidaySubstitute += (double)amount;
            }
            if (!TimeUtility.isPrescribedHoliday((String)substituteType)) continue;
            this.timesSpecificHolidaySubstitute += (double)amount;
        }
    }

    protected void totalPaidHoliday() {
        for (HolidayRequestDtoInterface dto : this.holidayRequestList) {
            String holidayCode = dto.getHolidayType2();
            int holidayType = dto.getHolidayType1();
            int holidayRange = dto.getHolidayRange();
            if (holidayType != 1) continue;
            if (holidayCode.equals(String.valueOf(1))) {
                if (holidayRange == 1) {
                    this.timesPaidHoliday += 1.0;
                }
                if (holidayRange == 2 || holidayRange == 3) {
                    this.timesPaidHoliday += 0.5;
                }
                if (holidayRange == 4) {
                    this.paidHolidayHour += dto.getUseHour();
                }
            }
            if (!holidayCode.equals(String.valueOf(2))) continue;
            if (holidayRange == 1) {
                this.timesStockHoliday += 1.0;
            }
            if (holidayRange != 2 && holidayRange != 3) continue;
            this.timesStockHoliday += 0.5;
        }
    }

    protected void totalHoliday() {
        int holidayType;
        String holidayCode;
        this.specialHolidayMap = new HashMap();
        this.otherHolidayMap = new HashMap();
        this.absenceMap = new HashMap();
        for (HolidayDtoInterface dto : this.holidaySet) {
            holidayCode = dto.getHolidayCode();
            holidayType = dto.getHolidayType();
            this.addHolidayTimes(holidayCode, holidayType, 0.0f);
        }
        for (HolidayDtoInterface dto : this.holidayRequestList) {
            holidayCode = dto.getHolidayType2();
            holidayType = dto.getHolidayType1();
            int holidayRange = dto.getHolidayRange();
            float times = 0.0f;
            if (holidayRange == 1) {
                times = DateUtility.getDayDifference((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate()) + 1;
            }
            if (holidayRange == 2 || holidayRange == 3) {
                times = 0.5f;
            }
            if (times <= 1.0f) {
                this.addHolidayTimes(holidayCode, holidayType, times);
                continue;
            }
            times = 0.0f;
            List holidayDateList = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
            for (Date targetDate : holidayDateList) {
                String workTypeCode;
                if (!DateUtility.isTermContain((Date)targetDate, (Date)this.cutoffFirstDate, (Date)this.cutoffLastDate) || (workTypeCode = this.getScheduledWorkTypeCode(targetDate)) == null || TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) continue;
                times += 1.0f;
            }
            this.addHolidayTimes(holidayCode, holidayType, times);
        }
        this.totalSpecialHoliday = this.totalHoliday(this.specialHolidayMap);
        this.totalOtherHoliday = this.totalHoliday(this.otherHolidayMap);
        this.totalAbsence = this.totalHoliday(this.absenceMap);
    }

    protected void totalSubHoliday() {
        for (SubHolidayRequestDtoInterface dto : this.subHolidayRequestList) {
            if (this.cutoffFirstDate.after(dto.getRequestDate())) continue;
            int workDateSubHolidayType = dto.getWorkDateSubHolidayType();
            int holidayRange = dto.getHolidayRange();
            float amount = 0.0f;
            if (holidayRange == 1) {
                amount += 1.0f;
            }
            if (holidayRange == 2 || holidayRange == 3) {
                amount = 0.5f;
            }
            this.timesCompensation += (double)amount;
            if (workDateSubHolidayType == 2) {
                this.timesLegalCompensation += (double)amount;
            }
            if (workDateSubHolidayType == 1) {
                this.timesSpecificCompensation += (double)amount;
            }
            if (workDateSubHolidayType != 3) continue;
            this.timesLateCompensation += (double)amount;
        }
    }

    protected void totalOccurredSubHoliday() {
        for (SubHolidayDtoInterface dto : this.subHolidayList) {
            if (this.cutoffFirstDate.after(dto.getWorkDate())) continue;
            int subHolidayType = dto.getSubHolidayType();
            double subHolidayDays = dto.getSubHolidayDays();
            if (subHolidayType == 2) {
                this.legalCompensationOccurred += subHolidayDays;
            }
            if (subHolidayType == 1) {
                this.specificCompensationOccurred += subHolidayDays;
            }
            if (subHolidayType != 3) continue;
            this.lateCompensationOccurred += subHolidayDays;
        }
    }

    protected void totalUnusedSubHoliday() {
        for (SubHolidayDtoInterface subHolidayDto : this.subHolidayList) {
            if (!this.isSubHolidayExpired(subHolidayDto)) continue;
            double subHolidayDays = subHolidayDto.getSubHolidayDays();
            int subHolidayType = subHolidayDto.getSubHolidayType();
            Date workDate = subHolidayDto.getWorkDate();
            double useDays = 0.0;
            for (SubHolidayRequestDtoInterface dto : this.subHolidayRequestList) {
                if (workDate.compareTo(dto.getWorkDate()) != 0 || subHolidayType != dto.getWorkDateSubHolidayType()) continue;
                int range = dto.getHolidayRange();
                if (range == 1) {
                    useDays += 1.0;
                }
                if (range != 2 && range != 3) continue;
                useDays += 0.5;
            }
            double unusedDays = subHolidayDays - useDays;
            if (subHolidayType == 1) {
                this.specificCompensationUnused += unusedDays;
            }
            if (subHolidayType == 2) {
                this.legalCompensationUnused += unusedDays;
            }
            if (subHolidayType != 3) continue;
            this.lateCompensationUnused += unusedDays;
        }
    }

    protected void addHolidayShortUnpaid() {
        for (Date targetDate : this.targetDateList) {
            WorkTypeEntity workTypeEntity;
            String workTypeCode;
            RequestEntity entity;
            if (HumanUtility.isSuspension((List)this.suspensionList, (Date)targetDate) || (entity = this.getRequestEntity(targetDate)).isAttendanceApplied() || TimeUtility.isHoliday((String)(workTypeCode = this.getScheduledWorkTypeCode(targetDate))) || (workTypeEntity = TotalTimeUtility.getLatestWorkTypeEntity((Map)this.workTypeEntityMap, (String)workTypeCode, (Date)targetDate)) == null) continue;
            this.shortUnpaid += this.getShortUnpaid(workTypeEntity);
        }
    }

    protected int getShortUnpaid(WorkTypeEntity workTypeEntity) {
        int shortTime = 0;
        try {
            if (workTypeEntity.isShort1TimeSet() && !workTypeEntity.isShort1TypePay()) {
                shortTime += TimeUtility.getMinutes((Date)workTypeEntity.getShort1EndTime()) - TimeUtility.getMinutes((Date)workTypeEntity.getShort1StartTime());
            }
            if (workTypeEntity.isShort2TimeSet() && !workTypeEntity.isShort2TypePay()) {
                shortTime += TimeUtility.getMinutes((Date)workTypeEntity.getShort2EndTime()) - TimeUtility.getMinutes((Date)workTypeEntity.getShort2StartTime());
            }
        }
        catch (MospException mospException) {
            // empty catch block
        }
        return shortTime;
    }

    protected void calcWeeklyForty() {
        List dateListForWeeklyForty = this.getDateListForWeeklyForty();
        ArrayList<AttendanceDtoInterface> weeklyAttendanceList = new ArrayList<AttendanceDtoInterface>();
        AttendanceDtoInterface lastDto = null;
        for (Date targetDate : dateListForWeeklyForty) {
            AttendanceDtoInterface dto = TotalTimeUtility.getAttendanceDto((List)this.attendanceList, (Date)targetDate);
            weeklyAttendanceList.add(dto);
            if (!this.isEndDayOfWeeklyForty(targetDate)) continue;
            this.calcWeeklyForty(weeklyAttendanceList, lastDto);
            lastDto = dto;
            weeklyAttendanceList.clear();
        }
    }

    protected void calcWeeklyForty(List<AttendanceDtoInterface> weeklyAttendanceList, AttendanceDtoInterface lastDto) {
        int weeklyTotal = 0;
        int minusWorkdayOverIn = 0;
        int minusPrescribedOverIn = 0;
        weeklyTotal += this.getLastWeeklyTotal(lastDto);
        for (AttendanceDtoInterface dto : weeklyAttendanceList) {
            if (!this.isWeeklyFortyTarget(dto)) continue;
            int workdayNormal = this.getWorkdayNormalForForty(dto);
            int workdayOverIn = this.getWorkdayOverInForForty(dto);
            int prescribedNormal = this.getPrescribedNormalForForty(dto);
            int prescribedOverIn = this.getPrescribedOverInForForty(dto);
            if (dto.getWorkDate().before(this.cutoffFirstDate)) {
                weeklyTotal += workdayNormal;
                weeklyTotal += workdayOverIn;
                weeklyTotal += prescribedNormal;
                weeklyTotal += prescribedOverIn;
                continue;
            }
            int workdayNormalForty = this.getOverForty(workdayNormal, weeklyTotal);
            this.overtimeOut += workdayNormalForty;
            this.weeklyOverFortyHourWorkTime += workdayNormalForty;
            this.workdayOvertimeOut += workdayNormalForty;
            int workdayOverInForty = this.getOverForty(workdayOverIn, weeklyTotal += workdayNormal);
            this.overtimeOut += workdayOverInForty;
            this.weeklyOverFortyHourWorkTime += workdayOverInForty;
            this.workdayOvertimeOut += workdayOverInForty;
            minusWorkdayOverIn += workdayOverInForty;
            int prescribedNormalForty = this.getOverForty(prescribedNormal, weeklyTotal += workdayOverIn);
            this.overtimeOut += prescribedNormalForty;
            this.weeklyOverFortyHourWorkTime += prescribedNormalForty;
            this.prescribedOvertimeOut += prescribedNormalForty;
            int prescribedOverInForty = this.getOverForty(prescribedOverIn, weeklyTotal += prescribedNormal);
            this.overtimeOut += prescribedOverInForty;
            this.weeklyOverFortyHourWorkTime += prescribedOverInForty;
            this.prescribedOvertimeOut += prescribedOverInForty;
            minusPrescribedOverIn += prescribedOverInForty;
            weeklyTotal += prescribedOverIn;
        }
        this.overtimeIn -= minusWorkdayOverIn + minusPrescribedOverIn;
        this.workdayOvertimeIn -= minusWorkdayOverIn;
        this.prescribedHolidayOvertimeIn -= minusPrescribedOverIn;
    }

    protected void setAttendanceTransactionMap() {
        this.attendanceTransactionMap = new HashMap();
        for (Date targetDate : this.targetDateList) {
            String workTypeCode;
            if (HumanUtility.isSuspension((List)this.suspensionList, (Date)targetDate)) {
                this.attendanceTransactionMap.put(targetDate, "suspension");
                continue;
            }
            RequestEntity entity = this.getRequestEntity(targetDate);
            if (entity.isAttendanceApplied() || entity.isAllHoliday(this.isCompleted) || !TimeUtility.isHoliday((String)(workTypeCode = entity.getWorkType()))) continue;
            this.attendanceTransactionMap.put(targetDate, workTypeCode);
        }
    }

    protected void totalWorkTimes() {
        for (AttendanceTransactionDtoInterface dto : this.attendanceTransactionSet) {
            if (this.attendanceTransactionMap.get(dto.getWorkDate()) != null) continue;
            this.timesAchievement += dto.getNumerator();
            this.timesTotalWorkDate += dto.getDenominator();
        }
    }

    protected void calcWorkTime(RequestEntity entity) {
        AttendanceDtoInterface dto = entity.getAttendanceDto();
        this.workTime += dto.getWorkTime();
        this.timesWorkDate = entity.isAmHoliday(this.isCompleted) || entity.isPmHoliday(this.isCompleted) ? (this.timesWorkDate += 0.5) : (this.timesWorkDate += 1.0);
        ++this.timesWork;
    }

    protected void calcHolidayRestTime(RequestEntity entity) {
        AttendanceDtoInterface dto = entity.getAttendanceDto();
        this.workOnHoliday += dto.getLegalWorkTime();
        this.workOnSpecificHoliday += dto.getSpecificWorkTime();
        this.restWorkOnHoliday += dto.getLegalHolidayRestTime();
        this.restWorkOnSpecificHoliday += dto.getPrescribedHolidayRestTime();
        if (entity.isWorkOnHolidayNotSubstitute(this.isCompleted)) {
            ++this.timesWorkingHoliday;
        }
        if (entity.isWorkOnLegal(this.isCompleted)) {
            this.legalWorkOnHoliday += 1.0;
        }
        if (entity.isWorkOnPrescribed(this.isCompleted)) {
            this.specificWorkOnHoliday += 1.0;
        }
        if (entity.isAttendanceDirectStart()) {
            ++this.directStart;
        }
        if (entity.isAttendanceDirectEnd()) {
            ++this.directEnd;
        }
        this.restTime += dto.getRestTime();
        this.restLateNight += dto.getNightRestTime();
        this.publicTime += dto.getPublicTime();
        this.privateTime += dto.getPrivateTime();
        this.minutelyHolidayATime += dto.getMinutelyHolidayATime();
        this.minutelyHolidayBTime += dto.getMinutelyHolidayBTime();
    }

    protected void calcOvertime(RequestEntity entity) {
        AttendanceDtoInterface dto = entity.getAttendanceDto();
        this.overtime += dto.getOvertime();
        this.overtimeIn += dto.getOvertimeIn();
        this.overtimeOut += dto.getOvertimeOut();
        this.workdayOvertimeIn += dto.getWorkdayOvertimeIn();
        this.prescribedHolidayOvertimeIn += dto.getPrescribedHolidayOvertimeIn();
        this.workdayOvertimeOut += dto.getWorkdayOvertimeOut();
        this.prescribedOvertimeOut += dto.getPrescribedHolidayOvertimeOut();
        this.overtimeInNoWeeklyForty += dto.getOvertimeIn();
        this.overtimeOutNoWeeklyForty += dto.getOvertimeOut();
        this.weekDayOvertimeInNoWeeklyForty += dto.getWorkdayOvertimeIn();
        this.weekDayOvertimeOutNoWeeklyForty += dto.getWorkdayOvertimeOut();
        if (dto.getOvertime() > 0) {
            ++this.timesOvertime;
        }
    }

    protected void calcLeaveLateTime(AttendanceDtoInterface attendanceDto) {
        this.lateNight += attendanceDto.getLateNightTime();
        this.nightWorkWithinPrescribedWork += attendanceDto.getNightWorkWithinPrescribedWork();
        this.nightOvertimeWork += attendanceDto.getNightOvertimeWork();
        this.nightWorkOnHoliday += attendanceDto.getNightWorkOnHoliday();
        this.decreaseTime += attendanceDto.getDecreaseTime();
        if (attendanceDto.getLateTime() > 0) {
            ++this.lateDays;
            this.lateTime += attendanceDto.getLateTime();
            if (attendanceDto.getLateTime() < 30) {
                ++this.lateLessThanThirtyMinutes;
                this.lateLessThanThirtyMinutesTime += attendanceDto.getLateTime();
            } else {
                ++this.lateThirtyMinutesOrMore;
                this.lateThirtyMinutesOrMoreTime += attendanceDto.getLateTime();
            }
            ++this.timesLate;
        }
        if (attendanceDto.getLeaveEarlyTime() > 0) {
            ++this.leaveEarlyDays;
            this.leaveEarlyTime += attendanceDto.getLeaveEarlyTime();
            if (attendanceDto.getLeaveEarlyTime() < 30) {
                ++this.leaveEarlyLessThanThirtyMinutes;
                this.leaveEarlyLessThanThirtyMinutesTime += attendanceDto.getLeaveEarlyTime();
            } else {
                ++this.leaveEarlyThirtyMinutesOrMore;
                this.leaveEarlyThirtyMinutesOrMoreTime += attendanceDto.getLeaveEarlyTime();
            }
            ++this.timesLeaveEarly;
        }
    }

    protected void calcHolidayWorkTime(AttendanceDtoInterface dto) {
        this.statutoryHolidayWorkTimeIn += dto.getStatutoryHolidayWorkTimeIn();
        this.statutoryHolidayWorkTimeOut += dto.getStatutoryHolidayWorkTimeOut();
        this.prescribedHolidayWorkTimeIn += dto.getPrescribedHolidayWorkTimeIn();
        this.prescribedHolidayWorkTimeOut += dto.getPrescribedHolidayWorkTimeOut();
    }

    protected void calcContractWorkTime(AttendanceDtoInterface attendanceDto) {
        this.contractWorkTime += this.getContractWorkTime(attendanceDto);
        this.shortUnpaid += attendanceDto.getShortUnpaid();
    }

    protected int getContractWorkTime(AttendanceDtoInterface dto) {
        int contractWorkTime = dto.getWorkTime() - dto.getOvertime() - dto.getLegalWorkTime();
        if ("train".equals(dto.getLateReason()) || "company".equals(dto.getLateReason())) {
            contractWorkTime += dto.getActualLateTime();
        }
        if ("company".equals(dto.getLeaveEarlyReason())) {
            contractWorkTime += dto.getActualLeaveEarlyTime();
        }
        return contractWorkTime;
    }

    protected void calcExtraOverTime() {
        int fortyFive = 2700;
        int sixty = 3600;
        this.sixtyHourOvertime = this.overtimeOut - sixty;
        this.sixtyHourOvertime = this.sixtyHourOvertime < 0 ? 0 : this.sixtyHourOvertime;
        this.fortyFiveHourOvertime = this.overtimeOut - fortyFive - this.sixtyHourOvertime;
        this.fortyFiveHourOvertime = this.fortyFiveHourOvertime < 0 ? 0 : this.fortyFiveHourOvertime;
    }

    protected void addHolidayTimes(String holidayCode, int holidayType, float times) {
        Map holidayMap = null;
        switch (holidayType) {
            case 2: {
                holidayMap = this.specialHolidayMap;
                break;
            }
            case 3: {
                holidayMap = this.otherHolidayMap;
                break;
            }
            case 4: {
                holidayMap = this.absenceMap;
                break;
            }
            default: {
                return;
            }
        }
        Float total = (Float)holidayMap.get(holidayCode);
        if (total == null) {
            total = Float.valueOf(0.0f);
        }
        holidayMap.put(holidayCode, Float.valueOf(total.floatValue() + times));
    }

    protected float totalHoliday(Map<String, Float> map) {
        float total = 0.0f;
        for (float times : map.values()) {
            total += times;
        }
        return total;
    }

    protected boolean isSubHolidayExpired(SubHolidayDtoInterface dto) {
        Date targetDate = dto.getWorkDate();
        TimeSettingDtoInterface timeSettingDto = (TimeSettingDtoInterface)this.timeSettingMap.get(targetDate);
        if (timeSettingDto == null) {
            timeSettingDto = (TimeSettingDtoInterface)this.timeSettingMap.get(this.cutoffFirstDate);
        }
        if (timeSettingDto == null) {
            return true;
        }
        int limitMonth = timeSettingDto.getSubHolidayLimitMonth();
        int limitDay = timeSettingDto.getSubHolidayLimitDate();
        Date expireDate = DateUtility.addMonth((Date)targetDate, (int)limitMonth);
        expireDate = DateUtility.addDay((Date)expireDate, (int)limitDay);
        return DateUtility.isTermContain((Date)expireDate, (Date)this.cutoffFirstDate, (Date)this.cutoffLastDate);
    }

    protected boolean isEndDayOfWeeklyForty(Date targetDate) {
        if (targetDate.compareTo(this.cutoffLastDate) == 0) {
            return true;
        }
        return this.isEndDayofWeek(targetDate);
    }

    protected boolean isEndDayofWeek(Date targetDate) {
        TimeSettingDtoInterface dto = (TimeSettingDtoInterface)this.timeSettingMap.get(targetDate);
        if (dto == null) {
            return false;
        }
        int endDayOfWeek = this.getEndDayOfWeek(dto.getStartWeek());
        return DateUtility.isDayOfWeek((Date)targetDate, (int)endDayOfWeek);
    }

    protected int getEndDayOfWeek(int startDayOfWeek) {
        if (startDayOfWeek == 1) {
            return 7;
        }
        return --startDayOfWeek;
    }

    protected List<Date> getDateListForWeeklyForty() {
        Date firstDate = this.getFirstDateForWeeklyForty();
        return TimeUtility.getDateList((Date)firstDate, (Date)this.cutoffLastDate);
    }

    protected Date getFirstDateForWeeklyForty() {
        List targetDateList = TimeUtility.getDateList((Date)this.cutoffFirstDate, (Date)this.cutoffLastDate);
        for (Date targetDate : targetDateList) {
            if (!this.isEndDayofWeek(targetDate)) continue;
            return DateUtility.addDay((Date)targetDate, (int)-7);
        }
        return CapsuleUtility.getDateClone((Date)this.cutoffFirstDate);
    }

    protected int getWorkdayNormalForForty(AttendanceDtoInterface dto) {
        int minutes = dto.getWorkTime();
        minutes -= dto.getLegalWorkTime();
        minutes -= dto.getSpecificWorkTime();
        minutes -= dto.getWorkdayOvertimeIn();
        return minutes -= dto.getWorkdayOvertimeOut();
    }

    protected int getWorkdayOverInForForty(AttendanceDtoInterface dto) {
        return dto.getWorkdayOvertimeIn();
    }

    protected int getPrescribedNormalForForty(AttendanceDtoInterface dto) {
        int minutes = dto.getSpecificWorkTime();
        minutes -= dto.getPrescribedHolidayOvertimeIn();
        return minutes -= dto.getPrescribedHolidayOvertimeOut();
    }

    protected int getPrescribedOverInForForty(AttendanceDtoInterface dto) {
        return dto.getPrescribedHolidayOvertimeIn();
    }

    protected int getOverForty(int minutes, int weeklyTotalWorkTime) {
        int forty = 2400;
        if (forty < weeklyTotalWorkTime) {
            return minutes;
        }
        int overForty = minutes + weeklyTotalWorkTime - forty;
        return overForty < 0 ? 0 : overForty;
    }

    protected boolean isWeeklyFortyTarget(AttendanceDtoInterface dto) {
        if (dto == null) {
            return false;
        }
        return !TimeUtility.isWorkOnLegalHoliday((String)dto.getWorkTypeCode()) || !this.isEndDayofWeek(dto.getWorkDate());
    }

    protected int getLastWeeklyTotal(AttendanceDtoInterface dto) {
        if (dto == null) {
            return 0;
        }
        if (!TimeUtility.isWorkOnLegalHoliday((String)dto.getWorkTypeCode())) {
            return 0;
        }
        int lastWeeklyTotal = 0;
        lastWeeklyTotal += this.getWorkdayNormalForForty(dto);
        lastWeeklyTotal += this.getWorkdayOverInForForty(dto);
        lastWeeklyTotal += this.getPrescribedNormalForForty(dto);
        return lastWeeklyTotal += this.getPrescribedOverInForForty(dto);
    }

    protected void totalGeneralItem() {
    }

    protected void setInitFileds() {
        this.workTime = 0;
        this.contractWorkTime = 0;
        this.timesWorkDate = 0.0;
        this.timesWork = 0;
        this.legalWorkOnHoliday = 0.0;
        this.specificWorkOnHoliday = 0.0;
        this.timesAchievement = 0;
        this.timesTotalWorkDate = 0;
        this.directStart = 0;
        this.directEnd = 0;
        this.restTime = 0;
        this.restLateNight = 0;
        this.restWorkOnSpecificHoliday = 0;
        this.restWorkOnHoliday = 0;
        this.publicTime = 0;
        this.privateTime = 0;
        this.minutelyHolidayATime = 0;
        this.minutelyHolidayBTime = 0;
        this.overtime = 0;
        this.overtimeIn = 0;
        this.overtimeOut = 0;
        this.lateNight = 0;
        this.nightWorkWithinPrescribedWork = 0;
        this.nightOvertimeWork = 0;
        this.nightWorkOnHoliday = 0;
        this.workOnSpecificHoliday = 0;
        this.workOnHoliday = 0;
        this.decreaseTime = 0;
        this.fortyFiveHourOvertime = 0;
        this.timesOvertime = 0;
        this.timesWorkingHoliday = 0;
        this.lateDays = 0;
        this.lateThirtyMinutesOrMore = 0;
        this.lateLessThanThirtyMinutes = 0;
        this.lateTime = 0;
        this.lateThirtyMinutesOrMoreTime = 0;
        this.lateLessThanThirtyMinutesTime = 0;
        this.timesLate = 0;
        this.leaveEarlyDays = 0;
        this.leaveEarlyThirtyMinutesOrMore = 0;
        this.leaveEarlyLessThanThirtyMinutes = 0;
        this.leaveEarlyTime = 0;
        this.leaveEarlyThirtyMinutesOrMoreTime = 0;
        this.leaveEarlyLessThanThirtyMinutesTime = 0;
        this.timesLeaveEarly = 0;
        this.timesHoliday = 0;
        this.timesLegalHoliday = 0;
        this.timesSpecificHoliday = 0;
        this.timesPaidHoliday = 0.0;
        this.paidHolidayHour = 0;
        this.timesStockHoliday = 0.0;
        this.timesCompensation = 0.0;
        this.timesLegalCompensation = 0.0;
        this.timesSpecificCompensation = 0.0;
        this.timesLateCompensation = 0.0;
        this.timesHolidaySubstitute = 0.0;
        this.timesLegalHolidaySubstitute = 0.0;
        this.timesSpecificHolidaySubstitute = 0.0;
        this.totalSpecialHoliday = 0.0;
        this.totalOtherHoliday = 0.0;
        this.totalAbsence = 0.0;
        this.totalAllowance = 0;
        this.sixtyHourOvertime = 0;
        this.workdayOvertimeIn = 0;
        this.prescribedHolidayOvertimeIn = 0;
        this.workdayOvertimeOut = 0;
        this.prescribedOvertimeOut = 0;
        this.timesAlternative = 0.0;
        this.legalCompensationOccurred = 0.0;
        this.specificCompensationOccurred = 0.0;
        this.lateCompensationOccurred = 0.0;
        this.legalCompensationUnused = 0.0;
        this.specificCompensationUnused = 0.0;
        this.lateCompensationUnused = 0.0;
        this.statutoryHolidayWorkTimeIn = 0;
        this.statutoryHolidayWorkTimeOut = 0;
        this.prescribedHolidayWorkTimeIn = 0;
        this.prescribedHolidayWorkTimeOut = 0;
        this.shortUnpaid = 0;
        this.weeklyOverFortyHourWorkTime = 0;
        this.overtimeInNoWeeklyForty = 0;
        this.overtimeOutNoWeeklyForty = 0;
        this.weekDayOvertimeInNoWeeklyForty = 0;
        this.weekDayOvertimeOutNoWeeklyForty = 0;
        this.generalIntItem1 = 0;
        this.generalIntItem2 = 0;
        this.generalIntItem3 = 0;
        this.generalIntItem4 = 0;
        this.generalIntItem5 = 0;
        this.generalDoubleItem1 = 0;
        this.generalDoubleItem2 = 0;
        this.generalDoubleItem3 = 0;
        this.generalDoubleItem4 = 0;
        this.generalDoubleItem5 = 0;
        this.requestEntityMap = new HashMap();
    }

    protected String getScheduledWorkTypeCode(Date targetDate) {
        String substituteWork = (String)this.substitutedMap.get(targetDate);
        if (substituteWork != null && !substituteWork.isEmpty()) {
            return substituteWork;
        }
        RequestEntity entity = this.getRequestEntity(targetDate);
        String substituteType = entity.getSubstituteType(this.isCompleted);
        if (!substituteType.isEmpty()) {
            return substituteType;
        }
        return (String)this.scheduleMap.get(targetDate);
    }

    protected RequestEntity getRequestEntity(Date targetDate) {
        RequestEntity entity = (RequestEntity)this.requestEntityMap.get(targetDate);
        if (entity != null) {
            return entity;
        }
        entity = new RequestEntity(this.personalId, targetDate);
        this.requestEntityMap.put(targetDate, entity);
        entity.setAttendanceDto(TotalTimeUtility.getAttendanceDto((List)this.attendanceList, (Date)targetDate));
        entity.setWorkOnHolidayRequestDto(TotalTimeUtility.getWorkOnHolidayRequestDto((List)this.workOnHolidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setHolidayRequestList(TotalTimeUtility.getHolidayRequestList((List)this.holidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setSubHolidayRequestList(TotalTimeUtility.getSubHolidayRequestList((List)this.subHolidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setOverTimeRequestList(TotalTimeUtility.getOvertimeRequestList((List)this.overtimeRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setWorkTypeChangeRequestDto(TotalTimeUtility.getWorkTypeChangeRequestList((List)this.workTypeChangeRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setDifferenceRequestDto(TotalTimeUtility.getDifferenceRequestDto((List)this.differenceRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setSubstituteList(TotalTimeUtility.getSubstitutList((List)this.substitubeList, (Map)this.workflowMap, (Date)targetDate));
        entity.setWorkflowMap(this.workflowMap);
        entity.setScheduledWorkTypeCode((String)this.scheduleMap.get(targetDate));
        entity.setSubstitutedWorkTypeCode((String)this.substitutedMap.get(targetDate));
        return entity;
    }

    public WorkflowDtoInterface getWorkflowDto(long workflow) {
        return (WorkflowDtoInterface)this.workflowMap.get(workflow);
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public int getCalculationYear() {
        return this.calculationYear;
    }

    public void setCalculationYear(int calculationYear) {
        this.calculationYear = calculationYear;
    }

    public int getCalculationMonth() {
        return this.calculationMonth;
    }

    public void setCalculationMonth(int calculationMonth) {
        this.calculationMonth = calculationMonth;
    }

    public void setHolidaySet(Set<HolidayDtoInterface> holidaySet) {
        this.holidaySet = holidaySet;
    }

    public String getCutoffCode() {
        return this.cutoffCode;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }

    public Date getCutoffFirstDate() {
        return CapsuleUtility.getDateClone((Date)this.cutoffFirstDate);
    }

    public void setCutoffFirstDate(Date cutoffFirstDate) {
        this.cutoffFirstDate = CapsuleUtility.getDateClone((Date)cutoffFirstDate);
    }

    public Date getCutoffLastDate() {
        return CapsuleUtility.getDateClone((Date)this.cutoffLastDate);
    }

    public void setCutoffLastDate(Date cutoffLastDate) {
        this.cutoffLastDate = CapsuleUtility.getDateClone((Date)cutoffLastDate);
    }

    public List<Date> getTargetDateList() {
        return this.targetDateList;
    }

    public void setTargetDateList(List<Date> targetDateList) {
        this.targetDateList = targetDateList;
    }

    public List<SuspensionDtoInterface> getSuspensionList() {
        return this.suspensionList;
    }

    public void setSuspensionList(List<SuspensionDtoInterface> suspensionList) {
        this.suspensionList = suspensionList;
    }

    public Map<Date, ApplicationDtoInterface> getApplicationMap() {
        return this.applicationMap;
    }

    public void setApplicationMap(Map<Date, ApplicationDtoInterface> applicationMap) {
        this.applicationMap = applicationMap;
    }

    public Map<Date, TimeSettingDtoInterface> getTimeSettingMap() {
        return this.timeSettingMap;
    }

    public void setTimeSettingMap(Map<Date, TimeSettingDtoInterface> timeSettingMap) {
        this.timeSettingMap = timeSettingMap;
    }

    public Map<Date, String> getScheduleMap() {
        return this.scheduleMap;
    }

    public void setScheduleMap(Map<Date, String> scheduleMap) {
        this.scheduleMap = scheduleMap;
    }

    public Map<Date, String> getSubstitutedMap() {
        return this.substitutedMap;
    }

    public void setSubstitutedMap(Map<Date, String> substitutedMap) {
        this.substitutedMap = substitutedMap;
    }

    public List<AttendanceDtoInterface> getAttendanceList() {
        return this.attendanceList;
    }

    public void setAttendanceList(List<AttendanceDtoInterface> attendanceList) {
        this.attendanceList = attendanceList;
    }

    public List<WorkOnHolidayRequestDtoInterface> getWorkOnHolidayRequestList() {
        return this.workOnHolidayRequestList;
    }

    public void setWorkOnHolidayRequestList(List<WorkOnHolidayRequestDtoInterface> workOnHolidayRequestList) {
        this.workOnHolidayRequestList = workOnHolidayRequestList;
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList() {
        return this.holidayRequestList;
    }

    public void setHolidayRequestList(List<HolidayRequestDtoInterface> holidayRequestList) {
        this.holidayRequestList = holidayRequestList;
    }

    public List<SubHolidayRequestDtoInterface> getSubHolidayRequestList() {
        return this.subHolidayRequestList;
    }

    public void setSubHolidayRequestList(List<SubHolidayRequestDtoInterface> subHolidayRequestList) {
        this.subHolidayRequestList = subHolidayRequestList;
    }

    public List<OvertimeRequestDtoInterface> getOvertimeRequestList() {
        return this.overtimeRequestList;
    }

    public void setOvertimeRequestList(List<OvertimeRequestDtoInterface> overtimeRequestList) {
        this.overtimeRequestList = overtimeRequestList;
    }

    public List<WorkTypeChangeRequestDtoInterface> getWorkTypeChangeRequestList() {
        return this.workTypeChangeRequestList;
    }

    public void setWorkTypeChangeRequestList(List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList) {
        this.workTypeChangeRequestList = workTypeChangeRequestList;
    }

    public List<DifferenceRequestDtoInterface> getDifferenceRequestList() {
        return this.differenceRequestList;
    }

    public void setDifferenceRequestList(List<DifferenceRequestDtoInterface> differenceRequestList) {
        this.differenceRequestList = differenceRequestList;
    }

    public List<SubstituteDtoInterface> getSubstitubeList() {
        return this.substitubeList;
    }

    public void setSubstitubeList(List<SubstituteDtoInterface> substitubeList) {
        this.substitubeList = substitubeList;
    }

    public List<SubHolidayDtoInterface> getSubHolidayList() {
        return this.subHolidayList;
    }

    public void setSubHolidayList(List<SubHolidayDtoInterface> subHolidayList) {
        this.subHolidayList = subHolidayList;
    }

    public Map<Long, WorkflowDtoInterface> getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(Map<Long, WorkflowDtoInterface> workflowMap) {
        this.workflowMap = workflowMap;
    }

    public Set<AttendanceTransactionDtoInterface> getAttendanceTransactionSet() {
        return this.attendanceTransactionSet;
    }

    public void setAttendanceTransactionSet(Set<AttendanceTransactionDtoInterface> attendanceTransactionSet) {
        this.attendanceTransactionSet = attendanceTransactionSet;
    }

    public Map<String, List<WorkTypeEntity>> getWorkTypeEntityMap() {
        return this.workTypeEntityMap;
    }

    public void setWorkTypeEntityMap(Map<String, List<WorkTypeEntity>> workTypeEntityMap) {
        this.workTypeEntityMap = workTypeEntityMap;
    }

    public Map<Date, String> getAttendanceTransactionMap() {
        return this.attendanceTransactionMap;
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public int getContractWorkTime() {
        return this.contractWorkTime;
    }

    public double getTimesWorkDate() {
        return this.timesWorkDate;
    }

    public int getTimesWork() {
        return this.timesWork;
    }

    public double getLegalWorkOnHoliday() {
        return this.legalWorkOnHoliday;
    }

    public double getSpecificWorkOnHoliday() {
        return this.specificWorkOnHoliday;
    }

    public int getTimesAchievement() {
        return this.timesAchievement;
    }

    public int getTimesTotalWorkDate() {
        return this.timesTotalWorkDate;
    }

    public int getDirectStart() {
        return this.directStart;
    }

    public int getDirectEnd() {
        return this.directEnd;
    }

    public int getRestTime() {
        return this.restTime;
    }

    public int getRestLateNight() {
        return this.restLateNight;
    }

    public int getRestWorkOnSpecificHoliday() {
        return this.restWorkOnSpecificHoliday;
    }

    public int getRestWorkOnHoliday() {
        return this.restWorkOnHoliday;
    }

    public int getPublicTime() {
        return this.publicTime;
    }

    public int getPrivateTime() {
        return this.privateTime;
    }

    public int getMinutelyHolidayATime() {
        return this.minutelyHolidayATime;
    }

    public int getMinutelyHolidayBTime() {
        return this.minutelyHolidayBTime;
    }

    public int getOvertime() {
        return this.overtime;
    }

    public int getOvertimeIn() {
        return this.overtimeIn;
    }

    public int getOvertimeOut() {
        return this.overtimeOut;
    }

    public int getLateNight() {
        return this.lateNight;
    }

    public int getNightWorkWithinPrescribedWork() {
        return this.nightWorkWithinPrescribedWork;
    }

    public int getNightOvertimeWork() {
        return this.nightOvertimeWork;
    }

    public int getNightWorkOnHoliday() {
        return this.nightWorkOnHoliday;
    }

    public int getWorkOnSpecificHoliday() {
        return this.workOnSpecificHoliday;
    }

    public int getWorkOnHoliday() {
        return this.workOnHoliday;
    }

    public int getDecreaseTime() {
        return this.decreaseTime;
    }

    public int getFortyFiveHourOvertime() {
        return this.fortyFiveHourOvertime;
    }

    public int getTimesOvertime() {
        return this.timesOvertime;
    }

    public int getTimesWorkingHoliday() {
        return this.timesWorkingHoliday;
    }

    public int getLateDays() {
        return this.lateDays;
    }

    public int getLateThirtyMinutesOrMore() {
        return this.lateThirtyMinutesOrMore;
    }

    public int getLateLessThanThirtyMinutes() {
        return this.lateLessThanThirtyMinutes;
    }

    public int getLateTime() {
        return this.lateTime;
    }

    public int getLateThirtyMinutesOrMoreTime() {
        return this.lateThirtyMinutesOrMoreTime;
    }

    public int getLateLessThanThirtyMinutesTime() {
        return this.lateLessThanThirtyMinutesTime;
    }

    public int getTimesLate() {
        return this.timesLate;
    }

    public int getLeaveEarlyDays() {
        return this.leaveEarlyDays;
    }

    public int getLeaveEarlyThirtyMinutesOrMore() {
        return this.leaveEarlyThirtyMinutesOrMore;
    }

    public int getLeaveEarlyLessThanThirtyMinutes() {
        return this.leaveEarlyLessThanThirtyMinutes;
    }

    public int getLeaveEarlyTime() {
        return this.leaveEarlyTime;
    }

    public int getLeaveEarlyThirtyMinutesOrMoreTime() {
        return this.leaveEarlyThirtyMinutesOrMoreTime;
    }

    public int getLeaveEarlyLessThanThirtyMinutesTime() {
        return this.leaveEarlyLessThanThirtyMinutesTime;
    }

    public int getTimesLeaveEarly() {
        return this.timesLeaveEarly;
    }

    public int getTimesHoliday() {
        return this.timesHoliday;
    }

    public int getTimesLegalHoliday() {
        return this.timesLegalHoliday;
    }

    public int getTimesSpecificHoliday() {
        return this.timesSpecificHoliday;
    }

    public double getTimesPaidHoliday() {
        return this.timesPaidHoliday;
    }

    public int getPaidHolidayHour() {
        return this.paidHolidayHour;
    }

    public double getTimesStockHoliday() {
        return this.timesStockHoliday;
    }

    public double getTimesCompensation() {
        return this.timesCompensation;
    }

    public double getTimesLegalCompensation() {
        return this.timesLegalCompensation;
    }

    public double getTimesSpecificCompensation() {
        return this.timesSpecificCompensation;
    }

    public double getTimesLateCompensation() {
        return this.timesLateCompensation;
    }

    public double getTimesHolidaySubstitute() {
        return this.timesHolidaySubstitute;
    }

    public double getTimesLegalHolidaySubstitute() {
        return this.timesLegalHolidaySubstitute;
    }

    public double getTimesSpecificHolidaySubstitute() {
        return this.timesSpecificHolidaySubstitute;
    }

    public double getTotalSpecialHoliday() {
        return this.totalSpecialHoliday;
    }

    public double getTotalOtherHoliday() {
        return this.totalOtherHoliday;
    }

    public double getTotalAbsence() {
        return this.totalAbsence;
    }

    public int getTotalAllowance() {
        return this.totalAllowance;
    }

    public int getSixtyHourOvertime() {
        return this.sixtyHourOvertime;
    }

    public int getWorkdayOvertimeIn() {
        return this.workdayOvertimeIn;
    }

    public int getPrescribedHolidayOvertimeIn() {
        return this.prescribedHolidayOvertimeIn;
    }

    public int getWorkdayOvertimeOut() {
        return this.workdayOvertimeOut;
    }

    public int getPrescribedOvertimeOut() {
        return this.prescribedOvertimeOut;
    }

    public double getTimesAlternative() {
        return this.timesAlternative;
    }

    public double getLegalCompensationOccurred() {
        return this.legalCompensationOccurred;
    }

    public double getSpecificCompensationOccurred() {
        return this.specificCompensationOccurred;
    }

    public double getLateCompensationOccurred() {
        return this.lateCompensationOccurred;
    }

    public double getLegalCompensationUnused() {
        return this.legalCompensationUnused;
    }

    public double getSpecificCompensationUnused() {
        return this.specificCompensationUnused;
    }

    public double getLateCompensationUnused() {
        return this.lateCompensationUnused;
    }

    public int getStatutoryHolidayWorkTimeIn() {
        return this.statutoryHolidayWorkTimeIn;
    }

    public int getStatutoryHolidayWorkTimeOut() {
        return this.statutoryHolidayWorkTimeOut;
    }

    public int getPrescribedHolidayWorkTimeIn() {
        return this.prescribedHolidayWorkTimeIn;
    }

    public int getPrescribedHolidayWorkTimeOut() {
        return this.prescribedHolidayWorkTimeOut;
    }

    public int getShortUnpaid() {
        return this.shortUnpaid;
    }

    public int getWeeklyOverFortyHourWorkTime() {
        return this.weeklyOverFortyHourWorkTime;
    }

    public int getOvertimeInNoWeeklyForty() {
        return this.overtimeInNoWeeklyForty;
    }

    public int getOvertimeOutNoWeeklyForty() {
        return this.overtimeOutNoWeeklyForty;
    }

    public int getWeekDayOvertimeInNoWeeklyForty() {
        return this.weekDayOvertimeInNoWeeklyForty;
    }

    public int getWeekDayOvertimeOutNoWeeklyForty() {
        return this.weekDayOvertimeOutNoWeeklyForty;
    }

    public int getGeneralIntItem1() {
        return this.generalIntItem1;
    }

    public int getGeneralIntItem2() {
        return this.generalIntItem2;
    }

    public int getGeneralIntItem3() {
        return this.generalIntItem3;
    }

    public int getGeneralIntItem4() {
        return this.generalIntItem4;
    }

    public int getGeneralIntItem5() {
        return this.generalIntItem5;
    }

    public int getGeneralDoubleItem1() {
        return this.generalDoubleItem1;
    }

    public int getGeneralDoubleItem2() {
        return this.generalDoubleItem2;
    }

    public int getGeneralDoubleItem3() {
        return this.generalDoubleItem3;
    }

    public int getGeneralDoubleItem4() {
        return this.generalDoubleItem4;
    }

    public int getGeneralDoubleItem5() {
        return this.generalDoubleItem5;
    }

    public Map<String, Float> getSpecialHolidayMap() {
        return this.specialHolidayMap;
    }

    public Map<String, Float> getOtherHolidayMap() {
        return this.otherHolidayMap;
    }

    public Map<String, Float> getAbsenceMap() {
        return this.absenceMap;
    }
}

