/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeEntity {
    public static final String CODE_PAY_TYPE_PAY = "0";
    protected WorkTypeDtoInterface workTypeDto;
    protected List<WorkTypeItemDtoInterface> itemDtoList;

    public WorkTypeEntity(WorkTypeDtoInterface workTypeDto, List<WorkTypeItemDtoInterface> itemDtoList) {
        this.workTypeDto = workTypeDto;
        this.itemDtoList = itemDtoList;
    }

    public String getWorkTypeAbbr() {
        if (this.workTypeDto == null || this.workTypeDto.getWorkTypeAbbr() == null) {
            return "";
        }
        return this.workTypeDto.getWorkTypeAbbr();
    }

    public Date getStartWorkTime() throws MospException {
        return this.getItemValue("WorkStart");
    }

    public Date getEndWorkTime() throws MospException {
        return this.getItemValue("WorkEnd");
    }

    public int getWorkTime() throws MospException {
        return this.getItemMinutes("WorkTime");
    }

    public int getRestTime() throws MospException {
        return this.getItemMinutes("RestTime");
    }

    public Date getRest1StartTime() throws MospException {
        return this.getItemValue("RestStart1");
    }

    public Date getRest1EndTime() throws MospException {
        return this.getItemValue("RestEnd1");
    }

    public Date getFrontStartTime() throws MospException {
        return this.getItemValue("FrontStart");
    }

    public Date getFrontEndTime() throws MospException {
        return this.getItemValue("FrontEnd");
    }

    public Date getBackStartTime() throws MospException {
        return this.getItemValue("BackStart");
    }

    public Date getBackEndTime() throws MospException {
        return this.getItemValue("BackEnd");
    }

    public boolean isDirectStart() {
        return this.isChecked("DirectStart");
    }

    public boolean isDirectEnd() {
        return this.isChecked("DirectEnd");
    }

    public boolean isNightRestExclude() {
        return this.isPreliminaryTheValue("ExcludeNightRest", String.valueOf(0));
    }

    public Date getShort1StartTime() throws MospException {
        return this.getItemValue("Short1Start");
    }

    public Date getShort1EndTime() throws MospException {
        return this.getItemValue("Short1End");
    }

    public boolean isShort1TypePay() {
        return this.isPreliminaryTheValue("Short1Start", CODE_PAY_TYPE_PAY);
    }

    public boolean isShort1TimeSet() throws MospException {
        return this.isItemValueSet("Short1Start", "Short1End");
    }

    public Date getShort2StartTime() throws MospException {
        return this.getItemValue("Short2Start");
    }

    public Date getShort2EndTime() throws MospException {
        return this.getItemValue("Short2End");
    }

    public boolean isShort2TypePay() throws MospException {
        return this.isPreliminaryTheValue("Short2Start", CODE_PAY_TYPE_PAY);
    }

    public boolean isShort2TimeSet() throws MospException {
        return this.isItemValueSet("Short2Start", "Short2End");
    }

    protected boolean isLegalHoliday() {
        return this.getWorkTypeCode().equals("legal_holiday");
    }

    protected boolean isPrescribedHoliday() {
        return this.getWorkTypeCode().equals("prescribed_holiday");
    }

    public boolean isWorkTypeForWork() {
        return !this.getWorkTypeCode().isEmpty() && !this.isLegalHoliday() && !this.isPrescribedHoliday();
    }

    public Date getStartTime(RequestEntity requestEntity) throws MospException {
        boolean isCompleted = false;
        Date targetDate = requestEntity.getTargetDate();
        int overtimeMinutes = requestEntity.getOvertimeMinutesBeforeWork(isCompleted);
        Date workOnHolidayStartTime = requestEntity.getWorkOnHolidayStartTime(isCompleted);
        if (requestEntity.isAllHoliday(isCompleted)) {
            return null;
        }
        if (requestEntity.isAmHoliday(isCompleted)) {
            Date frontEndTime;
            Date startTime = this.getBackStartTime();
            if ((startTime = DateUtility.addMinute((Date)startTime, (int)(-overtimeMinutes))).before(frontEndTime = this.getFrontEndTime())) {
                startTime = frontEndTime;
            }
            return TimeUtility.getDateTime((Date)targetDate, (Date)startTime);
        }
        if (workOnHolidayStartTime != null) {
            return workOnHolidayStartTime;
        }
        List holidayTimeList = requestEntity.getHourlyHolidayFirstSequenceTimes();
        if (this.isShort1TimeSet()) {
            Date short1EndTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getShort1EndTime());
            if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(0)).compareTo(short1EndTime) == 0) {
                return (Date)holidayTimeList.get(1);
            }
            if (!this.isShort1TypePay()) {
                return short1EndTime;
            }
        }
        Date startTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getStartWorkTime());
        if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(0)).compareTo(startTime) == 0) {
            return (Date)holidayTimeList.get(1);
        }
        return startTime;
    }

    public Date getEndTime(RequestEntity requestEntity) throws MospException {
        boolean isCompleted = false;
        Date targetDate = requestEntity.getTargetDate();
        int overtimeMinutes = requestEntity.getOvertimeMinutesAfterWork(isCompleted);
        Date workOnHolidayEndTime = requestEntity.getWorkOnHolidayEndTime(isCompleted);
        if (requestEntity.isAllHoliday(isCompleted)) {
            return null;
        }
        if (requestEntity.isPmHoliday(isCompleted)) {
            Date backStartTime;
            Date endTime = this.getFrontEndTime();
            if ((endTime = DateUtility.addMinute((Date)endTime, (int)overtimeMinutes)).after(backStartTime = this.getBackStartTime())) {
                endTime = backStartTime;
            }
            return TimeUtility.getDateTime((Date)targetDate, (Date)endTime);
        }
        if (workOnHolidayEndTime != null) {
            return workOnHolidayEndTime;
        }
        List holidayTimeList = requestEntity.getHourlyHolidayLastSequenceTimes();
        if (this.isShort2TimeSet()) {
            Date short2StartTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getShort2StartTime());
            if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(1)).compareTo(short2StartTime) == 0) {
                return (Date)holidayTimeList.get(0);
            }
            if (!this.isShort2TypePay()) {
                return short2StartTime;
            }
        }
        Date endTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getEndWorkTime());
        if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(1)).compareTo(endTime) == 0) {
            return (Date)holidayTimeList.get(0);
        }
        return endTime;
    }

    protected String getWorkTypeCode() {
        if (this.workTypeDto == null || this.workTypeDto.getWorkTypeCode() == null) {
            return "";
        }
        return this.workTypeDto.getWorkTypeCode();
    }

    public Date getActivateDate() {
        if (this.workTypeDto == null) {
            return null;
        }
        return this.workTypeDto.getActivateDate();
    }

    public Date getItemValue(String workTypeItemCode) throws MospException {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return DateUtility.getDefaultTime();
        }
        if (dto.getWorkTypeItemValue() == null) {
            return DateUtility.getDefaultTime();
        }
        return new Date(dto.getWorkTypeItemValue().getTime());
    }

    protected int getItemMinutes(String workTypeItemCode) throws MospException {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return 0;
        }
        if (dto.getWorkTypeItemValue() == null) {
            return 0;
        }
        return TimeUtility.getMinutes((Date)dto.getWorkTypeItemValue());
    }

    protected String getItemPreliminary(String workTypeItemCode) {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return "";
        }
        return dto.getPreliminary();
    }

    public WorkTypeItemDtoInterface getWorkTypeItem(String workTypeItemCode) {
        for (WorkTypeItemDtoInterface dto : this.itemDtoList) {
            if (!dto.getWorkTypeItemCode().equals(workTypeItemCode)) continue;
            return dto;
        }
        return null;
    }

    protected boolean isChecked(String workTypeItemCode) {
        return this.isPreliminaryTheValue(workTypeItemCode, "1");
    }

    protected boolean isPreliminaryTheValue(String workTypeItemCode, String theValue) {
        String preliminary = this.getItemPreliminary(workTypeItemCode);
        if (preliminary.isEmpty()) {
            return false;
        }
        return preliminary.equals(theValue);
    }

    protected boolean isItemValueSet(String fromItemCode, String toItemCode) throws MospException {
        Date defaultTime = DateUtility.getDefaultTime();
        return !this.getItemValue(fromItemCode).equals(defaultTime) || !this.getItemValue(toItemCode).equals(defaultTime);
    }
}

