/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.file.action;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.file.base.ImportListAction;
import jp.mosp.platform.file.vo.ImportListVo;
import jp.mosp.time.base.TimeBeanHandlerInterface;
import jp.mosp.time.base.TimeReferenceBeanHandlerInterface;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.bean.HolidayDataRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

public class TimeImportListAction
extends ImportListAction {
    public static final String CMD_SHOW = "TM3210";
    public static final String CMD_SEARCH = "TM3212";
    public static final String CMD_RE_SHOW = "TM3213";
    public static final String CMD_EXECUTION = "TM3215";
    public static final String CMD_SORT = "TM3218";
    public static final String CMD_PAGE = "TM3219";
    public static final String CMD_TEMP_OUTPUT = "TM3286";
    protected TimeBeanHandlerInterface time;
    protected TimeReferenceBeanHandlerInterface timeReference;

    public TimeImportListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_EXECUTION)) {
            this.prepareVo();
            this.execution();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_TEMP_OUTPUT)) {
            this.prepareVo();
            this.tempOutput();
        }
    }

    protected void setImportListInfo() {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey("TimeImportTableType");
        vo.setReShowCommand(CMD_RE_SHOW);
        vo.setSearchCommand(CMD_SEARCH);
        vo.setSortCommand(CMD_SORT);
        vo.setExecuteCommand(CMD_EXECUTION);
        vo.setTemplateOutputCommand(CMD_TEMP_OUTPUT);
        this.setPageInfo(CMD_PAGE, this.getListLength());
    }

    protected void show() throws MospException {
        this.setImportListInfo();
        this.initImportListVoFields();
    }

    protected void execution() throws MospException {
        this.time = (TimeBeanHandlerInterface)this.createHandler(TimeBeanHandlerInterface.class);
        this.timeReference = (TimeReferenceBeanHandlerInterface)this.createHandler(TimeReferenceBeanHandlerInterface.class);
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        ImportDtoInterface importDto = this.reference().importRefer().findForKey(vo.getRadSelect());
        if (importDto == null) {
            this.addInsertFailedMessage();
            return;
        }
        this.registImportFile(importDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
    }

    protected void registImportFile(ImportDtoInterface importDto) throws MospException {
        if ("import_tmd_attendance".equals(importDto.getImportTable())) {
            this.importAttendance(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_attendance_self".equals(importDto.getImportTable())) {
            this.importAttendanceSelf(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_total_time".equals(importDto.getImportTable())) {
            this.importTotalTime(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_paid_holiday".equals(importDto.getImportTable())) {
            this.importPaidHoliday(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_stock_holiday".equals(importDto.getImportTable())) {
            this.importStockHoliday(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_holiday".equals(importDto.getImportTable())) {
            this.importHoliday(importDto, OrangeSignalUtility.parse((InputStream)this.mospParams.getRequestFile("filImport")));
        } else if ("import_tmd_holiday_request".equals(importDto.getImportTable())) {
            ImportBeanInterface importBean = this.time.holidayRequestImport();
            importBean.importFile(importDto, this.mospParams.getRequestFile("filImport"));
        } else if ("import_tmd_work_on_holiday_request".equals(importDto.getImportTable()) || "import_tmd_work_on_holiday_request_substitute_off".equals(importDto.getImportTable())) {
            ImportBeanInterface importBean = this.time.workOnHolidayRequestImport();
            importBean.importFile(importDto, this.mospParams.getRequestFile("filImport"));
        }
    }

    protected void importAttendance(ImportDtoInterface importDto, List<String[]> csvList) throws MospException {
        List list = this.timeReference.importTable().getAttendanceList(importDto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        AttendanceRegistBeanInterface regist = this.time.attendanceRegist();
        for (AttendanceDtoInterface dto : list) {
            if (this.mospParams.hasErrorMessage()) continue;
            regist.checkTimeExist(dto);
            regist.checkValidate(dto);
            regist.checkDraft(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.time.attendanceListRegist(dto.getWorkDate()).draft(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            regist.regist(dto);
        }
    }

    protected void importAttendanceSelf(ImportDtoInterface dto, List<String[]> csvList) throws MospException {
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        AttendanceRegistBeanInterface regist = this.time.attendanceRegist();
        RestRegistBeanInterface restRegist = this.time.restRegist();
        GoOutRegistBeanInterface goOutRegist = this.time.goOutRegist();
        AttendanceTransactionRegistBeanInterface transactionRegist = this.time.attendanceTransactionRegist();
        List list = this.timeReference.importTable().getAttendanceList(dto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        for (AttendanceDtoInterface attendanceDto : list) {
            if (this.mospParams.hasErrorMessage()) continue;
            restRegist.delete(attendanceDto.getPersonalId(), attendanceDto.getWorkDate(), attendanceDto.getTimesWork());
            if (this.mospParams.hasErrorMessage()) continue;
            goOutRegist.delete(attendanceDto.getPersonalId(), attendanceDto.getWorkDate(), attendanceDto.getTimesWork());
            if (this.mospParams.hasErrorMessage()) continue;
            regist.checkTimeExist(attendanceDto);
            regist.checkValidate(attendanceDto);
            regist.checkAppli(attendanceDto);
            WorkflowDtoInterface workflowDto = workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow());
            if (workflowDto == null) {
                workflowDto = workflowRegist.getInitDto();
            }
            workflowRegist.setSelfApproval(workflowDto);
            workflowDto.setFunctionCode("1");
            workflowDto = workflowRegist.appli(workflowDto, attendanceDto.getPersonalId(), attendanceDto.getWorkDate(), 1, null);
            if (this.mospParams.hasErrorMessage()) continue;
            attendanceDto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(attendanceDto);
            transactionRegist.regist(attendanceDto);
        }
    }

    protected void importTotalTime(ImportDtoInterface importDto, List<String[]> csvList) throws MospException {
        ApplicationReferenceBeanInterface application = this.timeReference.application();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference.timeSetting();
        CutoffReferenceBeanInterface cutoff = this.timeReference.cutoff();
        List list = this.timeReference.importTable().getTotalTimeList(importDto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        for (TotalTimeDataDtoInterface dto : list) {
            this.time.totalTimeRegist().regist(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            Integer state = this.timeReference.totalTimeEmployeeTransaction().getCutoffState(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth());
            if (state != null && state == 1) continue;
            ApplicationDtoInterface applicationDto = application.findForPerson(dto.getPersonalId(), dto.getCalculationDate());
            application.chkExistApplication(applicationDto, dto.getCalculationDate());
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            TimeSettingDtoInterface timeSettingDto = timeSetting.getTimeSettingInfo(applicationDto.getWorkSettingCode(), dto.getCalculationDate());
            timeSetting.chkExistTimeSetting(timeSettingDto, dto.getCalculationDate());
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            CutoffDtoInterface cutoffDto = cutoff.getCutoffInfo(timeSettingDto.getCutoffCode(), dto.getCalculationDate());
            cutoff.chkExistCutoff(cutoffDto, dto.getCalculationDate());
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            ArrayList<String> personalIdlist = new ArrayList<String>();
            personalIdlist.add(dto.getPersonalId());
            this.time.totalTimeEmployeeTransactionRegist().draft(personalIdlist, dto.getCalculationYear(), dto.getCalculationMonth(), cutoffDto.getCutoffCode());
        }
    }

    protected void importPaidHoliday(ImportDtoInterface importDto, List<String[]> csvList) throws MospException {
        PaidHolidayDataRegistBeanInterface regist = this.time.paidHolidayDataRegist();
        List list = this.timeReference.importTable().getPaidHolidayList(importDto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        for (PaidHolidayDataDtoInterface dto : list) {
            PaidHolidayDataDtoInterface paidHolidayDataDto = this.timeReference.paidHolidayData().findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
            if (paidHolidayDataDto == null) {
                regist.insert(dto);
                continue;
            }
            regist.update(dto);
        }
    }

    protected void importStockHoliday(ImportDtoInterface importDto, List<String[]> csvList) throws MospException {
        StockHolidayDataRegistBeanInterface regist = this.time.stockHolidayDataRegist();
        List list = this.timeReference.importTable().getStockHolidayList(importDto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        for (StockHolidayDataDtoInterface dto : list) {
            StockHolidayDataDtoInterface stockHolidayDataDto = this.timeReference.stockHolidayData().findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
            if (stockHolidayDataDto == null) {
                regist.insert(dto);
                continue;
            }
            regist.update(dto);
        }
    }

    protected void importHoliday(ImportDtoInterface importDto, List<String[]> csvList) throws MospException {
        HolidayDataRegistBeanInterface regist = this.time.holidayDataRegist();
        List list = this.timeReference.importTable().getHolidayDataList(importDto.getImportCode(), csvList);
        if (this.mospParams.hasErrorMessage() || list.isEmpty()) {
            return;
        }
        for (HolidayDataDtoInterface dto : list) {
            HolidayDataDtoInterface holidayDataDto = this.timeReference.holidayData().findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode(), dto.getHolidayType());
            if (holidayDataDto == null) {
                regist.insert(dto);
                continue;
            }
            regist.update(dto);
        }
    }
}

