/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.input.vo.ApprovalHistoryVo;

public class ApprovalHistoryAction
extends TimeAction {
    public static final String CMD_TIME_APPROVAL_HISTORY_SELECT_SHOW = "TM1811";
    public static final String CMD_TIME_APPROVAL_HISTORY_RE_SEARCH = "TM1813";
    public static final String CMD_TRANSFER = "TM1816";
    public static final String CMD_OVERTIME_APPROVAL_HISTORY_SELECT_SHOW = "TM1821";
    public static final String CMD_LEAVE_APPROVAL_HISTORY_SELECT_SHOW = "TM1831";
    public static final String CMD_APPROVAL_HISTORY_HOLIDAY_WORK_SELECT_SHOW = "TM1841";
    public static final String CMD_APPROVAL_HISTORY_LIEU_SELECT_SHOW = "TM1851";
    public static final String CMD_DIFFERENCE_WORK_APPROVAL_HISTORY_SELECT_SHOW = "TM1861";
    public static final String CMD_WORK_TYPE_CHANGE_APPROVAL_HISTORY_SELECT_SHOW = "TM1871";

    public ApprovalHistoryAction() {
        this.topicPathCommand = CMD_TIME_APPROVAL_HISTORY_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new ApprovalHistoryVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_TIME_APPROVAL_HISTORY_SELECT_SHOW)) {
            this.prepareVo();
            this.timeApprovalHistorySelectShow(true);
        } else if (this.mospParams.getCommand().equals(CMD_TIME_APPROVAL_HISTORY_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.timeApprovalHistorySelectShow(false);
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_OVERTIME_APPROVAL_HISTORY_SELECT_SHOW)) {
            this.prepareVo();
            this.overtimeApprovalHistorySelectShow();
        } else if (this.mospParams.getCommand().equals(CMD_LEAVE_APPROVAL_HISTORY_SELECT_SHOW)) {
            this.prepareVo();
            this.leaveApprovalHistorySelectShow();
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_HISTORY_HOLIDAY_WORK_SELECT_SHOW)) {
            this.prepareVo();
            this.approvalHistoryHolidayWorkSelectShow();
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_HISTORY_LIEU_SELECT_SHOW)) {
            this.prepareVo();
            this.approvalHistoryLieuSelectShow();
        } else if (this.mospParams.getCommand().equals(CMD_DIFFERENCE_WORK_APPROVAL_HISTORY_SELECT_SHOW)) {
            this.prepareVo();
            this.differenceWorkApprovalHistorySelectShow();
        } else if (this.mospParams.getCommand().equals(CMD_WORK_TYPE_CHANGE_APPROVAL_HISTORY_SELECT_SHOW)) {
            this.prepareVo();
            this.workTypeChangeApprovalHistorySelectShow();
        }
    }

    protected void setDefaultValues() {
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        vo.setLblAttendanceDate("");
        vo.setLblAttendanceWorkType("");
        vo.setLblAttendanceStartDate("");
        vo.setLblAttendanceEndDate("");
        vo.setLblAttendanceWorkTime("");
        vo.setLblAttendanceRestTime("");
        vo.setLblAttendancePrivateTime("");
        vo.setLblAttendanceLateTime("");
        vo.setLblAttendanceLeaveEarly("");
        vo.setLblAttendanceLateLeaveEarly("");
        vo.setLblAttendanceOverTimeIn("");
        vo.setLblAttendanceOverTimeOut("");
        vo.setLblAttendanceWorkOnHoliday("");
        vo.setLblAttendanceLateNight("");
        vo.setLblAttendanceRemark("");
        vo.setLblAttendanceCorrection("");
        vo.setLblAttendanceState("");
        vo.setLblHolidayType2("");
        vo.setLblApprovalState(new String[0]);
        vo.setLblApprovalResult(new String[0]);
        vo.setLblApprovalApprover(new String[0]);
        vo.setLblApprovalComment(new String[0]);
        vo.setLblApprovalDate(new String[0]);
    }

    public void timeApprovalHistorySelectShow(boolean needWorkflow) throws MospException {
        this.setDefaultValues();
        this.setApprovalHistory(needWorkflow);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        this.setEmployeeInfo(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
        vo.setLblAttendanceState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        AttendanceListDto dto = this.timeReference().attendanceList().getAttendanceListDto(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
        this.checkSelectedDataExist((Object)dto);
        vo.setLblAttendanceDate(DateUtility.getStringDateAndDay((Date)dto.getWorkDate()));
        vo.setLblAttendanceWorkType(dto.getWorkTypeAbbr());
        vo.setLblAttendanceStartDate(dto.getStartTimeString());
        vo.setLblAttendanceEndDate(dto.getEndTimeString());
        vo.setLblAttendanceWorkTime(dto.getWorkTimeString());
        vo.setLblAttendanceRestTime(dto.getRestTimeString());
        vo.setLblAttendancePrivateTime(dto.getPrivateTimeString());
        vo.setLblAttendanceLateTime(dto.getLateTimeString());
        vo.setLblAttendanceLeaveEarly(dto.getLeaveEarlyTimeString());
        vo.setLblAttendanceLateLeaveEarly(dto.getLateLeaveEarlyTimeString());
        vo.setLblAttendanceOverTimeIn(dto.getOvertimeInString());
        vo.setLblAttendanceOverTimeOut(dto.getOvertimeOutString());
        vo.setLblAttendanceWorkOnHoliday(dto.getHolidayWorkTimeString());
        vo.setLblAttendanceLateNight(dto.getLateNightTimeString());
        vo.setLblAttendanceRemark(MospUtility.concat((String[])new String[]{dto.getRemark(), dto.getTimeComment()}));
        vo.setLblAttendanceCorrection(dto.getCorrectionInfo());
    }

    public void overtimeApprovalHistorySelectShow() throws MospException {
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        OvertimeRequestDtoInterface dto = this.timeReference().overtimeRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        AttendanceDtoInterface attendanceDto = this.timeReference().attendance().findForKey(dto.getPersonalId(), dto.getRequestDate(), 1);
        WorkflowDtoInterface attendanceWorkflowDto = null;
        if (attendanceDto != null) {
            attendanceWorkflowDto = this.reference().workflow().getLatestWorkflowInfo(attendanceDto.getWorkflow());
        }
        vo.setLblOverTimeDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblOverTimeType(this.getOvertimeTypeName(dto.getOvertimeType()));
        vo.setLblOverTimeSchedule(this.getTimeColonFormat(dto.getRequestTime()));
        if (attendanceWorkflowDto != null && attendanceWorkflowDto.getWorkflowStatus().equals("9")) {
            if (dto.getOvertimeType() == 1) {
                vo.setLblOverTimeResultTime(this.getTimeColonFormat(attendanceDto.getOvertimeBefore()));
            } else {
                vo.setLblOverTimeResultTime(this.getTimeColonFormat(attendanceDto.getOvertimeAfter()));
            }
        } else {
            vo.setLblOverTimeResultTime(this.mospParams.getName("Hyphen"));
        }
        vo.setLblOverTimeRequestReason(dto.getRequestReason());
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow());
        vo.setLblOverTimeState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblOverTimeApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    public void leaveApprovalHistorySelectShow() throws MospException {
        this.setDefaultValues();
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        vo.setLblHolidayDate("");
        vo.setLblHolidayType1("");
        vo.setLblHolidayType2("");
        vo.setLblHolidayLength("");
        vo.setLblHolidayRequestReason("");
        vo.setLblHolidayState("");
        vo.setLblHolidayApprover("");
        HolidayRequestDtoInterface dto = this.timeReference().holidayRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        vo.setLblHolidayDate(DateUtility.getStringDateAndDay((Date)dto.getRequestStartDate()) + this.mospParams.getName("Wave") + DateUtility.getStringDateAndDay((Date)dto.getRequestEndDate()));
        vo.setLblHolidayType1(this.getHolidayType1Name(dto.getHolidayType1(), dto.getHolidayType2()));
        vo.setLblHolidayType2(this.getHolidayType2Abbr(dto.getHolidayType1(), dto.getHolidayType2(), dto.getRequestStartDate()));
        if (dto.getHolidayRange() == 1) {
            vo.setLblHolidayLength(this.mospParams.getName("AllTime"));
        } else if (dto.getHolidayRange() == 2) {
            vo.setLblHolidayLength(this.mospParams.getName("AmRest"));
        } else if (dto.getHolidayRange() == 3) {
            vo.setLblHolidayLength(this.mospParams.getName("PmRest"));
        } else if (dto.getHolidayRange() == 4) {
            vo.setLblHolidayLength(this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate()));
        }
        vo.setLblHolidayRequestReason(dto.getRequestReason());
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow());
        vo.setLblHolidayState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblHolidayApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    protected void approvalHistoryHolidayWorkSelectShow() throws MospException {
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        List substituteList = this.timeReference().substitute().getSubstituteList(dto.getWorkflow());
        vo.setLblWorkOnHolidayWorkDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblWorkOnHolidayTime(this.getWorkOnHolidaySchedule(dto));
        vo.setLblWorkOnHolidayReason(dto.getRequestReason());
        vo.setLblWorkOnHolidayDate1("");
        vo.setLblWorkOnHolidayDate2("");
        int i = 0;
        for (SubstituteDtoInterface substituteDto : substituteList) {
            Date substituteDate = substituteDto.getSubstituteDate();
            int substituteRange = substituteDto.getSubstituteRange();
            if (i == 0) {
                vo.setLblWorkOnHolidayDate1(this.getHolidayDate(substituteDate, substituteRange));
            }
            ++i;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        vo.setLblWorkOnHolidayState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblWorkOnHolidayApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    protected void approvalHistoryLieuSelectShow() throws MospException {
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        String blank = " ";
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtility.getStringDateAndDay((Date)dto.getRequestDate())).append(" ").append(this.getSubHolidayTypeName(dto.getHolidayRange()));
        vo.setLblSubHolidayDate(sb.toString());
        sb = new StringBuffer();
        sb.append(this.setWorkDateSubHolidayType(dto.getWorkDateSubHolidayType())).append(" ");
        sb.append(DateUtility.getStringDateAndDay((Date)dto.getWorkDate())).append(" ");
        sb.append(this.getSubHolidayTypeName(dto.getHolidayRange()));
        vo.setLblSubHolidayWorkDate(sb.toString());
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        vo.setLblSubHolidayState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblSubHolidayApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    protected void differenceWorkApprovalHistorySelectShow() throws MospException {
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        DifferenceRequestDtoInterface dto = this.timeReference().differenceRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        vo.setLblDifferenceDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblDifferenceType(this.getDifferenceTypeName(dto.getDifferenceType()));
        vo.setLblDifferenceTime(DateUtility.getStringTime((Date)dto.getRequestStart(), (Date)dto.getRequestDate()) + this.mospParams.getName("Wave") + DateUtility.getStringTime((Date)dto.getRequestEnd(), (Date)dto.getRequestDate()));
        vo.setLblDifferenceReason(dto.getRequestReason());
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        vo.setLblDifferenceState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblDifferenceApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    protected void workTypeChangeApprovalHistorySelectShow() throws MospException {
        this.setApprovalHistory(true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        WorkTypeChangeRequestDtoInterface dto = this.timeReference().workTypeChangeRequest().findForWorkflow(vo.getWorkflow());
        this.checkSelectedDataExist((Object)dto);
        vo.setLblWorkTypeChangeDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblWorkTypeChangeWorkType(this.timeReference().workType().getWorkTypeAbbrAndTime(dto.getWorkTypeCode(), dto.getRequestDate()));
        vo.setLblWorkTypeChangeReason(dto.getRequestReason());
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        vo.setLblWorkTypeChangeState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblWorkTypeChangeApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow())));
    }

    protected void setApprovalHistory(boolean needWorkflow) throws MospException {
        WorkflowDtoInterface dto;
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        if (needWorkflow) {
            long workflow = this.getTargetWorkflow();
            vo.setWorkflow(workflow);
        }
        if ((dto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow())) == null) {
            this.addRequestNotExistErrorMessage();
            return;
        }
        this.checkSelectedDataExist((Object)dto);
        this.setEmployeeInfo(dto.getPersonalId(), dto.getWorkflowDate());
        List list = this.reference().workflowComment().getWorkflowCommentHistory(dto.getWorkflow());
        String[] aryLblApprovalState = new String[list.size()];
        String[] aryLblApprovalResult = new String[list.size()];
        String[] aryLblApprovalApprover = new String[list.size()];
        String[] aryLblApprovalComment = new String[list.size()];
        String[] aryLblApproverDate = new String[list.size()];
        int i = 0;
        for (WorkflowCommentDtoInterface comment : list) {
            aryLblApprovalState[i] = this.getStatusStageValueView(comment.getWorkflowStatus(), comment.getWorkflowStage());
            aryLblApprovalResult[i] = this.reference().workflowIntegrate().getWorkflowOperation(comment.getWorkflowStatus());
            aryLblApprovalApprover[i] = this.getEmployeeName(comment.getPersonalId());
            aryLblApprovalComment[i] = comment.getWorkflowComment();
            aryLblApproverDate[i] = DateUtility.getStringDateAndDayAndTime((Date)comment.getWorkflowDate());
            ++i;
        }
        vo.setLblApprovalState(aryLblApprovalState);
        vo.setLblApprovalResult(aryLblApprovalResult);
        vo.setLblApprovalApprover(aryLblApprovalApprover);
        vo.setLblApprovalComment(aryLblApprovalComment);
        vo.setLblApprovalDate(aryLblApproverDate);
    }

    protected String getHolidayDate(Date date, int range) throws MospException {
        String base = DateUtility.getStringDateAndDay((Date)date);
        if (this.timeReference().workOnHolidayRequest().useHalfSubstitute()) {
            if (range == 1) {
                return base + " " + this.getCodeName(range, "SubstituteWorkRange");
            }
            if (range == 2 || range == 3) {
                return base + " " + this.getCodeName(range, "SubstituteHolidayRange");
            }
        }
        return base;
    }

    protected void transfer() {
        ApprovalHistoryVo vo = (ApprovalHistoryVo)this.mospParams.getVo();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        this.mospParams.setNextCommand("TM1911");
    }

    protected void addRequestNotExistErrorMessage() {
        String rep = this.mospParams.getName("Application", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

