/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.comparator.settings.ManagementRequestRequestDateComparator;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.input.vo.CancellationRequestVo;
import jp.mosp.time.utils.TimeUtility;

public class CancellationRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM011000";
    public static final String CMD_SEARCH = "TM011002";
    public static final String CMD_RE_SHOW = "TM011003";
    public static final String CMD_SORT = "TM011007";
    public static final String CMD_PAGE = "TM011008";
    public static final String CMD_EDIT_MODE = "TM011011";
    public static final String CMD_APPLI = "TM011015";
    public static final String CMD_TRANSFER = "TM011020";

    public CancellationRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new CancellationRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.search();
    }

    protected void search() throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        int year = this.getInt(vo.getPltSearchRequestYear());
        int month = this.getInt(vo.getPltSearchRequestMonth());
        String day = vo.getPltSearchRequestDay();
        Date firstDate = null;
        Date lastDate = null;
        if (day.isEmpty()) {
            CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
            CutoffDtoInterface cutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, month);
            if (this.mospParams.hasErrorMessage()) {
                this.addNoSearchResultMessage();
                return;
            }
            int cutoffDate = cutoffDto.getCutoffDate();
            firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)year, (int)month);
            lastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)year, (int)month);
        } else {
            firstDate = DateUtility.getDate((int)year, (int)month, (int)this.getInt(day));
            lastDate = DateUtility.getDate((int)year, (int)month, (int)this.getInt(day));
        }
        List list = this.timeReference().approvalInfo().getCompletedList(vo.getPersonalId(), firstDate, lastDate, this.getFunctionCodeSet());
        vo.setList(list);
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void insertMode() throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPulldown();
        vo.setModeCardEdit("insert");
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
    }

    protected void editMode() throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        long workflow = vo.getAryWorkflow()[this.getTransferredIndex()];
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        ManagementRequestListDtoInterface dto = this.timeReference().approvalInfo().getManagementRequestListDto(workflowDto, false);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setTxtEditRequestReason("");
        vo.setModeCardEdit("edit");
    }

    protected void appli() throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        BaseDtoInterface dto = this.timeReference().approvalInfo().getRequestDtoForWorkflow(vo.getWorkflow(), true);
        this.time().timeApproval().checkCancelAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow());
        if (workflowDto == null) {
            this.addInsertFailedMessage();
            return;
        }
        if (workflowDto.getFunctionCode().equals("1")) {
            this.platform().workflowRegist().cancelAttendanceAppli(workflowDto, vo.getTxtEditRequestReason(), vo.getCkbWithdrawn());
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            if (workflowDto.getWorkflowStatus().equals("7") && this.isSelfApproval(workflowDto)) {
                this.time.attendanceRegist().delete(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
                this.time.timeApproval().registAttendanceTransaction(workflowDto.getPersonalId(), workflowDto.getWorkflowDate(), dto);
            }
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
        } else {
            this.platform().workflowRegist().cancelAppli(workflowDto, vo.getTxtEditRequestReason(), vo.getCkbWithdrawn());
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            if (this.isSelfApproval(workflowDto) && workflowDto.getWorkflowStatus().equals("5")) {
                if ("4".equals(workflowDto.getFunctionCode())) {
                    this.time.attendanceRegist().delete(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
                } else if ("2".equals(workflowDto.getFunctionCode()) || "3".equals(workflowDto.getFunctionCode()) || "5".equals(workflowDto.getFunctionCode()) || "6".equals(workflowDto.getFunctionCode())) {
                    this.time.timeApproval().reDraft(workflowDto.getPersonalId(), workflowDto.getWorkflowDate(), false, false, false);
                } else if ("7".equals(workflowDto.getFunctionCode())) {
                    this.time.timeApproval().reDraft(workflowDto.getPersonalId(), workflowDto.getWorkflowDate(), false, false, true);
                }
                this.time.timeApproval().registAttendanceTransaction(workflowDto.getPersonalId(), workflowDto.getWorkflowDate(), dto);
            }
        }
        this.commit();
        this.addCancellAppliMessage();
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
            vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
            vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
            this.search();
        }
    }

    protected void transfer() {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow()[this.getTransferredIndex()]);
        this.mospParams.setNextCommand(vo.getAryHistoryCmd()[this.getTransferredIndex()]);
    }

    protected Set<String> getFunctionCodeSet() {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        if (vo.getPltSearchApprovalType().isEmpty()) {
            return TimeUtility.getTimeFunctionSet();
        }
        HashSet<String> functionCodeSet = new HashSet<String>();
        functionCodeSet.add(vo.getPltSearchApprovalType());
        return functionCodeSet;
    }

    public void setDefaultValues() throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setPltSearchApprovalType("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        vo.setPltSearchRequestDay("");
        vo.setLblRequestDate("");
        vo.setLblRequestType("");
        vo.setLblRequestInfo("");
        vo.setLblState("");
        vo.setTxtEditRequestReason("");
        vo.setCkbWithdrawn("0");
        vo.setJsRequestType("");
    }

    protected void setPulldown() {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        vo.setAryPltSearchRequestYear(this.getYearArray(DateUtility.getYear((Date)this.getSystemDate())));
        vo.setAryPltSearchRequestMonth(this.getMonthArray());
        vo.setAryPltSearchRequestDay(this.getDayArray(true));
    }

    protected void setVoFields(ManagementRequestListDtoInterface dto) throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        vo.setWorkflow(dto.getWorkflow());
        vo.setLblRequestDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblRequestType(this.getRequestTypeForView(dto));
        vo.setLblRequestInfo(this.getRequestInfo(dto));
        vo.setLblState(this.getStatusStageValueView(dto.getState(), dto.getStage()));
        if (dto.getRequestType().equals("1")) {
            vo.setCkbWithdrawn("0");
            vo.setJsRequestType("1");
        } else {
            vo.setCkbWithdrawn("1");
            vo.setJsRequestType("");
        }
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        CancellationRequestVo vo = (CancellationRequestVo)this.mospParams.getVo();
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblRequestType = new String[list.size()];
        String[] aryLblRequestInfo = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryBackColor = new String[list.size()];
        String[] aryHistoryCmd = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)list.get(i);
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryLblRequestType[i] = this.getRequestTypeForView(dto);
            aryLblRequestInfo[i] = this.getRequestInfo(dto);
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryLblApproverName[i] = dto.getApproverName();
            aryBackColor[i] = this.setBackColor(dto.getPersonalId(), dto.getRequestDate(), dto.getRequestType());
            aryHistoryCmd[i] = this.getHistoryCommand(dto.getRequestType());
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryLblRequestDate(aryLblRequestDate);
        vo.setAryLblRequestType(aryLblRequestType);
        vo.setAryLblRequestInfo(aryLblRequestInfo);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryLblApproverName(aryLblApproverName);
        vo.setAryBackColor(aryBackColor);
        vo.setAryHistoryCmd(aryHistoryCmd);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected boolean isSelfApproval(WorkflowDtoInterface dto) {
        if (dto.getApproverId().equals("SELF_APPRO")) {
            return true;
        }
        return dto.getRouteCode().equals("SELF_APPRO");
    }
}

