/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.time.base.AttendanceListBaseAction;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.input.vo.ScheduleReferenceVo;

public class ScheduleReferenceAction
extends AttendanceListBaseAction {
    public static final String CMD_SHOW = "TM1300";
    public static final String CMD_SELECT_SHOW = "TM1301";
    public static final String CMD_SEARCH = "TM1302";
    public static final String CMD_OUTPUT = "TM1396";

    protected BaseVo getSpecificVo() {
        return new ScheduleReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_OUTPUT)) {
            this.prepareVo(true, false);
            this.output();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        this.setVoList(attendanceListReference.getScheduleList(personalId, targetDate));
        this.setVoFields(attendanceListReference);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        int year = this.getTargetYear();
        int month = this.getTargetMonth();
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        this.setVoList(attendanceListReference.getScheduleList(personalId, year, month));
        this.setVoFields(attendanceListReference);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void search() throws MospException {
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        String year = this.getTransferredYear();
        String month = this.getTransferredMonth();
        if (year == null || month == null) {
            year = vo.getPltSelectYear();
            month = vo.getPltSelectMonth();
        }
        AttendanceListReferenceBeanInterface attendanceListReference = this.timeReference().attendanceList();
        this.setVoList(attendanceListReference.getScheduleList(personalId, this.getInt(year), this.getInt(month)));
        this.setVoFields(attendanceListReference);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void output() throws MospException {
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int year = this.getInt(vo.getPltSelectYear());
        int month = this.getInt(vo.getPltSelectMonth());
        this.timeReference().scheduleBook().makeScheduleBook(personalId, year, month);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void setVoFields(AttendanceListReferenceBeanInterface attendanceListReference) throws MospException {
        super.setVoFields(attendanceListReference);
        ScheduleReferenceVo vo = (ScheduleReferenceVo)this.mospParams.getVo();
        vo.setLblApplicationSchedule(attendanceListReference.getScheduleName());
        vo.setLblEndRecordTime(false);
        vo.setLblStartRecordTime(false);
        vo.setLblTimesCat(false);
    }
}

