/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestSearchBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.comparator.settings.SubHolidayRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.input.vo.SubHolidayRequestVo;
import jp.mosp.time.utils.TimeUtility;

public class SubHolidayRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1700";
    public static final String CMD_SELECT_SHOW = "TM1701";
    public static final String CMD_SEARCH = "TM1702";
    public static final String CMD_RE_SHOW = "TM1703";
    public static final String CMD_DRAFT = "TM1704";
    public static final String CMD_APPLI = "TM1705";
    public static final String CMD_TRANSFER = "TM1706";
    public static final String CMD_WITHDRAWN = "TM1707";
    public static final String CMD_SORT = "TM1708";
    public static final String CMD_PAGE = "TM1709";
    public static final String CMD_BATCH_WITHDRAWN = "TM1736";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1790";
    public static final String CMD_INSERT_MODE = "TM1791";
    public static final String CMD_EDIT_MODE = "TM1792";
    public static final String CMD_BATCH_UPDATE = "TM1795";

    public SubHolidayRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SubHolidayRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        this.search();
    }

    protected void select() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        this.search();
    }

    protected void search() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestSearchBeanInterface search = this.timeReference().subHolidayRequestSearch();
        search.setPersonalId(vo.getPersonalId());
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = 1;
        int endMonth = 12;
        if (!vo.getPltSearchRequestMonth().isEmpty()) {
            endMonth = startMonth = Integer.parseInt(vo.getPltSearchRequestMonth());
        }
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffDtoInterface startMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
            return;
        }
        CutoffDtoInterface endMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, endMonth);
        String startMonthCutoffCode = startMonthCutoffDto == null ? null : startMonthCutoffDto.getCutoffCode();
        String endMonthCutoffCode = endMonthCutoffDto == null ? null : endMonthCutoffDto.getCutoffCode();
        Date firstDate = null;
        if (startMonthCutoffCode != null) {
            firstDate = cutoffUtil.getCutoffFirstDate(startMonthCutoffCode, year, startMonth);
        }
        Date lastDate = null;
        if (endMonthCutoffCode != null) {
            lastDate = cutoffUtil.getCutoffLastDate(endMonthCutoffCode, year, endMonth);
        }
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        int workYear = Integer.parseInt(vo.getPltSearchWorkYear());
        int startWorkMonth = 1;
        int endWorkMonth = 12;
        if (!vo.getPltSearchWorkMonth().isEmpty()) {
            endWorkMonth = startWorkMonth = Integer.parseInt(vo.getPltSearchWorkMonth());
        }
        CutoffDtoInterface startWorkMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), workYear, startWorkMonth);
        CutoffDtoInterface endWorkMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), workYear, endWorkMonth);
        String startWorkMonthCutoffCode = startWorkMonthCutoffDto == null ? null : startWorkMonthCutoffDto.getCutoffCode();
        String endWorkMonthCutoffCode = endWorkMonthCutoffDto == null ? null : endWorkMonthCutoffDto.getCutoffCode();
        Date workFirstDate = null;
        if (startWorkMonthCutoffCode != null) {
            workFirstDate = cutoffUtil.getCutoffFirstDate(startWorkMonthCutoffCode, workYear, startWorkMonth);
        }
        Date workLastDate = null;
        if (endWorkMonthCutoffCode != null) {
            workLastDate = cutoffUtil.getCutoffLastDate(endWorkMonthCutoffCode, workYear, endWorkMonth);
        }
        search.setWorkStartDate(workFirstDate);
        search.setWorkEndDate(workLastDate);
        search.setWorkflowStatus(vo.getPltSearchState());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.addNoSearchResultMessage();
        }
    }

    protected void draft() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.setSubHolidayDtoFields(dto);
        regist.validate(dto);
        regist.checkDraft(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("5");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("WorkPaper")}));
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addDraftMessage();
        Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
        Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
        vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
        this.search();
        this.setEditUpdateMode(dto.getRequestDate(), dto.getHolidayRange());
        vo.setModeCardEdit("draft");
    }

    protected void appli() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.setSubHolidayDtoFields(dto);
        regist.checkAppli(dto);
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("5");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.regist(dto);
            regist.deleteAttendance(dto);
            regist.draftAttendance(dto);
            attendanceTransactionRegist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addAppliMessage();
        int holidayRange = Integer.parseInt(vo.getPltEditHolidayRange());
        if (holidayRange == 2 || holidayRange == 3) {
            this.addHalfHolidayRequestMessage();
        }
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
            vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
            vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
            Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
            vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
            vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
            this.search();
        }
    }

    protected void withdrawn() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflowDto.getWorkflow()));
            regist.delete(dto);
        } else if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
            workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        if (isDraft) {
            this.addDeleteMessage();
        } else {
            this.addTakeDownMessage();
        }
        this.insertMode();
        Date searchRequestDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchRequestDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchRequestDate));
        Date searchWorkDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getWorkDate());
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchWorkDate));
        vo.setPltSearchWorkMonth(DateUtility.getStringMonthM((Date)searchWorkDate));
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        this.time().subHolidayRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setActivationDate() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestRegistBeanInterface regist = this.time().subHolidayRequestRegist();
        if (vo.getModeActivateDate().equals("chaning")) {
            SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestDate(this.getEditRequestDate());
            dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRange()));
            regist.checkSetRequestDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                this.addFixFailedMessage();
                return;
            }
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        if (!this.setEditPulldown().booleanValue()) {
            vo.setModeActivateDate("chaning");
        }
    }

    protected void insertMode() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setCompensationDay();
        this.setUnused();
        vo.setModeCardEdit("new");
        this.setPulldown();
        vo.setModeActivateDate("chaning");
        this.timeReference().subHolidayRequest().chkBasicInfo(vo.getPersonalId(), this.getEditRequestDate());
    }

    protected void editMode() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            vo.setComparatorName(SubHolidayRequestRequestDateComparator.class.getName());
            this.search();
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()), Integer.parseInt(this.getTransferredType()));
        vo.setModeActivateDate("chaning");
        this.setActivationDate();
    }

    protected void batchUpdate() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        boolean containsHalfHoliday = this.time().subHolidayRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        if (containsHalfHoliday) {
            this.addHalfHolidayRequestMessage();
        }
        this.insertMode();
        this.search();
    }

    protected void transfer() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1851");
    }

    public void setDefaultValues() throws MospException {
        Date date;
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        Date targetDate = date = this.getSystemDate();
        if (this.getTargetDate() != null) {
            targetDate = this.getTargetDate();
        }
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)targetDate));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)targetDate));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)targetDate));
        vo.setRecordId(0L);
        vo.setPltEditHolidayRange(String.valueOf(1));
        vo.setPltEditWorkDate("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        vo.setPltSearchWorkYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchWorkMonth("");
        vo.setPltSearchState("");
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setAryLblCompensationWorkDate(new String[0]);
        vo.setAryLblCompensationExpirationDate(new String[0]);
        vo.setAryLblCompensationType(new String[0]);
        vo.setAryLblCompensationRange(new String[0]);
        vo.setAryLblCompensationDayTh(new String[0]);
        vo.setAryLblCompensationDayForWorkOnDayOff(new String[0]);
        vo.setAryLblCompensationDayForNightWork(new String[0]);
    }

    protected void setCompensationDay() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference().timeSetting();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        Date systemDate = this.getSystemDate();
        ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), systemDate);
        if (applicationDto == null) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = timeSetting.getTimeSettingInfo(applicationDto.getWorkSettingCode(), systemDate);
        if (timeSettingDto == null) {
            return;
        }
        CutoffDtoInterface cutoffDto = this.timeReference().cutoff().getCutoffInfo(timeSettingDto.getCutoffCode(), systemDate);
        if (cutoffDto == null) {
            return;
        }
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)cutoffDto.getCutoffDate(), (Date)systemDate);
        Date cutoffFirstDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)DateUtility.getYear((Date)cutoffMonth), (int)DateUtility.getMonth((Date)cutoffMonth));
        ApplicationDtoInterface cutoffApplicationDto = application.findForPerson(vo.getPersonalId(), cutoffFirstDate);
        if (cutoffApplicationDto == null) {
            return;
        }
        TimeSettingDtoInterface cutoffTimeSettingDto = timeSetting.getTimeSettingInfo(cutoffApplicationDto.getWorkSettingCode(), cutoffFirstDate);
        if (cutoffTimeSettingDto == null) {
            return;
        }
        Date startDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)cutoffFirstDate, (int)(-cutoffTimeSettingDto.getSubHolidayLimitMonth())), (int)(-cutoffTimeSettingDto.getSubHolidayLimitDate()));
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface subHolidayDto : this.timeReference().subHoliday().getSubHolidayList(vo.getPersonalId(), startDate, systemDate)) {
            double useDays = 0.0;
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : this.timeReference().subHolidayRequest().getSubHolidayRequestList(subHolidayDto.getPersonalId(), subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType())) {
                WorkflowDtoInterface workflowDto = workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (workflowDto == null || workflowIntegrate.isDraft(workflowDto) || workflowIntegrate.isWithDrawn(workflowDto)) continue;
                int subHolidayRange = subHolidayRequestDto.getHolidayRange();
                if (subHolidayRange == 1) {
                    useDays += 1.0;
                    continue;
                }
                if (subHolidayRange != 2 && subHolidayRange != 3) continue;
                useDays += 0.5;
            }
            if (subHolidayDto.getSubHolidayDays() <= useDays) continue;
            subHolidayDto.setSubHolidayDays(subHolidayDto.getSubHolidayDays() - useDays);
            list.add(subHolidayDto);
        }
        String[] aryLblCompensationWorkDate = new String[list.size()];
        String[] aryLblCompensationExpirationDate = new String[list.size()];
        String[] aryLblCompensationType = new String[list.size()];
        String[] aryLblCompensationRange = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            TimeSettingDtoInterface subHolidayTimeSettingDto;
            SubHolidayDtoInterface dto = (SubHolidayDtoInterface)list.get(i);
            ApplicationDtoInterface subHolidayApplicationDto = application.findForPerson(vo.getPersonalId(), dto.getWorkDate());
            if (subHolidayApplicationDto == null || (subHolidayTimeSettingDto = timeSetting.getTimeSettingInfo(subHolidayApplicationDto.getWorkSettingCode(), dto.getWorkDate())) == null) continue;
            String subHolidayName = "";
            int subHolidayType = dto.getSubHolidayType();
            if (subHolidayType == 2) {
                subHolidayName = this.mospParams.getName("Legal", new String[]{"CompensatoryHoliday"});
            } else if (subHolidayType == 1) {
                subHolidayName = this.mospParams.getName("Prescribed", new String[]{"CompensatoryHoliday"});
            } else {
                if (subHolidayType != 3) continue;
                subHolidayName = this.mospParams.getName("Midnight", new String[]{"CompensatoryHoliday"});
            }
            String subHolidayRange = "";
            double subHolidayDays = dto.getSubHolidayDays();
            if (subHolidayDays == 1.0) {
                subHolidayRange = this.mospParams.getName("AllTime");
            } else if (subHolidayDays == 0.5) {
                subHolidayRange = this.mospParams.getName("HalfTime");
            } else {
                if (subHolidayDays != 0.0) continue;
                subHolidayRange = this.mospParams.getName("Without");
            }
            aryLblCompensationWorkDate[i] = this.getStringDateAndDay(dto.getWorkDate());
            aryLblCompensationExpirationDate[i] = this.getStringDateAndDay(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getWorkDate(), (int)subHolidayTimeSettingDto.getSubHolidayLimitMonth()), (int)subHolidayTimeSettingDto.getSubHolidayLimitDate()));
            aryLblCompensationType[i] = subHolidayName;
            aryLblCompensationRange[i] = subHolidayRange;
        }
        vo.setAryLblCompensationWorkDate(aryLblCompensationWorkDate);
        vo.setAryLblCompensationExpirationDate(aryLblCompensationExpirationDate);
        vo.setAryLblCompensationType(aryLblCompensationType);
        vo.setAryLblCompensationRange(aryLblCompensationRange);
    }

    protected void setUnused() throws MospException {
    }

    protected void setSearchRequestDate(String year, String month) {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        vo.setPltSearchRequestYear(year);
        vo.setPltSearchRequestMonth(month);
    }

    private void setPulldown() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        int editRequestYear = DateUtility.getYear((Date)date);
        vo.setAryPltEditRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setAryPltSearchRequestYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
        vo.setAryPltSearchWorkYear(this.getYearArray(editRequestYear));
        vo.setAryPltSearchWorkMonth(this.getMonthArray(true));
        vo.setAryPltEditWorkDate(this.getInputActivateDateCompensatoryLeavePulldown());
        vo.setAryPltEditHolidayType(this.mospParams.getProperties().getCodeArray("Substitute1Range", false));
        vo.setAryPltSearchState(this.mospParams.getProperties().getCodeArray("ApprovalState", true));
    }

    protected void setSubHolidayDtoFields(SubHolidayRequestDtoInterface dto) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String[] aryWorkDate = vo.getPltEditWorkDate().split(",");
        dto.setTmdSubHolidayRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay()));
        dto.setHolidayRange(Integer.parseInt(vo.getPltEditHolidayRange()));
        dto.setWorkDate(DateUtility.getDate((String)aryWorkDate[0]));
        dto.setTimesWork(1);
        dto.setWorkDateSubHolidayType(Integer.parseInt(aryWorkDate[1]));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblWorkDate = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblDate = new String[list.size()];
        String[] aryLblRange = new String[list.size()];
        String[] aryLblWorkflow = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubHolidayRequestListDtoInterface dto = (SubHolidayRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdSubHolidayRequestId());
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate()) + " " + this.getHolidayRange(this.getInt(dto.getSubHolidayRange()));
            aryLblWorkDate[i] = this.setWorkDateSubHolidayType(dto.getWorkDateHolidayType()) + " " + DateUtility.getStringDateAndDay((Date)dto.getWorkDate());
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblApproverName[i] = dto.getApproverName();
            aryLblDate[i] = DateUtility.getStringDate((Date)dto.getRequestDate());
            aryLblRange[i] = dto.getSubHolidayRange();
            aryLblWorkflow[i] = String.valueOf(dto.getWorkflow());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbSubHolidayRequestListId(aryCkbRecordId);
        vo.setAryLblRequestDate(aryLblRequestDate);
        vo.setAryLblWorkDate(aryLblWorkDate);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblRange(aryLblRange);
        vo.setAryLblWorkflow(aryLblWorkflow);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected void setEditUpdateMode(Date requestDate, int holidayRange) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate, holidayRange);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
    }

    protected void setVoFields(SubHolidayRequestDtoInterface dto) throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmdSubHolidayRequestId());
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)dto.getRequestDate()));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)dto.getRequestDate()));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)dto.getRequestDate()));
        vo.setPltEditHolidayRange(String.valueOf(dto.getHolidayRange()));
        vo.setPltEditWorkDate(DateUtility.getStringDate((Date)dto.getWorkDate()) + "," + dto.getWorkDateSubHolidayType());
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected Boolean setEditPulldown() throws MospException {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("fixed")) {
            Date targetDate = this.getEditRequestDate();
            SubHolidayRequestDtoInterface dto = this.timeReference().subHolidayRequest().findForKey(vo.getRecordId());
            vo.setAryPltEditWorkDate(this.timeReference().subHoliday().getSelectArray(vo.getPersonalId(), targetDate, vo.getPltEditHolidayRange(), dto));
            if (vo.getAryPltEditWorkDate().length == 0) {
                vo.setAryPltEditWorkDate(this.getInputActivateNoDataLeavePulldown());
                this.mospParams.addErrorMessage("TMW0261", new String[]{this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"}), this.mospParams.getName("Target", new String[]{"GoingWork", "Day"})});
                return false;
            }
            if (!this.setApproverPullDown(vo.getPersonalId(), DateUtility.getDate((String)vo.getPltEditRequestYear(), (String)vo.getPltEditRequestMonth(), (String)vo.getPltEditRequestDay()), 1)) {
                vo.setAryPltEditWorkDate(this.getInputActivateNoDataLeavePulldown());
                return false;
            }
            this.getDifferenceRequest1(vo.getPersonalId(), targetDate);
            return true;
        }
        vo.setAryPltEditWorkDate(this.getInputActivateDateCompensatoryLeavePulldown());
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        return false;
    }

    protected String[][] getInputActivateDateCompensatoryLeavePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getProperties().getName("InputCompensatoryLeave")}};
        return aryPulldown;
    }

    protected String[][] getInputActivateNoDataLeavePulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getProperties().getName("InputActivateNoDataLeave")}};
        return aryPulldown;
    }

    protected Date getEditRequestDate() {
        SubHolidayRequestVo vo = (SubHolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditRequestYear(), vo.getPltEditRequestMonth(), vo.getPltEditRequestDay());
    }
}

