/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestSearchBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.comparator.settings.WorkOnHolidayRequestRequestDateComparator;
import jp.mosp.time.comparator.settings.WorkOnHolidayRequestSubstituteDate1Comparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.input.vo.WorkOnHolidayRequestVo;

public class WorkOnHolidayRequestAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1600";
    public static final String CMD_SELECT_SHOW = "TM1601";
    public static final String CMD_SEARCH = "TM1602";
    public static final String CMD_RE_SHOW = "TM1603";
    public static final String CMD_DRAFT = "TM1604";
    public static final String CMD_APPLI = "TM1605";
    public static final String CMD_WITHDRAWN = "TM1607";
    public static final String CMD_SORT = "TM1608";
    public static final String CMD_PAGE = "TM1609";
    public static final String CMD_BATCH_WITHDRAWN = "TM1636";
    public static final String CMD_SET_ACTIVATION_DATE = "TM1690";
    public static final String CMD_INSERT_MODE = "TM1691";
    public static final String CMD_EDIT_MODE = "TM1692";
    public static final String CMD_BATCH_UPDATE = "TM1695";
    public static final String CMD_TRANSFER = "TM1696";
    public static final String CMD_SET_TRANSFER_DAY = "TM1698";

    public WorkOnHolidayRequestAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new WorkOnHolidayRequestVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli();
        } else if (this.mospParams.getCommand().equals(CMD_WITHDRAWN)) {
            this.prepareVo();
            this.withdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_WITHDRAWN)) {
            this.prepareVo();
            this.batchWithdrawn();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
            this.getWorkPlanFlag();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TRANSFER_DAY)) {
            this.prepareVo();
            this.transferDay();
        }
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.getWorkPlanFlag();
        this.search();
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        this.setEmployeeInfo(personalId, targetDate);
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.insertMode();
        this.getWorkPlanFlag();
        this.search();
    }

    private void setPulldown() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        Date date = this.getTargetDate();
        if (date == null) {
            date = this.getSystemDate();
        }
        vo.setAryPltSearchSubstituteRange(this.mospParams.getProperties().getCodeArray("Substitute1Range", true));
        vo.setAryPltSearchState(this.mospParams.getProperties().getCodeArray("ApprovalState", true));
        vo.setAryPltSearchRequestYear(this.getYearArray(DateUtility.getYear((Date)date)));
        vo.setAryPltSearchRequestMonth(this.getMonthArray(true));
        vo.setAryPltEditSubstitute1Range(this.mospParams.getProperties().getCodeArray("Substitute1Range", false));
        vo.setAryPltEditStartHour(this.getHourArray());
        vo.setAryPltEditStartMinute(this.getMinuteArray(15));
        vo.setAryPltEditEndHour(this.getHourArray(48, true));
        vo.setAryPltEditEndMinute(this.getMinuteArray(15));
        this.setEditRequestPullDown(date);
        this.setEditSubstitutePullDown(date);
    }

    private void setEndHourPulldown() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        TimeSettingReferenceBeanInterface timeSetting = this.timeReference().timeSetting();
        vo.setAryPltEditEndHour(this.getHourArray(48, true));
        Date requestDate = this.getEditRequestDate();
        if (requestDate == null) {
            return;
        }
        ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), requestDate);
        application.chkExistApplication(applicationDto, requestDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = timeSetting.getTimeSettingInfo(applicationDto.getWorkSettingCode(), requestDate);
        timeSetting.chkExistTimeSetting(timeSettingDto, requestDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        vo.setAryPltEditEndHour(this.getHourArray(DateUtility.getHour((Date)timeSettingDto.getStartDayTime()) + 24, true));
    }

    protected void search() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestSearchBeanInterface search = this.timeReference().workOnHolidayRequestSearch();
        search.setPersonalId(vo.getPersonalId());
        search.setSubstitute(vo.getPltSearchSubstitute());
        search.setSubstituteRange("");
        search.setWorkflowStatus(vo.getPltSearchState());
        int year = Integer.parseInt(vo.getPltSearchRequestYear());
        int startMonth = 1;
        int endMonth = 12;
        if (!vo.getPltSearchRequestMonth().isEmpty()) {
            endMonth = startMonth = Integer.parseInt(vo.getPltSearchRequestMonth());
        }
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffDtoInterface startMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            this.addNoSearchResultMessage();
            return;
        }
        CutoffDtoInterface endMonthCutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), year, endMonth);
        String startMonthCutoffCode = startMonthCutoffDto == null ? null : startMonthCutoffDto.getCutoffCode();
        String endMonthCutoffCode = endMonthCutoffDto == null ? null : endMonthCutoffDto.getCutoffCode();
        Date firstDate = null;
        if (startMonthCutoffCode != null) {
            firstDate = cutoffUtil.getCutoffFirstDate(startMonthCutoffCode, year, startMonth);
        }
        Date lastDate = null;
        if (endMonthCutoffCode != null) {
            lastDate = cutoffUtil.getCutoffLastDate(endMonthCutoffCode, year, endMonth);
        }
        search.setRequestStartDate(firstDate);
        search.setRequestEndDate(lastDate);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(WorkOnHolidayRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.addNoSearchResultMessage();
        }
    }

    protected void draft() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestRegistBeanInterface regist = this.time().workOnHolidayRequestRegist();
        SubstituteRegistBeanInterface substituteRegist = this.time().substituteRegist();
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.setWorkOnHolidayDtoFields(dto);
        regist.validate(dto);
        regist.checkDraft(dto);
        boolean substituteFlag = Integer.toString(1).equals(vo.getPltEditSubstitute()) || Integer.toString(5).equals(vo.getPltEditSubstitute());
        SubstituteDtoInterface substituteDto = null;
        if (substituteFlag) {
            substituteDto = substituteRegist.getInitDto();
            this.setSubstituteDtoFields(substituteDto);
            substituteDto.setWorkflow(dto.getWorkflow());
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            substituteRegist.validate(substituteDto);
            substituteRegist.checkRegist(substituteDto);
        }
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("4");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("WorkPaper")}));
            dto.setWorkflow(workflowDto.getWorkflow());
            if (substituteFlag) {
                substituteDto.setWorkflow(workflowDto.getWorkflow());
            }
            regist.regist(dto);
            substituteRegist.delete(workflowDto.getWorkflow());
            if (substituteFlag) {
                substituteRegist.insert(substituteDto);
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addDraftMessage();
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        this.search();
        this.setEditUpdateMode(dto.getRequestDate());
        vo.setModeCardEdit("draft");
    }

    protected void appli() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestRegistBeanInterface regist = this.time().workOnHolidayRequestRegist();
        SubstituteRegistBeanInterface substituteRegist = this.time().substituteRegist();
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKey(vo.getRecordId());
        if (dto == null) {
            dto = regist.getInitDto();
        }
        SubstituteDtoInterface substituteDto = null;
        if (Integer.toString(1).equals(vo.getPltEditSubstitute()) || Integer.toString(5).equals(vo.getPltEditSubstitute())) {
            substituteDto = substituteRegist.getInitDto();
        }
        this.appli(dto, substituteDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.commit();
        this.addAppliMessage();
        if (vo.isModeHalfSubstitute()) {
            this.mospParams.addMessage("TMI0006", new String[0]);
        }
        if (!this.mospParams.hasErrorMessage()) {
            this.insertMode();
            Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
            vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
            vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
            this.search();
        }
    }

    protected void appli(WorkOnHolidayRequestDtoInterface dto, SubstituteDtoInterface substituteDto) throws MospException {
        boolean substituteFlag;
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestRegistBeanInterface regist = this.time().workOnHolidayRequestRegist();
        SubstituteRegistBeanInterface substituteRegist = this.time().substituteRegist();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        this.setWorkOnHolidayDtoFields(dto);
        regist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        boolean bl = substituteFlag = Integer.toString(1).equals(vo.getPltEditSubstitute()) || Integer.toString(5).equals(vo.getPltEditSubstitute());
        if (substituteFlag) {
            this.setSubstituteDtoFields(substituteDto);
            substituteDto.setWorkflow(dto.getWorkflow());
            substituteRegist.checkRegist(substituteDto);
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            this.time().attendanceRegist().delete(substituteDto.getPersonalId(), substituteDto.getSubstituteDate());
        }
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("4");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            dto.setWorkflow(workflowDto.getWorkflow());
            if (substituteFlag) {
                substituteDto.setWorkflow(workflowDto.getWorkflow());
            }
            regist.regist(dto);
            substituteRegist.delete(workflowDto.getWorkflow());
            if (substituteFlag) {
                substituteRegist.insert(substituteDto);
                attendanceTransactionRegist.regist(substituteDto);
            }
        }
    }

    protected void withdrawn() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestRegistBeanInterface regist = this.time().workOnHolidayRequestRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowCommentRegistBeanInterface workflowCommentRegist = this.platform().workflowCommentRegist();
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKey(vo.getRecordId());
        this.checkSelectedDataExist((Object)dto);
        regist.checkWithdrawn(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        boolean isDraft = "0".equals(workflowDto.getWorkflowStatus());
        if (isDraft) {
            long workflow = workflowDto.getWorkflow();
            workflowRegist.delete(workflowDto);
            workflowCommentRegist.deleteList(this.reference().workflowComment().getWorkflowCommentList(workflow));
            regist.delete(dto);
            this.time().substituteRegist().delete(workflow);
        } else {
            if ((workflowDto = workflowRegist.withdrawn(workflowDto)) != null) {
                workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
            }
            this.time().attendanceRegist().delete(dto.getPersonalId(), dto.getRequestDate());
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        if (isDraft) {
            this.addDeleteMessage();
        } else {
            this.addTakeDownMessage();
        }
        this.insertMode();
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(dto.getPersonalId(), dto.getRequestDate());
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchWithdrawn() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        this.time().workOnHolidayRequestRegist().withdrawn(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addTakeDownMessage();
        String searchYear = vo.getPltSearchRequestYear();
        String searchMonth = vo.getPltSearchRequestMonth();
        this.insertMode();
        this.setSearchRequestDate(searchYear, searchMonth);
        this.search();
    }

    protected void setActivationDate() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestRegistBeanInterface regist = this.time().workOnHolidayRequestRegist();
        if (vo.getModeActivateDate().equals("chaning")) {
            if (!this.setApproverPullDown(vo.getPersonalId(), this.getEditRequestDate(), 1)) {
                return;
            }
            WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKey(vo.getRecordId());
            if (dto == null) {
                dto = regist.getInitDto();
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setRequestDate(this.getEditRequestDate());
            dto.setWorkOnHolidayType(this.getScheduledWorkTypeCode());
            if (Integer.toString(1).equals(vo.getPltEditSubstitute())) {
                String editWorkRange = vo.getPltEditSubstituteWorkRange();
                if (editWorkRange != null && !editWorkRange.isEmpty() && (Integer.toString(3).equals(editWorkRange) || Integer.toString(4).equals(editWorkRange))) {
                    dto.setSubstitute(this.getInt(editWorkRange));
                }
            } else if (Integer.toString(2).equals(vo.getPltEditSubstitute())) {
                vo.setPltEditSubstituteWorkRange("1");
            }
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            regist.checkSetRequestDate(dto);
            if (this.mospParams.hasErrorMessage()) {
                this.addFixFailedMessage();
                return;
            }
            this.setWorkTypePulldown();
            vo.setModeActivateDate("fixed");
            this.transferDay();
        } else {
            String[] aryPltLblApproverSetting = new String[]{};
            vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
            vo.setModeActivateDate("chaning");
        }
        this.setEndHourPulldown();
    }

    protected void insertMode() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        vo.setModeHalfSubstitute(this.timeReference().workOnHolidayRequest().useHalfSubstitute());
        this.setDefaultValues();
        vo.setModeCardEdit("new");
        vo.setModeActivateDate("chaning");
        vo.setJsModeWorkPlanFlag("2");
        vo.setComparatorName(WorkOnHolidayRequestSubstituteDate1Comparator.class.getName());
        this.setPulldown();
        this.setWorkTypePulldown();
        if (null != this.getEditRequestDate()) {
            this.timeReference().workOnHolidayRequest().chkBasicInfo(vo.getPersonalId(), this.getEditRequestDate());
        }
    }

    protected void editMode() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getSystemDate();
        if (personalId != null) {
            this.setEmployeeInfo(personalId, targetDate);
            this.setPageInfo(CMD_PAGE, this.getListLength());
            this.insertMode();
            this.getWorkPlanFlag();
            this.search();
        }
        this.setEditUpdateMode(this.getDate(this.getTransferredActivateDate()));
        vo.setModeActivateDate("chaning");
        this.setActivationDate();
    }

    protected void batchUpdate() throws MospException {
        this.update();
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.search();
    }

    protected void update() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        this.time().workOnHolidayRequestRegist().update(this.getIdArray(vo.getCkbSelect()));
    }

    protected void transfer() {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        this.mospParams.setNextCommand("TM1841");
    }

    protected void transferDay() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        this.getDifferenceRequest1(vo.getPersonalId(), this.getDate(vo.getPltEditSubstitute1Year(), vo.getPltEditSubstitute1Month(), vo.getPltEditSubstitute1Day()));
    }

    protected void setEditUpdateMode(Date requestDate) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), requestDate);
        this.checkSelectedDataExist((Object)dto);
        List list = this.timeReference().substitute().getSubstituteList(dto.getWorkflow());
        this.checkSelectedDataExist((Object)list);
        this.setVoFields(dto);
        this.setVoFields(list);
        this.setEditRequestPullDown(dto.getRequestDate());
        this.setEditSubstitutePullDown(dto.getRequestDate());
        this.setVoFields(dto);
        this.setVoFields(list);
        this.getWorkPlanFlag();
    }

    public void setDefaultValues() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setRecordId(0L);
        vo.setPltEditRequestYear("");
        vo.setPltEditRequestMonth("");
        vo.setPltEditRequestDay("");
        vo.setPltEditSubstitute("");
        vo.setPltEditStartHour("");
        vo.setPltEditStartMinute("");
        vo.setPltEditEndHour("");
        vo.setPltEditEndMinute("");
        vo.setPltEditSubstitute1Year("");
        vo.setPltEditSubstitute1Month("");
        vo.setPltEditSubstitute1Day("");
        vo.setPltEditSubstitute1Range(Integer.toString(1));
        vo.setTxtEditRequestReason("");
        vo.setPltEditStartHour("0");
        vo.setPltEditStartMinute("0");
        vo.setPltEditEndHour("0");
        vo.setPltEditEndMinute("0");
        vo.setJsModeLegalHoliday("off");
        vo.setPltSearchSubstitute("");
        vo.setPltSearchSubstituteRange("");
        vo.setPltSearchState("");
        Date searchDate = this.timeReference().cutoffUtil().getCutoffMonth(vo.getPersonalId(), date);
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)searchDate));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)searchDate));
        String[] aryPltLblApproverSetting = new String[]{};
        vo.setAryPltLblApproverSetting(aryPltLblApproverSetting);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
    }

    protected void setSearchRequestDate(String year, String month) {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        vo.setPltSearchRequestYear(year);
        vo.setPltSearchRequestMonth(month);
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryLblRequestTime = new String[list.size()];
        String[] aryLblRequestReason = new String[list.size()];
        String[] aryLblSubstituteDate = new String[list.size()];
        String[] aryLblWorkflowStatus = new String[list.size()];
        String[] aryStatusStyle = new String[list.size()];
        String[] aryLblApproverName = new String[list.size()];
        String[] aryLblOnOff = new String[list.size()];
        String[] aryWorkflowStatus = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkOnHolidayRequestListDtoInterface dto = (WorkOnHolidayRequestListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmdWorkOnHolidayRequestId());
            aryLblRequestDate[i] = this.getStringDateAndDay(dto.getRequestDate());
            aryLblRequestTime[i] = this.getScheduleForList(dto);
            aryLblRequestReason[i] = dto.getRequestReason();
            StringBuffer substitute = new StringBuffer();
            substitute.append(this.getStringDateAndDay(dto.getSubstituteDate()));
            aryLblSubstituteDate[i] = substitute.toString() + " " + this.getRangeName(dto.getSubstituteRange());
            aryLblWorkflowStatus[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStatusStyle[i] = this.getStatusColor(dto.getState());
            aryLblOnOff[i] = this.getButtonOnOff(dto.getState(), dto.getStage());
            aryLblApproverName[i] = dto.getApproverName();
            aryWorkflowStatus[i] = dto.getState();
            aryWorkflow[i] = dto.getWorkflow();
        }
        vo.setAryCkbWorkOnHolidayRequestListId(aryCkbRecordId);
        vo.setAryLblWorkDate(aryLblRequestDate);
        vo.setAryLblRequestTime(aryLblRequestTime);
        vo.setAryLblRequestReason(aryLblRequestReason);
        vo.setAryLblSubstituteDate1(aryLblSubstituteDate);
        vo.setAryLblState(aryLblWorkflowStatus);
        vo.setAryStateStyle(aryStatusStyle);
        vo.setAryLblApprover(aryLblApproverName);
        vo.setAryLblOnOff(aryLblOnOff);
        vo.setAryWorkflowStatus(aryWorkflowStatus);
        vo.setAryWorkflow(aryWorkflow);
    }

    protected String getScheduleForList(WorkOnHolidayRequestListDtoInterface dto) throws MospException {
        WorkTypeDtoInterface workTypeDto;
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        ScheduleDateReferenceBeanInterface scheduleDate = this.timeReference().scheduleDate();
        WorkTypeReferenceBeanInterface workType = this.timeReference().workType();
        SubstituteReferenceBeanInterface substitute = this.timeReference().substitute();
        if (dto.getRequestDate() != null && dto.getStartTime() != null && dto.getEndTime() != null) {
            return this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestDate());
        }
        String scheduleValue = "";
        String workTypeCode = dto.getWorkTypeCode();
        Date targetDate = dto.getRequestDate();
        if (workTypeCode.isEmpty()) {
            List list = substitute.getSubstituteList(dto.getWorkflow());
            if (list.isEmpty()) {
                return scheduleValue;
            }
            targetDate = ((SubstituteDtoInterface)list.get(0)).getSubstituteDate();
            ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), targetDate);
            if (applicationDto == null) {
                return scheduleValue;
            }
            ScheduleDtoInterface scheduleDto = schedule.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
            if (scheduleDto == null) {
                return scheduleValue;
            }
            ScheduleDateDtoInterface scheduleDateDto = scheduleDate.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
            if (scheduleDateDto == null) {
                return scheduleValue;
            }
            workTypeCode = scheduleDateDto.getWorkTypeCode();
        }
        if ((workTypeDto = workType.findForInfo(workTypeCode, targetDate)) == null) {
            return scheduleValue;
        }
        scheduleValue = workTypeDto.getWorkTypeAbbr();
        String range = this.getSubstituteName(dto.getSubstitute());
        return scheduleValue + " " + range;
    }

    protected void setWorkOnHolidayDtoFields(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        Date requestDate = this.getEditRequestDate();
        String workTypeCode = this.getScheduledWorkTypeCode();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int substitute = Integer.parseInt(vo.getPltEditSubstitute());
        dto.setTmdWorkOnHolidayRequestId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRequestDate(requestDate);
        dto.setTimesWork(1);
        dto.setWorkOnHolidayType(workTypeCode);
        dto.setRequestReason(vo.getTxtEditRequestReason());
        dto.setSubstitute(substitute);
        dto.setWorkTypeCode("");
        if (Integer.toString(5).equals(vo.getPltEditSubstitute())) {
            dto.setWorkTypeCode(vo.getPltEditWorkType());
        }
        dto.setStartTime(null);
        dto.setEndTime(null);
        if (substitute == 1) {
            if (vo.getPltEditSubstituteWorkRange() == null || vo.getPltEditSubstituteWorkRange().isEmpty()) {
                return;
            }
            if (Integer.toString(3).equals(vo.getPltEditSubstituteWorkRange()) || Integer.toString(4).equals(vo.getPltEditSubstituteWorkRange())) {
                dto.setSubstitute(this.getInt(vo.getPltEditSubstituteWorkRange()));
            }
        } else if (substitute == 2) {
            int year = Integer.parseInt(vo.getPltEditRequestYear());
            int month = Integer.parseInt(vo.getPltEditRequestMonth());
            int day = Integer.parseInt(vo.getPltEditRequestDay());
            int startHour = Integer.parseInt(vo.getPltEditStartHour());
            int startMinute = Integer.parseInt(vo.getPltEditStartMinute());
            int endHour = Integer.parseInt(vo.getPltEditEndHour());
            int endMinute = Integer.parseInt(vo.getPltEditEndMinute());
            dto.setStartTime(DateUtility.getDateTime((int)year, (int)month, (int)day, (int)startHour, (int)startMinute));
            long endTime = requestDate.getTime();
            endTime += (long)endHour * 3600000L;
            dto.setEndTime(new Date(endTime += (long)(endMinute * 3600000 / 60)));
        }
    }

    protected void setSubstituteDtoFields(SubstituteDtoInterface dto) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        String workTypeCode = this.getScheduledWorkTypeCode();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPersonalId(vo.getPersonalId());
        dto.setSubstituteDate(DateUtility.getDate((String)vo.getPltEditSubstitute1Year(), (String)vo.getPltEditSubstitute1Month(), (String)vo.getPltEditSubstitute1Day()));
        dto.setSubstituteType(workTypeCode);
        dto.setSubstituteRange(1);
        if (this.getInt(vo.getPltEditSubstitute()) == 1 && (Integer.toString(3).equals(vo.getPltEditSubstituteWorkRange()) || Integer.toString(4).equals(vo.getPltEditSubstituteWorkRange()))) {
            dto.setSubstituteRange(this.getInt(vo.getPltEditSubstitute1Range()));
        }
        dto.setWorkDate(this.getEditRequestDate());
        dto.setTimesWork(1);
    }

    protected Date getEditRequestDate() {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        return this.getDate(vo.getPltEditRequestYear(), vo.getPltEditRequestMonth(), vo.getPltEditRequestDay());
    }

    protected void setEditRequestPullDown(Date date) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        int year = DateUtility.getYear((Date)date);
        vo.setAryPltEditRequestYear(this.getYearArray(year));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setAryPltEditRequestDay(this.getDayArray());
        vo.setPltEditRequestYear(String.valueOf(year));
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)date));
        vo.setPltEditRequestDay(DateUtility.getStringDayD((Date)date));
    }

    protected void setEditSubstitutePullDown(Date date) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        int year = DateUtility.getYear((Date)date);
        vo.setAryPltEditSubstitute1Year(this.getYearArray(year));
        vo.setAryPltEditSubstitute1Month(this.getMonthArray());
        vo.setAryPltEditSubstitute1Day(this.getDayArray());
        vo.setPltEditSubstitute1Year(String.valueOf(year));
        vo.setPltEditSubstitute1Month(DateUtility.getStringMonthM((Date)date));
        vo.setPltEditSubstitute1Day(DateUtility.getStringDayD((Date)date));
    }

    protected void setWorkTypePulldown() throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        Date requestDate = this.getEditRequestDate();
        ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), requestDate);
        if (applicationDto == null) {
            vo.setAryPltEditWorkType(new String[0][0]);
            return;
        }
        ScheduleDtoInterface scheduleDto = schedule.getScheduleInfo(applicationDto.getScheduleCode(), requestDate);
        if (scheduleDto == null) {
            vo.setAryPltEditWorkType(new String[0][0]);
            return;
        }
        vo.setAryPltEditWorkType(this.getWorkTypeArray(scheduleDto.getPatternCode(), requestDate, true, true, false, false));
    }

    protected void setVoFields(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        int substitute = dto.getSubstitute();
        vo.setRecordId(dto.getTmdWorkOnHolidayRequestId());
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)dto.getRequestDate()));
        vo.setPltEditRequestMonth(String.valueOf(DateUtility.getMonth((Date)dto.getRequestDate())));
        vo.setPltEditRequestDay(String.valueOf(DateUtility.getDay((Date)dto.getRequestDate())));
        vo.setTxtEditRequestReason(dto.getRequestReason());
        vo.setPltEditSubstitute(String.valueOf(substitute));
        vo.setPltEditSubstituteWorkRange(String.valueOf(1));
        vo.setPltEditWorkType("");
        if (!dto.getWorkTypeCode().isEmpty()) {
            vo.setPltEditWorkType(dto.getWorkTypeCode());
        }
        vo.setPltEditStartHour("");
        vo.setPltEditStartMinute("");
        vo.setPltEditEndHour("");
        vo.setPltEditEndMinute("");
        if (substitute == 2) {
            vo.setPltEditStartHour(String.valueOf(DateUtility.getHour((Date)dto.getStartTime())));
            vo.setPltEditStartMinute(String.valueOf(DateUtility.getMinute((Date)dto.getStartTime())));
            vo.setPltEditEndHour(String.valueOf(DateUtility.getHour((Date)dto.getEndTime(), (Date)dto.getRequestDate())));
            vo.setPltEditEndMinute(String.valueOf(DateUtility.getMinute((Date)dto.getEndTime())));
        } else if (substitute == 3) {
            vo.setPltEditSubstitute(String.valueOf(1));
            vo.setPltEditSubstituteWorkRange(String.valueOf(3));
        } else if (substitute == 4) {
            vo.setPltEditSubstitute(String.valueOf(1));
            vo.setPltEditSubstituteWorkRange(String.valueOf(4));
        }
        vo.setModeCardEdit(this.getApplicationMode(dto.getWorkflow()));
    }

    protected void setVoFields(List<SubstituteDtoInterface> list) {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        int i = 0;
        for (SubstituteDtoInterface dto : list) {
            Date substituteDate = dto.getSubstituteDate();
            int substituteRange = dto.getSubstituteRange();
            if (i == 0) {
                vo.setPltEditSubstitute1Year(DateUtility.getStringYear((Date)substituteDate));
                vo.setPltEditSubstitute1Month(DateUtility.getStringMonthM((Date)substituteDate));
                vo.setPltEditSubstitute1Day(DateUtility.getStringDayD((Date)substituteDate));
                vo.setPltEditSubstitute1Range(String.valueOf(substituteRange));
            }
            ++i;
        }
    }

    protected String getScheduledWorkTypeCode() throws MospException {
        return this.getScheduleWorkTypeCode(this.getEditRequestDate());
    }

    private String getScheduleWorkTypeCode(Date workeDate) throws MospException {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        ApplicationReferenceBeanInterface application = this.timeReference().application();
        ScheduleReferenceBeanInterface schedule = this.timeReference().schedule();
        ScheduleDateReferenceBeanInterface scheduleDate = this.timeReference().scheduleDate();
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(vo.getPersonalId(), workeDate);
        List list = requestUtil.getSubstituteList(true);
        Iterator i$ = list.iterator();
        if (i$.hasNext()) {
            SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)i$.next();
            return substituteDto.getSubstituteType();
        }
        ApplicationDtoInterface applicationDto = application.findForPerson(vo.getPersonalId(), workeDate);
        application.chkExistApplication(applicationDto, workeDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        ScheduleDtoInterface scheduleDto = schedule.getScheduleInfo(applicationDto.getScheduleCode(), workeDate);
        schedule.chkExistSchedule(scheduleDto, workeDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        ScheduleDateDtoInterface scheduleDateDto = scheduleDate.findForKey(scheduleDto.getScheduleCode(), workeDate);
        scheduleDate.chkExistScheduleDate(scheduleDateDto, workeDate);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        return scheduleDateDto.getWorkTypeCode();
    }

    protected void getWorkPlanFlag() {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        if (vo.getPltEditSubstitute().equals(String.valueOf(1))) {
            vo.setJsModeWorkPlanFlag("1");
        } else if (vo.getPltEditSubstitute().equals(String.valueOf(2))) {
            vo.setJsModeWorkPlanFlag("2");
        } else {
            vo.setJsModeWorkPlanFlag("");
        }
    }

    protected String getRangeName(int code) {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        if (!vo.isModeHalfSubstitute()) {
            return "";
        }
        if (code == 1) {
            return this.getCodeName(code, "SubstituteWorkRange");
        }
        if (code == 2 || code == 3) {
            return this.getCodeName(code, "SubstituteHolidayRange");
        }
        return "";
    }

    protected String getSubstituteName(int code) {
        WorkOnHolidayRequestVo vo = (WorkOnHolidayRequestVo)this.mospParams.getVo();
        if (!vo.isModeHalfSubstitute()) {
            return "";
        }
        if (code == 1 || code == 3 || code == 4) {
            return this.getCodeName(code, "SubstituteWorkRange");
        }
        if (code == 5) {
            return this.getCodeName(1, "SubstituteWorkRange");
        }
        return "";
    }

    protected void addRequestDayNoGoingWorkDayErrorMessage() {
        this.mospParams.addErrorMessage("PFW0227", new String[]{this.mospParams.getName("Approver"), this.mospParams.getName("Application", new String[]{"Day"})});
    }

    protected String getNameWorkDate() {
        return this.mospParams.getName("Work", new String[]{"Day"});
    }
}

