/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.workflow.SubApproverDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.management.vo.ApprovalCardVo;

public class ApprovalCardAction
extends TimeAction {
    public static final String CMD_APPROVAL_CONFIRMATION_ATTENDANCE = "TM2320";
    public static final String CMD_APPROVAL_CONFIRMATION_OVERTIME = "TM2330";
    public static final String CMD_APPROVAL_CONFIRMATION_HOLIDAY = "TM2340";
    public static final String CMD_APPROVAL_CONFIRMATION_WORKONHOLIDAY = "TM2350";
    public static final String CMD_APPROVAL_CONFIRMATION_SUBHOLIDAY = "TM2360";
    public static final String CMD_APPROVAL_CONFIRMATION_DIFFERENCE = "TM2370";
    public static final String CMD_APPROVAL_CONFIRMATION_WORKTYPECHANGE = "TM2380";
    public static final String CMD_APPROVAL_ATTENDANCE = "TM2321";
    public static final String CMD_APPROVAL_OVERTIME = "TM2331";
    public static final String CMD_APPROVAL_HOLIDAY = "TM2341";
    public static final String CMD_APPROVAL_WORKONHOLIDAY = "TM2351";
    public static final String CMD_APPROVAL_SUBHOLIDAY = "TM2361";
    public static final String CMD_APPROVAL_DIFFERENCE = "TM2371";
    public static final String CMD_APPROVAL_WORKTYPECHANGE = "TM2381";
    public static final String CMD_ROLL = "TM2322";
    public static final String CMD_APPROVAL = "TM2325";
    public static final String CMD_REVERTING = "TM2326";
    public static final String CMD_DELETE = "TM2327";
    public static final String SEPARATOR = " ";
    public static final String PRM_APPROVAL_EXTRA_JSP = "prmApprovalExtraJsp";

    protected BaseVo getSpecificVo() {
        return new ApprovalCardVo();
    }

    public void action() throws MospException {
        this.setApprovalExtraJsp();
        if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_ATTENDANCE)) {
            this.prepareVo(false, false);
            this.approvalAttendance(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_OVERTIME)) {
            this.prepareVo(false, false);
            this.approvalOvertime(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_HOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalHoliday(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_WORKONHOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalWorkOnHoliday(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_SUBHOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalSubHoliday(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_DIFFERENCE)) {
            this.prepareVo(false, false);
            this.approvalDifference(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_CONFIRMATION_WORKTYPECHANGE)) {
            this.prepareVo(false, false);
            this.approvalWorkTypeChange(true);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_ATTENDANCE)) {
            this.prepareVo(false, false);
            this.approvalAttendance(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_OVERTIME)) {
            this.prepareVo(false, false);
            this.approvalOvertime(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_HOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalHoliday(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_WORKONHOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalWorkOnHoliday(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_SUBHOLIDAY)) {
            this.prepareVo(false, false);
            this.approvalSubHoliday(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_DIFFERENCE)) {
            this.prepareVo(false, false);
            this.approvalDifference(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL_WORKTYPECHANGE)) {
            this.prepareVo(false, false);
            this.approvalWorkTypeChange(false);
        } else if (this.mospParams.getCommand().equals(CMD_APPROVAL)) {
            this.prepareVo();
            this.approval();
        } else if (this.mospParams.getCommand().equals(CMD_REVERTING)) {
            this.prepareVo();
            this.reverting();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.cancel();
        } else if (this.mospParams.getCommand().equals(CMD_ROLL)) {
            this.prepareVo();
            this.roll();
        }
    }

    protected void setApprovalExtraJsp() {
    }

    protected void approvalAttendance(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setAttendance(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalOvertime(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setOvertime(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalHoliday(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setHoliday(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalWorkOnHoliday(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setWorkOnHoliday(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalSubHoliday(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setSubHoliday(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalDifference(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setDifference(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approvalWorkTypeChange(boolean isConfirmation) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setConfirmation(isConfirmation);
        vo.setWorkTypeChange(true);
        this.setInitValues();
        this.setRequestValues();
    }

    protected void approval() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        this.time().timeApproval().approve(vo.getWorkflow().longValue(), this.getWorkflowComment());
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addApprovalMessage();
        this.setRequestValues();
    }

    protected void reverting() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        TimeApprovalBeanInterface timeApproval = this.time().timeApproval();
        WorkflowDtoInterface workflowdto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow().longValue());
        boolean isCancelApprovable = WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowdto);
        boolean isCancelWithDrawn = WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowdto);
        if (isCancelApprovable || isCancelWithDrawn) {
            timeApproval.cancelRevert(vo.getWorkflow().longValue(), vo.getTxtCancelComment());
        } else {
            timeApproval.revert(vo.getWorkflow().longValue(), this.getWorkflowComment());
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        if (isCancelApprovable) {
            this.addReleaseSendingBackMessage();
        } else {
            this.addSendingBackMessage();
        }
        this.setRequestValues();
    }

    protected void cancel() throws MospException {
        WorkflowDtoInterface dto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        TimeApprovalBeanInterface timeApproval = this.time().timeApproval();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        if (workflowIntegrate.isCompleted(dto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow().longValue()))) {
            timeApproval.cancel(vo.getWorkflow().longValue(), null);
        } else if (workflowIntegrate.isCancelApprovable(dto) || workflowIntegrate.isCancelWithDrawnApprovable(dto)) {
            timeApproval.cancelApprove(vo.getWorkflow().longValue(), vo.getTxtCancelComment());
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.mospParams.addMessage("PFI0001", new String[]{this.mospParams.getName("Approval", new String[]{"Release"})});
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow().longValue());
        if (workflowDto == null) {
            if (vo.isConfirmation()) {
                this.mospParams.setNextCommand("TM2203");
                return;
            }
            this.mospParams.setNextCommand("TM2313");
            return;
        }
        this.setRequestValues();
    }

    protected void roll() {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        long workflow = 0L;
        String command = "";
        String searchMode = this.mospParams.getRequestParam("transferSearch");
        if ("searchBack".equals(searchMode)) {
            workflow = vo.getPrevWorkflow();
            command = vo.getPrevCommand();
        } else if ("searchNext".equals(searchMode)) {
            workflow = vo.getNextWorkflow();
            command = vo.getNextCommand();
        }
        this.mospParams.addGeneralParam("RollArray", (Object)vo.getRollArray());
        this.setTargetWorkflow(workflow);
        this.mospParams.setNextCommand(command);
    }

    protected void setRequestValues() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        long workflow = vo.getWorkflow();
        if (vo.isAttendance()) {
            this.setAttendanceValues();
            this.setOtherRequestValues();
        } else if (vo.isOvertime()) {
            this.setOvertimeValues(this.timeReference().overtimeRequest().findForWorkflow(workflow));
        } else if (vo.isHoliday()) {
            this.setHolidayValues(this.timeReference().holidayRequest().findForWorkflow(workflow));
        } else if (vo.isWorkOnHoliday()) {
            this.setWorkOnHolidayValues(this.timeReference().workOnHolidayRequest().findForWorkflow(workflow));
        } else if (vo.isSubHoliday()) {
            this.setSubHolidayValues(this.timeReference().subHolidayRequest().findForWorkflow(workflow));
        } else if (vo.isDifference()) {
            this.setDifferenceValues(this.timeReference().differenceRequest().findForWorkflow(workflow));
        } else if (vo.isWorkTypeChange()) {
            this.setWorkTypeChangeValues(this.timeReference().workTypeChangeRequest().findForWorkflow(workflow));
        }
        this.setButtonFlag();
    }

    public void setInitValues() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        if (vo.isConfirmation()) {
            TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)this.getNameRequestCard());
        }
        long workflow = this.getTargetWorkflow();
        vo.setWorkflow(Long.valueOf(workflow));
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        this.checkSelectedDataExist((Object)workflowDto);
        String personalId = workflowDto.getPersonalId();
        Date targetDate = workflowDto.getWorkflowDate();
        this.setEmployeeInfo(personalId, targetDate);
        vo.setLblYear(DateUtility.getStringYear((Date)targetDate));
        vo.setLblMonth(DateUtility.getStringMonth((Date)targetDate));
        vo.setLblDay(DateUtility.getStringDay((Date)targetDate));
        this.setRollWorkflow();
    }

    protected void setAttendanceValues() throws MospException {
        WorkflowCommentDtoInterface commentDto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        long workflow = vo.getWorkflow();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        AttendanceDtoInterface dto = this.timeReference().attendance().findForWorkflow(workflow);
        if (dto == null || workflowDto == null) {
            return;
        }
        StringBuffer lblStartTime = new StringBuffer();
        lblStartTime.append(this.getStringTimeMinutes(dto.getStartTime()));
        TimeRecordDtoInterface recodeStartDto = this.timeReference().timeRecord().findForKey(personalId, targetDate, 1, "StartWork");
        if (recodeStartDto != null) {
            lblStartTime.append(this.mospParams.getName("FrontWithCornerParentheses"));
            lblStartTime.append(DateUtility.getStringTimeAndSecond((Date)recodeStartDto.getRecordTime(), (Date)dto.getWorkDate()));
            lblStartTime.append(this.mospParams.getName("BackWithCornerParentheses"));
        }
        StringBuffer lblEndTime = new StringBuffer();
        lblEndTime.append(DateUtility.getStringHour((Date)dto.getEndTime(), (Date)dto.getWorkDate()));
        lblEndTime.append(this.mospParams.getName("Hour"));
        lblEndTime.append(this.getStringMinute(dto.getEndTime()));
        lblEndTime.append(this.mospParams.getName("Minutes"));
        TimeRecordDtoInterface recodeEndDto = this.timeReference().timeRecord().findForKey(personalId, targetDate, 1, "EndWork");
        if (recodeEndDto != null) {
            lblEndTime.append(this.mospParams.getName("FrontWithCornerParentheses"));
            lblEndTime.append(DateUtility.getStringTimeAndSecond((Date)recodeEndDto.getRecordTime(), (Date)dto.getWorkDate()));
            lblEndTime.append(this.mospParams.getName("BackWithCornerParentheses"));
        }
        vo.setLblStartTime(lblStartTime.toString());
        vo.setLblEndTime(lblEndTime.toString());
        vo.setLblWorkTime(this.getTimeTimeFormat(dto.getWorkTime()));
        vo.setLblWorkType(this.getWorkTypeAbbrStartTimeEndTime(dto));
        String directWorkManage = "";
        if (dto.getDirectStart() == 1) {
            directWorkManage = this.mospParams.getName("DirectStart") + SEPARATOR;
        }
        if (dto.getDirectEnd() == 1) {
            directWorkManage = directWorkManage + this.mospParams.getName("DirectEnd");
        }
        vo.setLblDirectWorkManage(directWorkManage);
        String checkWorkStart = "";
        if (dto.getForgotRecordWorkStart() == 1) {
            checkWorkStart = this.mospParams.getName("ForgotRecordWorkStart") + SEPARATOR;
        }
        if (dto.getNotRecordWorkStart() == 1) {
            checkWorkStart = checkWorkStart + this.mospParams.getName("Others");
        }
        vo.setLblCheckWorkStart(checkWorkStart);
        vo.setLblRemarks(dto.getRemarks());
        vo.setLblUnpaidShortTime(this.getTimeTimeFormat(dto.getShortUnpaid()));
        vo.setLblTimeComment(dto.getTimeComment());
        vo.setLblRestTime(this.getTimeTimeFormat(dto.getRestTime()));
        vo.setLblNightRestTime(this.getTimeTimeFormat(dto.getNightRestTime()));
        vo.setLblPublicTime(this.getTimeTimeFormat(dto.getPublicTime()));
        vo.setLblPrivateTime(this.getTimeTimeFormat(dto.getPrivateTime()));
        vo.setLblLateTime(this.getTimeTimeFormat(dto.getLateTime()));
        vo.setLblLateReason(this.getCodeName(dto.getLateReason(), "ReasonOfLate"));
        vo.setLblLateCertificate(this.getCodeName(dto.getLateCertificate(), "Allowance"));
        vo.setLblLateComment(dto.getLateComment());
        vo.setLblLeaveEarlyTime(this.getTimeTimeFormat(dto.getLeaveEarlyTime()));
        vo.setLblLeaveEarlyReason(this.getCodeName(dto.getLeaveEarlyReason(), "ReasonOfLeaveEarly"));
        vo.setLblLeaveEarlyCertificate(this.getCodeName(dto.getLeaveEarlyCertificate(), "Allowance"));
        vo.setLblLeaveEarlyComment(dto.getLeaveEarlyComment());
        vo.setLblOvertime("");
        vo.setLblOverTimeIn(this.getTimeTimeFormat(dto.getOvertime()));
        vo.setLblOverTimeOut(this.getTimeTimeFormat(dto.getOvertimeOut()));
        vo.setLblLateNightTime(this.getTimeTimeFormat(dto.getLateNightTime()));
        vo.setLblSpecificWorkTimeIn(this.getTimeTimeFormat(dto.getSpecificWorkTime()));
        vo.setLblLegalWorkTime(this.getTimeTimeFormat(dto.getLegalWorkTime()));
        vo.setLblHolidayWorkTime(this.getTimeTimeFormat(dto.getSpecificWorkTime() + dto.getLegalWorkTime()));
        vo.setLblDecreaseTime(this.getTimeTimeFormat(dto.getDecreaseTime()));
        List restList = this.timeReference().rest().getRestList(personalId, targetDate, 1);
        for (RestDtoInterface restDto : restList) {
            switch (restDto.getRest()) {
                case 1: {
                    vo.setLblRestTime1(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
                case 2: {
                    vo.setLblRestTime2(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
                case 3: {
                    vo.setLblRestTime3(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
                case 4: {
                    vo.setLblRestTime4(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
                case 5: {
                    vo.setLblRestTime5(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
                case 6: {
                    vo.setLblRestTime6(this.getTimeWaveFormat(restDto.getRestStart(), restDto.getRestEnd(), restDto.getWorkDate()));
                    break;
                }
            }
        }
        List goOutList = this.timeReference().goOut().getPublicGoOutList(personalId, targetDate);
        for (GoOutDtoInterface goOutDto : goOutList) {
            switch (goOutDto.getTimesGoOut()) {
                case 1: {
                    vo.setLblPublicTime1(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 2: {
                    vo.setLblPublicTime2(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
            }
        }
        goOutList = this.timeReference().goOut().getPrivateGoOutList(personalId, targetDate);
        for (GoOutDtoInterface goOutDto : goOutList) {
            switch (goOutDto.getTimesGoOut()) {
                case 1: {
                    vo.setLblPrivateTime1(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 2: {
                    vo.setLblPrivateTime2(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
            }
        }
        String minutelyHolidayA = "";
        if (dto.getMinutelyHolidayA() == 1) {
            minutelyHolidayA = this.mospParams.getName("AllTime");
        }
        vo.setLblAllMinutelyHolidayA(minutelyHolidayA);
        vo.setLblMinutelyHolidayATime(this.getTimeTimeFormat(dto.getMinutelyHolidayATime()));
        goOutList = this.timeReference().goOut().getMinutelyHolidayAList(personalId, targetDate);
        for (GoOutDtoInterface goOutDto : goOutList) {
            switch (goOutDto.getTimesGoOut()) {
                case 1: {
                    vo.setLblMinutelyHolidayATime1(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 2: {
                    vo.setLblMinutelyHolidayATime2(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 3: {
                    vo.setLblMinutelyHolidayATime3(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 4: {
                    vo.setLblMinutelyHolidayATime4(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
            }
        }
        String minutelyHolidayB = "";
        if (dto.getMinutelyHolidayB() == 1) {
            minutelyHolidayB = this.mospParams.getName("AllTime");
        }
        vo.setLblAllMinutelyHolidayB(minutelyHolidayB);
        vo.setLblMinutelyHolidayBTime(this.getTimeTimeFormat(dto.getMinutelyHolidayBTime()));
        goOutList = this.timeReference().goOut().getMinutelyHolidayBList(personalId, targetDate);
        for (GoOutDtoInterface goOutDto : goOutList) {
            switch (goOutDto.getTimesGoOut()) {
                case 1: {
                    vo.setLblMinutelyHolidayBTime1(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 2: {
                    vo.setLblMinutelyHolidayBTime2(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 3: {
                    vo.setLblMinutelyHolidayBTime3(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
                case 4: {
                    vo.setLblMinutelyHolidayBTime4(this.getTimeWaveFormat(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), goOutDto.getWorkDate()));
                    break;
                }
            }
        }
        AttendanceCorrectionDtoInterface correctionDto = this.timeReference().attendanceCorrection().getLatestAttendanceCorrectionInfo(personalId, targetDate, 1);
        if (correctionDto != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Corrector"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(this.reference().human().getHumanName(correctionDto.getCorrectionPersonalId(), correctionDto.getCorrectionDate()));
            sb.append(SEPARATOR);
            sb.append(this.mospParams.getName("Day"));
            sb.append(this.mospParams.getName("Hour"));
            sb.append(this.mospParams.getName("Colon"));
            sb.append(DateUtility.getStringDateAndDayAndTime((Date)correctionDto.getCorrectionDate()));
            vo.setLblCorrectionHistory(sb.toString());
        }
        if ((commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow)) == null) {
            return;
        }
        String approver = this.getWorkflowOperator(commentDto);
        String state = this.geWorkflowtStatus(commentDto);
        vo.setLblAttendanceApprover(approver);
        vo.setLblAttendanceState(state);
        vo.setLblAttendanceComment(commentDto.getWorkflowComment());
        vo.setLblCancelApprover(approver);
        vo.setLblCancelState(state);
    }

    protected void setOtherRequestValues() throws MospException {
        DifferenceRequestDtoInterface differenceDto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(vo.getPersonalId(), vo.getTargetDate());
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        this.setOvertimeValues(requestUtil.getOverTimeList(true));
        this.setHolidayValues(requestUtil);
        WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.timeReference().workOnHolidayRequest().findForKeyOnWorkflow(personalId, targetDate);
        if (workOnHolidayDto != null && workflowIntegrate.isCompleted(workOnHolidayDto.getWorkflow())) {
            this.setWorkOnHolidayValues(workOnHolidayDto);
        }
        List subHolidayList = this.timeReference().subHolidayRequest().getSubHolidayRequestList(personalId, targetDate);
        for (SubHolidayRequestDtoInterface subHolidayDto : subHolidayList) {
            if (!workflowIntegrate.isCompleted(subHolidayDto.getWorkflow())) continue;
            this.setSubHolidayValues(subHolidayDto);
            break;
        }
        if ((differenceDto = this.timeReference().differenceRequest().findForKeyOnWorkflow(personalId, targetDate)) != null && workflowIntegrate.isCompleted(differenceDto.getWorkflow())) {
            this.setDifferenceValues(differenceDto);
        }
    }

    protected void setOvertimeValues(OvertimeRequestDtoInterface dto) throws MospException {
        ArrayList<OvertimeRequestDtoInterface> list = new ArrayList<OvertimeRequestDtoInterface>();
        list.add(dto);
        this.setOvertimeValues(list);
    }

    protected void setOvertimeValues(List<OvertimeRequestDtoInterface> list) throws MospException {
        WorkflowDtoInterface workflowDto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        AttendanceDtoInterface attendanceDto = this.timeReference().attendance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1);
        boolean isAttendanceApprovable = false;
        if (attendanceDto != null && (workflowDto = workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())) != null && (workflowIntegrate.isApprovable(workflowDto) || workflowIntegrate.isCompleted(workflowDto))) {
            isAttendanceApprovable = true;
        }
        String[] aryLblOvertimeType = new String[list.size()];
        String[] aryLblOvertimeSchedule = new String[list.size()];
        String[] aryLblOvertimeResult = new String[list.size()];
        String[] aryLblOvertimeReason = new String[list.size()];
        String[] aryLblOvertimeState = new String[list.size()];
        String[] aryLblOvertimeComment = new String[list.size()];
        String[] aryLblOvertimeApprover = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            OvertimeRequestDtoInterface dto = list.get(i);
            int overtimeType = dto.getOvertimeType();
            aryLblOvertimeType[i] = this.getOvertimeTypeName(overtimeType);
            aryLblOvertimeSchedule[i] = this.getTimeTimeFormat(dto.getRequestTime());
            aryLblOvertimeResult[i] = this.mospParams.getName("Hyphen");
            if (isAttendanceApprovable) {
                int result = 0;
                if (overtimeType == 1) {
                    result = attendanceDto.getOvertimeBefore();
                } else if (overtimeType == 2) {
                    result = attendanceDto.getOvertimeAfter();
                }
                aryLblOvertimeResult[i] = this.getTimeTimeFormat(result);
            }
            aryLblOvertimeReason[i] = dto.getRequestReason();
            WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow());
            if (commentDto == null) {
                aryLblOvertimeState[i] = "";
                aryLblOvertimeComment[i] = "";
                aryLblOvertimeApprover[i] = "";
                continue;
            }
            aryLblOvertimeState[i] = this.geWorkflowtStatus(commentDto);
            aryLblOvertimeComment[i] = commentDto.getWorkflowComment();
            aryLblOvertimeApprover[i] = this.getWorkflowOperator(commentDto);
        }
        vo.setLblOvertimeType(aryLblOvertimeType);
        vo.setLblOvertimeSchedule(aryLblOvertimeSchedule);
        vo.setLblOvertimeResult(aryLblOvertimeResult);
        vo.setLblOvertimeReason(aryLblOvertimeReason);
        vo.setLblOvertimeState(aryLblOvertimeState);
        vo.setLblOvertimeComment(aryLblOvertimeComment);
        vo.setLblOvertimeApprover(aryLblOvertimeApprover);
        if (vo.isOvertime()) {
            vo.setLblCancelState(aryLblOvertimeState[0]);
            vo.setLblCancelApprover(aryLblOvertimeApprover[0]);
        }
    }

    protected void setHolidayValues(HolidayRequestDtoInterface dto) throws MospException {
        ArrayList<HolidayRequestDtoInterface> list = new ArrayList<HolidayRequestDtoInterface>();
        list.add(dto);
        this.setHolidayValues(list);
    }

    protected void setHolidayValues(RequestUtilBeanInterface requestUtil) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null || workOnHolidayRequestDto.getSubstitute() == 1) {
            this.setHolidayValues(requestUtil.getHolidayList(true));
        }
    }

    protected void setHolidayValues(List<HolidayRequestDtoInterface> list) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        String[] aryLblHolidayDate = new String[list.size()];
        String[] aryLblHolidayType = new String[list.size()];
        String[] aryLblHolidayLength = new String[list.size()];
        String[] aryLblHolidayTime = new String[list.size()];
        String[] aryLblHolidayReason = new String[list.size()];
        String[] aryLblHolidayState = new String[list.size()];
        String[] aryLblHolidayApprover = new String[list.size()];
        String[] aryLblHolidayComment = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HolidayRequestDtoInterface dto = list.get(i);
            StringBuffer sb = new StringBuffer();
            sb.append(this.getStringDateAndDay(dto.getRequestStartDate()));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(this.getStringDateAndDay(dto.getRequestEndDate()));
            aryLblHolidayDate[i] = sb.toString();
            aryLblHolidayType[i] = this.getHolidayTypeName(dto.getHolidayType1(), dto.getHolidayType2(), dto.getRequestStartDate());
            aryLblHolidayLength[i] = this.getHolidayRange(dto.getHolidayRange());
            aryLblHolidayTime[i] = this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate());
            aryLblHolidayReason[i] = dto.getRequestReason();
            WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow());
            if (commentDto == null) {
                aryLblHolidayState[i] = "";
                aryLblHolidayApprover[i] = "";
                aryLblHolidayComment[i] = "";
                continue;
            }
            aryLblHolidayState[i] = this.geWorkflowtStatus(commentDto);
            aryLblHolidayApprover[i] = this.getWorkflowOperator(commentDto);
            aryLblHolidayComment[i] = commentDto.getWorkflowComment();
        }
        vo.setLblHolidayDate(aryLblHolidayDate);
        vo.setLblHolidayType(aryLblHolidayType);
        vo.setLblHolidayLength(aryLblHolidayLength);
        vo.setLblHolidayTime(aryLblHolidayTime);
        vo.setLblHolidayReason(aryLblHolidayReason);
        vo.setLblHolidayState(aryLblHolidayState);
        vo.setLblHolidayComment(aryLblHolidayComment);
        vo.setLblHolidayApprover(aryLblHolidayApprover);
        if (vo.isHoliday()) {
            vo.setLblCancelState(aryLblHolidayState[0]);
            vo.setLblCancelApprover(aryLblHolidayApprover[0]);
        }
    }

    protected void setWorkOnHolidayValues(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkflowCommentDtoInterface commentDto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        long workflow = dto.getWorkflow();
        String workRange = "";
        int substitute = dto.getSubstitute();
        if (substitute == 3) {
            workRange = this.mospParams.getName("AnteMeridiem");
        } else if (substitute == 4) {
            workRange = this.mospParams.getName("PostMeridiem");
        }
        vo.setLblWorkOnHolidayDate(this.getStringDateAndDay(dto.getRequestDate()) + workRange);
        vo.setLblWorkOnHolidayTime(this.getWorkOnHolidaySchedule(dto));
        vo.setLblWorkOnHolidayReason(dto.getRequestReason());
        vo.setLblWorkOnHolidayTransferDate("");
        List substituteList = this.timeReference().substitute().getSubstituteList(workflow);
        Iterator i$ = substituteList.iterator();
        if (i$.hasNext()) {
            SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)i$.next();
            StringBuffer sb = new StringBuffer();
            sb.append(this.getStringDateAndDay(substituteDto.getSubstituteDate()));
            int substituteRange = substituteDto.getSubstituteRange();
            if (substituteRange == 2) {
                sb.append(this.mospParams.getName("AnteMeridiem"));
            } else if (substituteRange == 3) {
                sb.append(this.mospParams.getName("PostMeridiem"));
            }
            vo.setLblWorkOnHolidayTransferDate(sb.toString());
        }
        if ((commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow)) == null) {
            return;
        }
        String approver = this.getWorkflowOperator(commentDto);
        String state = this.geWorkflowtStatus(commentDto);
        vo.setLblWorkOnHolidayApprover(approver);
        vo.setLblWorkOnHolidayState(state);
        vo.setLblWorkOnHolidayComment(commentDto.getWorkflowComment());
        if (vo.isWorkOnHoliday()) {
            vo.setLblCancelApprover(approver);
            vo.setLblCancelState(state);
        }
    }

    protected void setSubHolidayValues(SubHolidayRequestDtoInterface dto) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setLblSubHolidayDate(this.getStringDateAndDay(dto.getRequestDate()));
        vo.setLblSubHolidayWorkDate(this.getStringDateAndDay(dto.getWorkDate()));
        long workflow = dto.getWorkflow();
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
        if (commentDto == null) {
            return;
        }
        String approver = this.getWorkflowOperator(commentDto);
        String state = this.geWorkflowtStatus(commentDto);
        vo.setLblSubHolidayApprover(approver);
        vo.setLblSubHolidayState(state);
        vo.setLblSubHolidayComment(commentDto.getWorkflowComment());
        if (vo.isSubHoliday()) {
            vo.setLblCancelApprover(approver);
            vo.setLblCancelState(state);
        }
    }

    protected void setDifferenceValues(DifferenceRequestDtoInterface dto) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setLblDifferenceDate(this.getStringDateAndDay(dto.getRequestDate()));
        vo.setLblDifferenceWorkType(this.getBeforeDifferenceRequestWorkTypeAbbr());
        vo.setLblDifferenceWorkTime(this.timeReference().differenceRequest().getDifferenceTime(dto));
        vo.setLblDifferenceReason(dto.getRequestReason());
        long workflow = dto.getWorkflow();
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
        if (commentDto == null) {
            return;
        }
        String approver = this.getWorkflowOperator(commentDto);
        String state = this.geWorkflowtStatus(commentDto);
        vo.setLblDifferenceApprover(approver);
        vo.setLblDifferenceState(state);
        vo.setLblDifferenceComment(commentDto.getWorkflowComment());
        if (vo.isDifference()) {
            vo.setLblCancelApprover(approver);
            vo.setLblCancelState(state);
        }
    }

    protected void setWorkTypeChangeValues(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        vo.setLblWorkTypeChangeDate(this.getStringDateAndDay(dto.getRequestDate()));
        vo.setLblWorkTypeChangeBeforeWorkType(this.time().workTypeChangeRequestRegist().getScheduledWorkTypeName(dto));
        vo.setLblWorkTypeChangeAfterWorkType(this.timeReference().workType().getWorkTypeAbbrAndTime(dto.getWorkTypeCode(), dto.getRequestDate()));
        vo.setLblWorkTypeChangeReason(dto.getRequestReason());
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow());
        if (commentDto == null) {
            return;
        }
        String approver = this.getWorkflowOperator(commentDto);
        String state = this.geWorkflowtStatus(commentDto);
        vo.setLblWorkTypeChangeApprover(approver);
        vo.setLblWorkTypeChangeState(state);
        vo.setLblWorkTypeChangeComment(commentDto.getWorkflowComment());
        if (vo.isWorkTypeChange()) {
            vo.setLblCancelApprover(approver);
            vo.setLblCancelState(state);
        }
    }

    protected void setButtonFlag() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        WorkflowDtoInterface dto = this.reference().workflow().getLatestWorkflowInfo(vo.getWorkflow().longValue());
        this.checkSelectedDataExist((Object)dto);
        String personalId = this.mospParams.getUser().getPersonalId();
        if (vo.isConfirmation()) {
            vo.setNeedCancelButton(false);
            vo.setNeedApproveButton(false);
            if (!this.timeReference().cutoffUtil().isNotTighten(vo.getPersonalId(), dto.getWorkflowDate())) {
                return;
            }
            if (workflowIntegrate.isCompleted(dto) || workflowIntegrate.isCancelApprovable(dto) || workflowIntegrate.isCancelWithDrawnApprovable(dto)) {
                if (!vo.isAttendance() && this.timeReference().approvalInfo().isExistAttendanceTargetDate(vo.getPersonalId(), dto.getWorkflowDate())) {
                    return;
                }
                if (this.mospParams.getUserRole().isSuper() || workflowIntegrate.isApprover(dto, personalId)) {
                    vo.setNeedCancelButton(true);
                    return;
                }
            } else if (workflowIntegrate.isApprovable(dto)) {
                if (this.mospParams.getUserRole().isSuper() || workflowIntegrate.isApprover(dto, personalId)) {
                    vo.setNeedApproveButton(true);
                    return;
                }
                List subApproverList = this.reference().subApprover().findForSubApproverId(personalId, 1, this.getSystemDate(), this.getSystemDate());
                for (SubApproverDtoInterface subApproverDto : subApproverList) {
                    if (!workflowIntegrate.isApprover(dto, subApproverDto.getPersonalId())) continue;
                    vo.setNeedApproveButton(true);
                    return;
                }
            }
        } else {
            if (!this.timeReference().cutoffUtil().isNotTighten(vo.getPersonalId(), dto.getWorkflowDate())) {
                vo.setNeedApproveButton(false);
                vo.setNeedCancelApproveButton(false);
                return;
            }
            if (workflowIntegrate.isApprovable(dto)) {
                vo.setNeedCancelApproveButton(false);
                if (this.mospParams.getUserRole().isSuper() || workflowIntegrate.isApprover(dto, personalId)) {
                    vo.setNeedApproveButton(true);
                    return;
                }
                List subApproverList = this.reference().subApprover().findForSubApproverId(personalId, 1, this.getSystemDate(), this.getSystemDate());
                for (SubApproverDtoInterface subApproverDto : subApproverList) {
                    if (!workflowIntegrate.isApprover(dto, subApproverDto.getPersonalId())) continue;
                    vo.setNeedApproveButton(true);
                    return;
                }
            } else if (workflowIntegrate.isCancelApprovable(dto) || workflowIntegrate.isCancelWithDrawnApprovable(dto)) {
                if (this.mospParams.getUserRole().isSuper() || workflowIntegrate.isApprover(dto, personalId)) {
                    vo.setNeedCancelApproveButton(true);
                    return;
                }
                List subApproverList = this.reference().subApprover().findForSubApproverId(personalId, 1, this.getSystemDate(), this.getSystemDate());
                for (SubApproverDtoInterface subApproverDto : subApproverList) {
                    if (!workflowIntegrate.isApprover(dto, subApproverDto.getPersonalId())) continue;
                    vo.setNeedCancelApproveButton(true);
                    return;
                }
            }
            vo.setNeedApproveButton(false);
            vo.setNeedCancelApproveButton(false);
        }
    }

    protected void setRollWorkflow() {
        BaseDtoInterface baseDto;
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        Object object = this.mospParams.getGeneralParam("RollArray");
        if (object != null) {
            vo.setRollArray((BaseDtoInterface[])object);
        }
        if (vo.getRollArray() == null || vo.getRollArray().length == 0) {
            return;
        }
        int i = 0;
        for (BaseDtoInterface baseDto2 : vo.getRollArray()) {
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)baseDto2;
            if (vo.getWorkflow().longValue() == dto.getWorkflow()) break;
            ++i;
        }
        if (i > 0) {
            baseDto = vo.getRollArray()[i - 1];
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)baseDto;
            vo.setPrevWorkflow(dto.getWorkflow());
            vo.setPrevCommand(this.getRollCommand(dto.getRequestType()));
        }
        if (i + 1 < vo.getRollArray().length) {
            baseDto = vo.getRollArray()[i + 1];
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)baseDto;
            vo.setNextWorkflow(dto.getWorkflow());
            vo.setNextCommand(this.getRollCommand(dto.getRequestType()));
        }
    }

    protected String getRollCommand(String requestType) {
        if (CMD_APPROVAL_CONFIRMATION_ATTENDANCE.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_OVERTIME.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_HOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_WORKONHOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_SUBHOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_DIFFERENCE.equals(this.mospParams.getCommand()) || CMD_APPROVAL_CONFIRMATION_WORKTYPECHANGE.equals(this.mospParams.getCommand())) {
            if ("1".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_ATTENDANCE;
            }
            if ("2".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_OVERTIME;
            }
            if ("3".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_HOLIDAY;
            }
            if ("4".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_WORKONHOLIDAY;
            }
            if ("5".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_SUBHOLIDAY;
            }
            if ("6".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_DIFFERENCE;
            }
            if ("7".equals(requestType)) {
                return CMD_APPROVAL_CONFIRMATION_WORKTYPECHANGE;
            }
        } else if (CMD_APPROVAL_ATTENDANCE.equals(this.mospParams.getCommand()) || CMD_APPROVAL_OVERTIME.equals(this.mospParams.getCommand()) || CMD_APPROVAL_HOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_WORKONHOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_SUBHOLIDAY.equals(this.mospParams.getCommand()) || CMD_APPROVAL_DIFFERENCE.equals(this.mospParams.getCommand()) || CMD_APPROVAL_WORKTYPECHANGE.equals(this.mospParams.getCommand())) {
            if ("1".equals(requestType)) {
                return CMD_APPROVAL_ATTENDANCE;
            }
            if ("2".equals(requestType)) {
                return CMD_APPROVAL_OVERTIME;
            }
            if ("3".equals(requestType)) {
                return CMD_APPROVAL_HOLIDAY;
            }
            if ("4".equals(requestType)) {
                return CMD_APPROVAL_WORKONHOLIDAY;
            }
            if ("5".equals(requestType)) {
                return CMD_APPROVAL_SUBHOLIDAY;
            }
            if ("6".equals(requestType)) {
                return CMD_APPROVAL_DIFFERENCE;
            }
            if ("7".equals(requestType)) {
                return CMD_APPROVAL_WORKTYPECHANGE;
            }
        }
        return "";
    }

    protected String getWorkflowComment() throws MospException {
        ApprovalCardVo vo = (ApprovalCardVo)this.mospParams.getVo();
        if (vo.isNeedCancelApproveButton()) {
            return vo.getTxtCancelComment();
        }
        String workflowComment = null;
        if (vo.isAttendance()) {
            workflowComment = vo.getTxtAttendanceComment();
        } else if (vo.isOvertime()) {
            workflowComment = vo.getTxtOverTimeComment();
        } else if (vo.isHoliday()) {
            workflowComment = vo.getTxtHolidayComment();
        } else if (vo.isWorkOnHoliday()) {
            workflowComment = vo.getTxtWorkOnHolidayComment();
        } else if (vo.isSubHoliday()) {
            workflowComment = vo.getTxtCompensationComment();
        } else if (vo.isDifference()) {
            workflowComment = vo.getTxtDifferenceComment();
        } else if (vo.isWorkTypeChange()) {
            workflowComment = vo.getTxtWorkTypeChangeComment();
        }
        return workflowComment;
    }

    protected String getWorkTypeAbbrStartTimeEndTime(AttendanceDtoInterface dto) throws MospException {
        WorkTypeReferenceBeanInterface workType = this.timeReference().workType();
        if (dto == null) {
            return "";
        }
        String workTypeCode = dto.getWorkTypeCode();
        if (this.isDifferenceWorkType(workTypeCode)) {
            return this.mospParams.getProperties().getCodeItemName("DifferenceType", dto.getWorkTypeCode());
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            return workType.getParticularWorkTypeName(workTypeCode);
        }
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        RequestEntity entity = requestUtil.getRequestEntity(dto.getPersonalId(), dto.getWorkDate());
        return this.timeReference().workType().getWorkTypeAbbrAndTime(workTypeCode, dto.getWorkDate(), entity.isAmHoliday(false), entity.isPmHoliday(false));
    }

    protected boolean isDifferenceWorkType(String workTypeCode) {
        return "a".equals(workTypeCode) || "b".equals(workTypeCode) || "c".equals(workTypeCode) || "d".equals(workTypeCode) || "s".equals(workTypeCode);
    }

    protected String getWorkflowOperator(WorkflowCommentDtoInterface dto) throws MospException {
        return this.reference().human().getHumanName(dto.getPersonalId(), dto.getWorkflowDate());
    }

    protected String geWorkflowtStatus(WorkflowCommentDtoInterface dto) {
        return this.getStatusStageValueView(dto.getWorkflowStatus(), dto.getWorkflowStage());
    }

    protected String getNameRequestCard() {
        return this.mospParams.getName("RequestCardVo");
    }
}

