/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.comparator.settings.ManagementRequestRequestDateComparator;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.input.action.ApprovalHistoryAction;
import jp.mosp.time.management.action.ApprovalCardAction;
import jp.mosp.time.management.vo.ApprovalListVo;

public class ApprovalListAction
extends TimeAction {
    public static final String CMD_SHOW = "TM2310";
    public static final String CMD_SHOW_SERCH = "TM2311";
    public static final String CMD_SEARCH = "TM2312";
    public static final String CMD_RE_SHOW = "TM2313";
    public static final String CMD_TRANSFER = "TM2315";
    public static final String CMD_BATCH_APPROVAL = "TM2316";
    public static final String CMD_BATCH_CANCEL = "TM2317";
    public static final String CMD_SORT = "TM2318";
    public static final String CMD_PAGE = "TM2319";
    public static final String MENU_APPROVAL_LIST = "ApprovalList";

    public ApprovalListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new ApprovalListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SHOW_SERCH)) {
            this.prepareVo(false, false);
            this.show();
            this.search(true, false);
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search(true, true);
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search(true, false);
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_APPROVAL)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_CANCEL)) {
            this.prepareVo();
            this.batchCancel();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        this.checkRangeMap(MENU_APPROVAL_LIST);
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
        this.search(false, false);
    }

    protected void search(boolean needList, boolean needNoResultMessage) throws MospException {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        ApprovalInfoReferenceBeanInterface approvalRef = this.timeReference().approvalInfo();
        String personalId = this.mospParams.getUser().getPersonalId();
        Map approvableMap = approvalRef.getApprovableMap(personalId);
        Map subApprovableMap = approvalRef.getSubApprovableMap(personalId, approvableMap);
        Map cancelableMap = approvalRef.getCancelableMap(personalId);
        Map subCancelableMap = approvalRef.getSubCancelableMap(personalId, approvableMap);
        this.setApprovableConut(approvableMap, subApprovableMap, cancelableMap, subCancelableMap);
        if (!needList) {
            return;
        }
        String approvalType = this.getTransferredGenericCode();
        if (approvalType == null) {
            approvalType = vo.getApprovalType();
        }
        vo.setApprovalType(approvalType);
        String functionCode = this.getTransferredType();
        if (functionCode == null) {
            functionCode = vo.getFunctionCode();
        }
        vo.setFunctionCode(functionCode);
        List list = null;
        list = "6".equals(approvalType) || "7".equals(approvalType) ? approvalRef.getApprovableList(cancelableMap, subCancelableMap, "") : approvalRef.getApprovableList(approvableMap, subApprovableMap, functionCode);
        vo.setList(list);
        vo.setComparatorName(ManagementRequestRequestDateComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty() && needNoResultMessage) {
            this.addNoSearchResultMessage();
        }
    }

    protected void transfer() {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        this.setTargetWorkflow(vo.getAryWorkflow(this.getTransferredIndex()));
        String actionName = this.getTransferredAction();
        if (actionName.equals(ApprovalHistoryAction.class.getName())) {
            this.mospParams.setNextCommand(vo.getAryLblRequestTypeHistoryCmd(this.getTransferredIndex()));
        } else if (actionName.equals(ApprovalCardAction.class.getName())) {
            this.mospParams.addGeneralParam("RollArray", (Object)this.getArray());
            this.mospParams.setNextCommand(vo.getAryLblRequestTypeCmd(this.getTransferredIndex()));
        }
    }

    protected void batchUpdate() throws MospException {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        long[] aryWorkflow = this.getIdArray(vo.getCkbSelect());
        this.time().timeApproval().approve(aryWorkflow, null);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.search(true, false);
    }

    protected void batchCancel() throws MospException {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        long[] aryWorkflow = this.getIdArray(vo.getCkbSelect());
        this.time().timeApproval().cancelApprove(aryWorkflow, null);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        vo.setCkbSelect(new String[0]);
        this.search(true, false);
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    public void setDefaultValues() {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        vo.setLblAttendance("0");
        vo.setLblOverTime("0");
        vo.setLblHoliday("0");
        vo.setLblWorkOnHoliday("0");
        vo.setLblSubHoliday("0");
        vo.setLblWorkTypeChange("0");
        vo.setLblDifference("0");
        vo.setLblTotalApproval("0");
        vo.setLblTotalCancel("0");
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblRequestType = new String[list.size()];
        String[] aryLblRequestDate = new String[list.size()];
        String[] aryRequestDate = new String[list.size()];
        String[] aryLblRequestInfo = new String[list.size()];
        String[] aryLblState = new String[list.size()];
        String[] aryStateStyle = new String[list.size()];
        String[] aryLblRequestFunctionCode = new String[list.size()];
        String[] aryLblRequestTypeCmd = new String[list.size()];
        String[] aryLblRequestTypeHistoryCmd = new String[list.size()];
        String[] aryState = new String[list.size()];
        String[] aryStage = new String[list.size()];
        long[] aryWorkflow = new long[list.size()];
        String[] aryClasOverTimeIn = new String[list.size()];
        String[] aryBackColor = new String[list.size()];
        SectionReferenceBeanInterface getSection = this.reference().section();
        Date date = DateUtility.getSystemDate();
        int i = 0;
        for (BaseDtoInterface baseDtoInterface : list) {
            int overWorkTime;
            LimitStandardDtoInterface limitDto;
            ManagementRequestListDtoInterface dto = (ManagementRequestListDtoInterface)baseDtoInterface;
            ApplicationDtoInterface appDto = this.timeReference().application().findForPerson(dto.getPersonalId(), date);
            int overWrokTimeWrn = 1000;
            int overWrokTimeInf = 1000;
            if (appDto != null && (limitDto = this.timeReference().limitStandard().getLimitStandardInfo(appDto.getApplicationCode(), date, "month1")) != null) {
                overWrokTimeWrn = limitDto.getWarningTime();
                overWrokTimeInf = limitDto.getAttentionTime();
            }
            aryClasOverTimeIn[i] = overWrokTimeWrn < (overWorkTime = 0) ? "style=\"background-color: red\"" : (overWrokTimeInf < overWorkTime ? "style=\"background-color: yellow\"" : "");
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = getSection.getSectionAbbr(dto.getSectionCode(), date);
            aryLblRequestType[i] = this.getRequestTypeForView(dto);
            aryLblRequestTypeCmd[i] = this.getCardCommand(dto);
            aryLblRequestTypeHistoryCmd[i] = this.getHistoryCommand(dto.getRequestType());
            aryLblRequestFunctionCode[i] = dto.getRequestType();
            aryLblRequestDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryRequestDate[i] = DateUtility.getStringDate((Date)dto.getRequestDate());
            aryLblRequestInfo[i] = this.getRequestInfo(dto);
            aryLblState[i] = this.getStatusStageValueView(dto.getState(), dto.getStage());
            aryStateStyle[i] = this.getStatusColor(dto.getState());
            aryState[i] = String.valueOf(dto.getState());
            aryStage[i] = String.valueOf(dto.getStage());
            aryWorkflow[i] = dto.getWorkflow();
            aryBackColor[i] = this.setBackColor(dto.getPersonalId(), dto.getRequestDate(), dto.getRequestType());
            ++i;
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblRequestType(aryLblRequestType);
        vo.setAryLblRequestDate(aryLblRequestDate);
        vo.setAryRequestDate(aryRequestDate);
        vo.setAryLblRequestInfo(aryLblRequestInfo);
        vo.setAryLblState(aryLblState);
        vo.setAryStateStyle(aryStateStyle);
        vo.setAryLblRequestTypeCmd(aryLblRequestTypeCmd);
        vo.setAryLblRequestTypeHistoryCmd(aryLblRequestTypeHistoryCmd);
        vo.setAryLblRequestFunctionCode(aryLblRequestFunctionCode);
        vo.setAryState(aryState);
        vo.setAryStage(aryStage);
        vo.setAryWorkflow(aryWorkflow);
        vo.setAryClasOverTimeIn(aryClasOverTimeIn);
        vo.setAryBackColor(aryBackColor);
    }

    protected String getCardCommand(ManagementRequestListDtoInterface dto) {
        if (dto == null) {
            return "";
        }
        if ("1".equals(dto.getRequestType())) {
            return "TM2321";
        }
        if ("2".equals(dto.getRequestType())) {
            return "TM2331";
        }
        if ("3".equals(dto.getRequestType())) {
            return "TM2341";
        }
        if ("4".equals(dto.getRequestType())) {
            return "TM2351";
        }
        if ("5".equals(dto.getRequestType())) {
            return "TM2361";
        }
        if ("6".equals(dto.getRequestType())) {
            return "TM2371";
        }
        if ("7".equals(dto.getRequestType())) {
            return "TM2381";
        }
        return "";
    }

    protected void setApprovableConut(Map<String, Map<Long, WorkflowDtoInterface>> approvableMap, Map<String, Map<Long, WorkflowDtoInterface>> subApprovableMap, Map<String, Map<Long, WorkflowDtoInterface>> cancelableMap, Map<String, Map<Long, WorkflowDtoInterface>> subCancelableMap) {
        ApprovalListVo vo = (ApprovalListVo)this.mospParams.getVo();
        int attendanceCount = approvableMap.get("1").size();
        int overTimeCount = approvableMap.get("2").size();
        int holidayCount = approvableMap.get("3").size();
        int workOnHolidayCount = approvableMap.get("4").size();
        int subHolidayCount = approvableMap.get("5").size();
        int differenceCount = approvableMap.get("6").size();
        int workTypeChangeCount = approvableMap.get("7").size();
        attendanceCount += subApprovableMap.get("1").size();
        overTimeCount += subApprovableMap.get("2").size();
        holidayCount += subApprovableMap.get("3").size();
        workOnHolidayCount += subApprovableMap.get("4").size();
        subHolidayCount += subApprovableMap.get("5").size();
        differenceCount += subApprovableMap.get("6").size();
        workTypeChangeCount += subApprovableMap.get("7").size();
        vo.setLblAttendance(String.valueOf(attendanceCount));
        vo.setLblOverTime(String.valueOf(overTimeCount));
        vo.setLblHoliday(String.valueOf(holidayCount));
        vo.setLblWorkOnHoliday(String.valueOf(workOnHolidayCount));
        vo.setLblSubHoliday(String.valueOf(subHolidayCount));
        vo.setLblDifference(String.valueOf(differenceCount));
        vo.setLblWorkTypeChange(String.valueOf(workTypeChangeCount));
        vo.setLblTotalApproval(String.valueOf(attendanceCount + overTimeCount + holidayCount + workOnHolidayCount + subHolidayCount + differenceCount + workTypeChangeCount));
        vo.setLblTotalCancel(String.valueOf(cancelableMap.get("1").size() + cancelableMap.get("2").size() + cancelableMap.get("3").size() + cancelableMap.get("4").size() + cancelableMap.get("5").size() + cancelableMap.get("6").size() + cancelableMap.get("7").size() + subCancelableMap.get("1").size() + subCancelableMap.get("2").size() + subCancelableMap.get("3").size() + subCancelableMap.get("4").size() + subCancelableMap.get("5").size() + subCancelableMap.get("6").size() + subCancelableMap.get("7").size()));
    }

    protected String getStatusColor(String status) {
        if ("4".equals(status)) {
            return "";
        }
        return super.getStatusColor(status);
    }
}

