/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.management.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.SubordinateFiscalSearchBeanInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;
import jp.mosp.time.management.action.SubordinateFiscalReferenceAction;
import jp.mosp.time.management.vo.SubordinateFiscalListVo;
import jp.mosp.time.settings.base.TimeSettingAction;

public class SubordinateFiscalListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM2510";
    public static final String CMD_SEARCH = "TM2512";
    public static final String CMD_RE_SHOW = "TM2513";
    public static final String CMD_TRANSFER = "TM2515";
    public static final String CMD_SORT = "TM2518";
    public static final String CMD_PAGE = "TM2519";
    public static final String CMD_SET_DISPLAY_YEAR = "TM2590";
    public static final String CMD_SET_SEARCH_DATE = "TM2591";

    public SubordinateFiscalListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new SubordinateFiscalListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.reShowJudging();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_DISPLAY_YEAR)) {
            this.prepareVo();
            this.setDisplayYear();
        } else if (this.mospParams.getCommand().equals(CMD_SET_SEARCH_DATE)) {
            this.prepareVo();
            this.setSearchDate();
        }
    }

    protected void show() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setPulldown();
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
    }

    public void setDefaultValues() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setLblSeasonHolidayItem("");
        vo.setPltSearchHumanType(String.valueOf(2));
        vo.setModeDisplayYear("chaning");
        vo.setModeActivateDate("chaning");
        Date targetYearMonth = MonthUtility.getTargetYearMonth((Date)this.getSystemDate(), (MospParams)this.mospParams);
        vo.setAryPltDisplayYear(this.getYearArray(MonthUtility.getFiscalYear((Date)this.getSystemDate(), (MospParams)this.mospParams)));
        vo.setAryPltRequestYear(this.getYearArray(DateUtility.getYear((Date)targetYearMonth)));
        vo.setAryPltRequestMonth(this.getMonthArray());
        vo.setPltSearchDisplayYear(String.valueOf(MonthUtility.getFiscalYear((Date)this.getSystemDate(), (MospParams)this.mospParams)));
        vo.setPltSearchRequestYear(DateUtility.getStringYear((Date)targetYearMonth));
        vo.setPltSearchRequestMonth(DateUtility.getStringMonthM((Date)targetYearMonth));
        this.checkAvailable();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        vo.setModeDisplayYear("fixed");
        vo.setModeActivateDate("fixed");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
        this.setSectionCode();
        vo.setLblSeasonHolidayItem(this.getLblSeasonHolidayItemName());
    }

    protected void setPulldown() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        String operationType = "1";
        String[][] workPlace = this.reference().workPlace().getNameSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltWorkPlace(workPlace);
        String[][] aryEmployment = this.reference().employmentContract().getNameSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltEmployment(aryEmployment);
        String[][] arySection = this.reference().section().getCodedSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltSection(arySection);
        String[][] aryPosition = this.reference().position().getCodedSelectArray(this.getSearchDate(), true, operationType);
        vo.setAryPltPosition(aryPosition);
        MospProperties properties = this.mospParams.getProperties();
        vo.setAryPltHumanType(properties.getCodeArray("SubordinateSearchType", true));
    }

    protected void search() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        int targetYear = this.getInt(vo.getPltSearchRequestYear());
        int targetMonth = this.getInt(vo.getPltSearchRequestMonth());
        SubordinateFiscalSearchBeanInterface search = this.timeReference().subordinateFiscalSearch();
        if (vo.getModeActivateDate().equals("chaning") || vo.getModeDisplayYear().equals("chaning")) {
            this.mospParams.addErrorMessage("PFW0107", new String[0]);
            return;
        }
        this.checkSearchCondition(new String[]{vo.getTxtSearchEmployeeCode(), vo.getTxtSearchEmployeeName(), vo.getPltSearchWorkPlace(), vo.getPltSearchEmployment(), vo.getPltSearchSection(), vo.getPltSearchPosition(), vo.getPltSearchHumanType()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        search.setTargetDate(this.getSearchDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentContractCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setHumanType(vo.getPltSearchHumanType());
        search.setStartDate(MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams));
        search.setEndDate(MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams));
        search.setTargetYear(targetYear);
        search.setTargetMonth(targetMonth);
        search.setDisplayYear(this.getFiscalYear());
        List list = search.getSubordinateFiscalList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void reShowJudging() throws MospException {
        if (this.mospParams.getApplicationPropertyBool("ViewTotalValues")) {
            return;
        }
        this.search();
    }

    protected void transfer() throws MospException {
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(this.getSelectedPersonalId(this.getTransferredIndex()));
        this.setTargetDate(this.getSearchDate());
        this.setTargetYear(this.getFiscalYear());
        if (actionName.equals(SubordinateFiscalReferenceAction.class.getName())) {
            this.mospParams.addGeneralParam("RollArray", (Object)this.getArray());
            this.mospParams.setNextCommand("TM2521");
        }
    }

    protected void setDisplayYear() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        this.checkAvailable();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (vo.getModeDisplayYear().equals("chaning")) {
            vo.setModeDisplayYear("fixed");
        } else {
            vo.setModeDisplayYear("chaning");
        }
        ArrayList list = new ArrayList();
        vo.setList(list);
        this.setVoList(list);
    }

    protected void setSearchDate() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        this.checkAvailable();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (vo.getModeDisplayYear().equals("chaning")) {
            this.mospParams.addErrorMessage("TMW0336", new String[]{this.mospParams.getName("Display", new String[]{"FiscalYear"})});
            return;
        }
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            this.setPulldown();
            vo.setPltSearchSection("");
            this.setSectionCode();
            vo.setLblSeasonHolidayItem(this.getLblSeasonHolidayItemName());
        } else {
            vo.setModeActivateDate("chaning");
            this.setInitPulldown();
        }
        ArrayList list = new ArrayList();
        vo.setList(list);
        this.setVoList(list);
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblSection = new String[list.size()];
        String[] aryLblOverTime = new String[list.size()];
        String[] aryLblPaidHolidayDays = new String[list.size()];
        String[] aryLblPaidHolidayRestDays = new String[list.size()];
        String[] aryLblStockHolidayDays = new String[list.size()];
        String[] aryLblStockHolidayRestDays = new String[list.size()];
        String[] aryLblSeasonHolidayDays = new String[list.size()];
        String[] aryLblSeasonHolidayRestDays = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SubordinateFiscalListDtoInterface dto = (SubordinateFiscalListDtoInterface)list.get(i);
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblSection[i] = this.reference().section().getSectionAbbr(dto.getSectionCode(), this.getSearchDate());
            aryLblOverTime[i] = this.toTimeDotFormatString(dto.getOverTime());
            aryLblPaidHolidayDays[i] = this.getNumberOfDayAndHour(dto.getPaidHolidayDays().doubleValue(), dto.getPaidHolidayTime().intValue());
            aryLblPaidHolidayRestDays[i] = this.getNumberOfDayAndHour(dto.getPaidHolidayRestDays().doubleValue(), dto.getPaidHolidayRestTime().intValue());
            aryLblStockHolidayDays[i] = this.getNumberOfDayAndHour(dto.getStockHolidayDays().doubleValue(), 0);
            aryLblStockHolidayRestDays[i] = this.getNumberOfDayAndHour(dto.getStockHolidayRestDays().doubleValue(), 0);
            aryLblSeasonHolidayDays[i] = this.getNumberOfDayAndHour(dto.getSeasonHolidayDays().doubleValue(), 0);
            aryLblSeasonHolidayRestDays[i] = this.getNumberOfDayAndHour(dto.getSeasonHolidayRestDays().doubleValue(), 0);
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblSection(aryLblSection);
        vo.setAryLblOverTime(aryLblOverTime);
        vo.setAryLblPaidHolidayDays(aryLblPaidHolidayDays);
        vo.setAryLblPaidHolidayRestDays(aryLblPaidHolidayRestDays);
        vo.setAryLblStockHolidayDays(aryLblStockHolidayDays);
        vo.setAryLblStockHolidayRestDays(aryLblStockHolidayRestDays);
        vo.setAryLblSeasonHolidayDays(aryLblSeasonHolidayDays);
        vo.setAryLblSeasonHolidayRestDays(aryLblSeasonHolidayRestDays);
    }

    protected Date getSearchDate() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        return MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getPltSearchRequestYear()), (int)this.getInt(vo.getPltSearchRequestMonth()), (MospParams)this.mospParams);
    }

    protected int getFiscalYear() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        return this.getInt(vo.getPltSearchDisplayYear());
    }

    protected void checkAvailable() throws MospException {
        if (this.mospParams.getUserRole().isSuper()) {
            return;
        }
        HumanDtoInterface dto = this.reference().human().getHumanInfo(this.mospParams.getUser().getPersonalId(), this.getSearchDate());
        if (dto == null) {
            this.addErrorMessageUnsetting(this.mospParams.getName("Section", new String[]{"Information"}));
            return;
        }
        if (dto.getSectionCode() == null || dto.getSectionCode().isEmpty()) {
            this.addErrorMessageUnsetting(this.mospParams.getName("Section", new String[]{"Information"}));
        }
        if (dto.getPositionCode() == null || dto.getPositionCode().isEmpty()) {
            this.addErrorMessageUnsetting(this.mospParams.getName("Position", new String[]{"Information"}));
        }
    }

    private void setInitPulldown() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        String[][] initPulldown = this.getInputActivateDatePulldown();
        vo.setAryPltWorkPlace(initPulldown);
        vo.setAryPltEmployment(initPulldown);
        vo.setAryPltSection(initPulldown);
        vo.setAryPltPosition(initPulldown);
    }

    protected void setSectionCode() throws MospException {
        SubordinateFiscalListVo vo = (SubordinateFiscalListVo)this.mospParams.getVo();
        vo.setPltSearchSection("");
    }

    protected String getLblSeasonHolidayItemName() throws MospException {
        String seasonCode = this.mospParams.getApplicationProperty("SeasonHolidayCode");
        HolidayDtoInterface holidayDto = this.timeReference().holiday().getHolidayInfo(seasonCode, this.getSearchDate(), 2);
        if (holidayDto == null || holidayDto.getHolidayAbbr().isEmpty()) {
            return this.mospParams.getName("Hyphen");
        }
        return MospUtility.substring((String)holidayDto.getHolidayAbbr(), (int)2);
    }

    protected String getNumberOfDayAndHour(double day, int hour) {
        if (day == 0.0 && hour == 0) {
            return this.mospParams.getName("Hyphen");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(day);
        sb.append(this.mospParams.getName("Day"));
        if (hour > 0) {
            sb.append(hour);
            sb.append(this.mospParams.getName("Time"));
        }
        return sb.toString();
    }

    public void addErrorMessageUnsetting(String itemName) {
        this.mospParams.addErrorMessage("TMW0262", new String[]{itemName, this.mospParams.getName("Subordinate", new String[]{"List"}), this.mospParams.getName("HumanInfo", new String[]{"Management"})});
    }
}

