/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.portal.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class PortalAttendanceCheckBean
extends PortalBean
implements PortalBeanInterface {
    EntranceReferenceBeanInterface entranceRefer;
    TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeRefer;
    CutoffUtilBeanInterface cutoffUtill;
    AttendanceListReferenceBeanInterface attendanceList;
    protected static final String PATH_PORTAL_CHECK_TIME_VIEW = "/jsp/time/portal/portalAttendanceCheck.jsp";
    public static final String MSG_NO_APPLI_TIME_WORK = "TMW0287";
    public static final String MSG_CONFIRM = "TMI0003";
    public static final String PRM_ATTENDANCE_CHECK_MESSAGE = "prmAttendanceCheckMessage";

    public PortalAttendanceCheckBean() {
    }

    protected PortalAttendanceCheckBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
        this.cutoffUtill = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.totalTimeEmployeeRefer = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.attendanceList = (AttendanceListReferenceBeanInterface)this.createBean(AttendanceListReferenceBeanInterface.class);
    }

    public void show() throws MospException {
        this.addPortalViewList(PATH_PORTAL_CHECK_TIME_VIEW);
        String personalId = this.mospParams.getUser().getPersonalId();
        Date yesterday = DateUtility.addDay((Date)this.getSystemDate(), (int)-1);
        Date startDate = this.setStartDate(personalId, yesterday);
        if (startDate == null || startDate.after(yesterday)) {
            this.mospParams.getErrorMessageList().clear();
            return;
        }
        List errorList = this.attendanceList.getNotAttendanceAppliList(personalId, startDate, yesterday);
        this.addErrorMessageNotTimeAppli(errorList);
        this.mospParams.getErrorMessageList().clear();
    }

    protected Date setStartDate(String personalId, Date yesterday) throws MospException {
        Date today = this.getSystemDate();
        Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
        TimeSettingDtoInterface timeSettingDto = this.cutoffUtill.getTimeSetting(personalId, today);
        if (timeSettingDto == null || timeSettingDto.getTimeManagementFlag() == 1) {
            return null;
        }
        CutoffDtoInterface cutoffDto = this.cutoffUtill.getCutoff(timeSettingDto.getCutoffCode(), today);
        if (cutoffDto == null) {
            return null;
        }
        TotalTimeEmployeeDtoInterface totalTimeEmployeeDto = this.totalTimeEmployeeRefer.findForPersonalList(personalId, 1);
        if (totalTimeEmployeeDto != null) {
            int totalTimeYear = totalTimeEmployeeDto.getCalculationYear();
            int totalTimeMounth = totalTimeEmployeeDto.getCalculationMonth();
            Date startDate = DateUtility.addDay((Date)TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)totalTimeYear, (int)totalTimeMounth), (int)1);
            if (entranceDate.after(startDate)) {
                return entranceDate;
            }
            return startDate;
        }
        Date cutoffDate = TimeUtility.getCutoffMonth((int)cutoffDto.getCutoffDate(), (Date)today);
        int targetYear = DateUtility.getYear((Date)cutoffDate);
        int targetMounth = DateUtility.getMonth((Date)cutoffDate);
        Date startDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)targetYear, (int)targetMounth);
        boolean isTermEmploy = DateUtility.isTermContain((Date)entranceDate, (Date)startDate, (Date)yesterday);
        if (isTermEmploy) {
            return entranceDate;
        }
        return startDate;
    }

    protected void addErrorMessageNotTimeAppli(List<Date> errorDateList) throws MospException {
        if (errorDateList.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < errorDateList.size(); ++i) {
            String[] rep = new String[]{DateUtility.getStringDate((Date)errorDateList.get(i))};
            sb.append(this.mospParams.getMessage(MSG_NO_APPLI_TIME_WORK, rep));
            sb.append("\\\\n");
            if (i != 9 || errorDateList.size() <= 10) continue;
            sb.append(this.mospParams.getName("Other"));
            sb.append(errorDateList.size() - (i + 1));
            sb.append(this.mospParams.getName("Count"));
            sb.append("\\\\n");
            break;
        }
        String[] rep = new String[]{sb.toString()};
        this.mospParams.addGeneralParam(PRM_ATTENDANCE_CHECK_MESSAGE, (Object)this.mospParams.getMessage(MSG_CONFIRM, rep));
    }

    public void regist() {
    }
}

