/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.report.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.jasperreport.JasperReportUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.report.bean.AttendanceBookBeanInterface;

public class AttendanceBookBean
extends PlatformBean
implements AttendanceBookBeanInterface {
    protected AttendanceListReferenceBeanInterface attendanceListRefer;

    public void initBean() throws MospException {
        this.attendanceListRefer = (AttendanceListReferenceBeanInterface)this.createBean(AttendanceListReferenceBeanInterface.class);
    }

    public void makeAttendanceBook(String personalId, Date targetDate) throws MospException {
        List attendanceList = this.attendanceListRefer.getActualList(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.makeAttendanceBook(attendanceList);
    }

    public void makeAttendanceBook(String personalId, int year, int month) throws MospException {
        List attendanceList = this.attendanceListRefer.getActualList(personalId, year, month);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.makeAttendanceBook(attendanceList);
    }

    public void makeAttendanceBooks(String[] personalIds, int year, int month) throws MospException {
        ArrayList list = new ArrayList();
        for (String personalId : personalIds) {
            List attendanceList = this.attendanceListRefer.getActualList(personalId, year, month);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            list.addAll(attendanceList);
        }
        this.makeAttendanceBook(list);
    }

    protected void makeAttendanceBook(List<AttendanceListDto> attendanceList) throws MospException {
        for (AttendanceListDto dto : attendanceList) {
            dto.setTitle(this.getReportTitle());
        }
        this.mospParams.setFile((Object)JasperReportUtility.createJasperPrint((String)this.getTemplatePath(), attendanceList));
        this.mospParams.setFileName("attendanceBook.pdf");
    }

    protected String getTemplatePath() {
        return this.mospParams.getApplicationProperty("Docbase") + this.mospParams.getApplicationProperty("attendanceBook.pdf");
    }

    protected String getReportTitle() {
        return this.mospParams.getName("AttendanceBook");
    }
}

