/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.text.Format;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataSearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataGrantBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataGrantListDtoInterface;
import jp.mosp.time.settings.vo.PaidHolidayDataGrantListVo;

public class PaidHolidayDataGrantListAction
extends TimeAction {
    public static final String CMD_SHOW = "TM040900";
    public static final String CMD_SEARCH = "TM040902";
    public static final String CMD_RE_SHOW = "TM040903";
    public static final String CMD_BATCH_UPDATE = "TM040906";
    public static final String CMD_SORT = "TM040907";
    public static final String CMD_PAGE = "TM040908";
    public static final String CMD_SET_ACTIVATION_DATE = "TM040909";
    public static final String CMD_TRANSFER = "TM040920";
    public static final String CMD_CALC1 = "TM040926";
    public static final String CMD_CALC2 = "TM040927";
    public static final String CMD_OTHER_BATCH_UPDATE1 = "TM040936";
    public static final String CMD_OTHER_BATCH_UPDATE2 = "TM040937";
    public static final String CMD_OTHER_BATCH_UPDATE3 = "TM040938";
    protected static final String PRM_CKB_SELECT = "ckbSelect";

    public PaidHolidayDataGrantListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PaidHolidayDataGrantListVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return this.mospParams.getVo();
        }
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        if (this.mospParams.getRequestParam(PRM_CKB_SELECT) == null) {
            vo.setCkbSelect(new String[0]);
        }
        return vo;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_CALC1)) {
            this.prepareVo();
            this.calc1();
        } else if (this.mospParams.getCommand().equals(CMD_CALC2)) {
            this.prepareVo();
            this.calc2();
        } else if (this.mospParams.getCommand().equals(CMD_OTHER_BATCH_UPDATE1)) {
            this.prepareVo();
            this.otherBatchUpdate1();
        } else if (this.mospParams.getCommand().equals(CMD_OTHER_BATCH_UPDATE2)) {
            this.prepareVo();
            this.otherBatchUpdate2();
        } else if (this.mospParams.getCommand().equals(CMD_OTHER_BATCH_UPDATE3)) {
            this.prepareVo();
            this.otherBatchUpdate3();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void show() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void search() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataSearchBeanInterface search = this.getSearchBean();
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
        vo.setJsCalcAttendanceRate("");
    }

    protected void batchUpdate() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataGrantBeanInterface paidHolidayDataGrant = this.time().paidHolidayDataGrant();
        for (String index : vo.getCkbSelect()) {
            int i = Integer.parseInt(index);
            if (!this.mospParams.getName("Accomplish").equals(vo.getAryLblAccomplish()[i])) continue;
            paidHolidayDataGrant.grant(vo.getAryPersonalId()[i], this.getDate(vo.getAryLblGrantDate()[i]));
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addGrantMessage();
        this.calc();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void setActivationDate() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        if ("chaning".equals(vo.getModeActivateDate())) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        List list = Collections.emptyList();
        vo.setList(list);
        this.setVoList(list);
    }

    protected void transfer() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        int index = this.getTransferredIndex();
        this.setTargetPersonalId(vo.getAryPersonalId()[index]);
        this.setTargetDate(this.getDate(vo.getAryLblGrantDate()[index]));
        this.mospParams.setNextCommand("TM041001");
    }

    protected void calc1() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        this.calc();
        vo.setJsCalcAttendanceRate("true");
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.commit();
    }

    protected void calc2() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataSearchBeanInterface search = this.getSearchBean();
        search.setCalcAttendanceRate(true);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
        vo.setJsCalcAttendanceRate("true");
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.commit();
    }

    protected void otherBatchUpdate1() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataGrantBeanInterface paidHolidayDataGrant = this.time().paidHolidayDataGrant();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < vo.getAryPersonalId().length; ++i) {
            if (!this.mospParams.getName("Accomplish").equals(vo.getAryLblAccomplish()[i])) continue;
            paidHolidayDataGrant.grant(vo.getAryPersonalId()[i], this.getDate(vo.getAryLblGrantDate()[i]));
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                return;
            }
            set.add(vo.getAryPersonalId()[i]);
        }
        this.commit();
        if (!set.isEmpty()) {
            this.addGrantMessage();
        }
        this.registedSearch(set);
    }

    protected void otherBatchUpdate2() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        StockHolidayDataGrantBeanInterface stockHolidayDataGrant = this.time().stockHolidayDataGrant();
        Date searchActivateDate = this.getSearchActivateDate();
        for (String personalId : vo.getAryPersonalId()) {
            stockHolidayDataGrant.grant(personalId, searchActivateDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addGrantMessage();
        this.search();
    }

    protected void otherBatchUpdate3() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        for (BaseDtoInterface baseDto : vo.getList()) {
            PaidHolidayDataGrantListDtoInterface paidHolidayDataGrantListDto = (PaidHolidayDataGrantListDtoInterface)baseDto;
            if (paidHolidayDataGrantListDto.getFirstDate() == null || paidHolidayDataGrantListDto.getLastDate() == null) continue;
            attendanceTransactionRegist.regist(paidHolidayDataGrantListDto.getPersonalId(), paidHolidayDataGrantListDto.getFirstDate(), paidHolidayDataGrantListDto.getLastDate(), false);
        }
        this.commit();
        this.addInsertMessage();
        this.calc();
    }

    protected void calc() throws MospException {
        String[] aryIndex;
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        HashSet<String> set = new HashSet<String>();
        for (String index : aryIndex = vo.getCkbSelect()) {
            set.add(vo.getAryPersonalId()[Integer.parseInt(index)]);
        }
        this.registedSearch(set);
    }

    protected void registedSearch(Set<String> personalIdSet) throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataSearchBeanInterface search = this.getSearchBean();
        search.setCalcAttendanceRate(true);
        search.setPersonalIdSet(personalIdSet);
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void setDefaultValues() {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtSearchActivateYear(this.getStringYear(date));
        vo.setTxtSearchActivateMonth(this.getStringMonth(date));
        vo.setTxtSearchActivateDay(this.getStringDay(date));
        vo.setTxtSearchEntrance("");
        vo.setTxtSearchEntranceMonth("");
        vo.setTxtSearchEntranceDay("");
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setPltSearchPaidHoliday("");
        vo.setPltSearchGrant("");
        vo.setJsCalcAttendanceRate("");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
    }

    protected void setPulldown() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        WorkPlaceReferenceBeanInterface workPlace = this.reference().workPlace();
        EmploymentContractReferenceBeanInterface employmentContract = this.reference().employmentContract();
        SectionReferenceBeanInterface section = this.reference().section();
        PositionReferenceBeanInterface position = this.reference().position();
        PaidHolidayReferenceBeanInterface paidHoliday = this.timeReference().paidHoliday();
        if ("fixed".equals(vo.getModeActivateDate())) {
            Date searchActivateDate = this.getSearchActivateDate();
            vo.setAryPltSearchWorkPlace(workPlace.getCodedSelectArray(searchActivateDate, true, null));
            vo.setAryPltSearchEmployment(employmentContract.getCodedSelectArray(searchActivateDate, true, null));
            vo.setAryPltSearchSection(section.getCodedSelectArray(searchActivateDate, true, null));
            vo.setAryPltSearchPosition(position.getCodedSelectArray(searchActivateDate, true, null));
            vo.setAryPltSearchPaidHoliday(paidHoliday.getCodedSelectArray(searchActivateDate, true));
            return;
        }
        String[][] inputActivateDatePulldown = this.getInputActivateDatePulldown();
        vo.setAryPltSearchWorkPlace(inputActivateDatePulldown);
        vo.setAryPltSearchEmployment(inputActivateDatePulldown);
        vo.setAryPltSearchSection(inputActivateDatePulldown);
        vo.setAryPltSearchPosition(inputActivateDatePulldown);
        vo.setAryPltSearchPaidHoliday(inputActivateDatePulldown);
    }

    protected Date getSearchEntranceFromDate() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        String year = vo.getTxtSearchEntrance();
        String month = vo.getTxtSearchEntranceMonth();
        String day = vo.getTxtSearchEntranceDay();
        if (!(year.isEmpty() || month.isEmpty() || day.isEmpty())) {
            return this.getDate(year, month, day);
        }
        if (!year.isEmpty() && !month.isEmpty()) {
            return MonthUtility.getYearMonthTermFirstDate((int)this.getInt(year), (int)this.getInt(month), (MospParams)this.mospParams);
        }
        if (year.isEmpty() && month.isEmpty() && day.isEmpty()) {
            return null;
        }
        return MonthUtility.getYearMonthTermFirstDate((int)this.getInt(year), (int)1, (MospParams)this.mospParams);
    }

    protected Date getSearchEntranceToDate() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        String year = vo.getTxtSearchEntrance();
        String month = vo.getTxtSearchEntranceMonth();
        String day = vo.getTxtSearchEntranceDay();
        if (!(year.isEmpty() || month.isEmpty() || day.isEmpty())) {
            return this.getDate(year, month, day);
        }
        if (!year.isEmpty() && !month.isEmpty()) {
            return MonthUtility.getYearMonthTermLastDate((int)this.getInt(year), (int)this.getInt(month), (MospParams)this.mospParams);
        }
        if (year.isEmpty() && month.isEmpty() && day.isEmpty()) {
            return null;
        }
        return MonthUtility.getYearMonthTermLastDate((int)this.getInt(year), (int)12, (MospParams)this.mospParams);
    }

    protected PaidHolidayDataSearchBeanInterface getSearchBean() throws MospException {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        PaidHolidayDataSearchBeanInterface search = this.timeReference().paidHolidayDataSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEntranceFromDate(this.getSearchEntranceFromDate());
        search.setEntranceToDate(this.getSearchEntranceToDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setPaidHolidayCode(vo.getPltSearchPaidHoliday());
        search.setGrant(vo.getPltSearchGrant());
        search.setCalcAttendanceRate(false);
        return search;
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        PaidHolidayDataGrantListVo vo = (PaidHolidayDataGrantListVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblAttendanceRate = new String[list.size()];
        String[] aryLblAccomplish = new String[list.size()];
        String[] aryLblGrant = new String[list.size()];
        String[] aryLblGrantDate = new String[list.size()];
        String[] aryLblGrantDays = new String[list.size()];
        String[] aryLblNumberOfAttendance = new String[list.size()];
        String[] aryPersonalId = new String[list.size()];
        Format format = this.getPercentFormat(1);
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayDataGrantListDtoInterface dto = (PaidHolidayDataGrantListDtoInterface)list.get(i);
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = this.getLastFirstName(dto.getLastName(), dto.getFirstName());
            aryLblAttendanceRate[i] = this.getAttendanceRate(dto, format);
            aryLblAccomplish[i] = dto.getAccomplish();
            aryLblGrant[i] = dto.getGrant();
            aryLblGrantDate[i] = this.getGrantDate(dto);
            aryLblGrantDays[i] = this.getGrantDays(dto);
            aryLblNumberOfAttendance[i] = this.getNumberOfAttendance(dto);
            aryPersonalId[i] = dto.getPersonalId();
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblAttendanceRate(aryLblAttendanceRate);
        vo.setAryLblAccomplish(aryLblAccomplish);
        vo.setAryLblGrant(aryLblGrant);
        vo.setAryLblGrantDate(aryLblGrantDate);
        vo.setAryLblGrantDays(aryLblGrantDays);
        vo.setAryLblNumberOfAttendance(aryLblNumberOfAttendance);
        vo.setAryPersonalId(aryPersonalId);
    }

    protected String getAttendanceRate(PaidHolidayDataGrantListDtoInterface dto, Format format) {
        return this.getAttendanceRate(dto.getAttendanceRate(), format);
    }

    protected String getAttendanceRate(Double attendanceRate, Format format) {
        if (attendanceRate == null) {
            return this.mospParams.getName("Hyphen");
        }
        return format.format(attendanceRate);
    }

    protected String getGrantDate(PaidHolidayDataGrantListDtoInterface dto) {
        if (dto.getGrantDate() == null) {
            return this.mospParams.getName("Hyphen");
        }
        boolean isTest = this.mospParams.isTestSupport();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStringDateAndDay(dto.getGrantDate()));
        if (isTest) {
            sb.append(this.mospParams.getName("FrontParentheses"));
            sb.append(this.getStringDateAndDay(dto.getFirstDate()));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(this.getStringDateAndDay(dto.getLastDate()));
            sb.append(this.mospParams.getName("BackParentheses"));
        }
        return sb.toString();
    }

    protected String getGrantDays(PaidHolidayDataGrantListDtoInterface dto) {
        return this.getGrantDays(dto.getGrantDays());
    }

    protected String getGrantDays(Double grantDays) {
        if (grantDays == null) {
            return this.mospParams.getName("Hyphen");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(grantDays.toString());
        sb.append(this.mospParams.getName("Day"));
        return sb.toString();
    }

    protected String getNumberOfAttendance(PaidHolidayDataGrantListDtoInterface dto) {
        if (!this.mospParams.isTestSupport() || dto.getWorkDays() == null || dto.getTotalWorkDays() == null) {
            return "";
        }
        return this.addParenthesis(this.getFraction(dto.getWorkDays(), dto.getTotalWorkDays()));
    }

    protected void addGrantMessage() {
        String rep = this.mospParams.getName("Giving");
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }
}

