/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.settings.vo.PaidHolidayReferenceVo;

public class PaidHolidayReferenceAction
extends TimeAction {
    public static final String CMD_SELECT_SHOW = "TM4431";
    public static final String CMD_SEARCH = "TM4432";
    public static final String CMD_RE_SHOW = "TM4433";
    public static double formerDate = 0.0;
    public static int formerTime = 0;
    public static double currentDate = 0.0;
    public static int currentTime = 0;
    public static double givingDate = 0.0;
    public static int givingTime = 0;
    public static double cancelDate = 0.0;
    public static int cancelTime = 0;
    public static double useDate = 0.0;
    public static int useTime = 0;

    public PaidHolidayReferenceAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PaidHolidayReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.show();
        }
    }

    protected void show() throws MospException {
        this.setDefaultValues();
        this.setDefaultList();
        this.setList();
    }

    protected void search() throws MospException {
        this.setList();
    }

    public void setDefaultValues() throws MospException {
        PaidHolidayReferenceVo vo = (PaidHolidayReferenceVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date systemDate = this.getSystemDate();
        if (personalId != null && !personalId.isEmpty()) {
            this.setEmployeeInfo(personalId, systemDate);
        } else {
            this.setEmployeeInfo(vo.getPersonalId(), systemDate);
        }
        vo.setPltSelectYear(String.valueOf(MonthUtility.getFiscalYear((Date)systemDate, (MospParams)this.mospParams)));
        vo.setAryPltSelectYear(this.getYearArray(MonthUtility.getFiscalYear((Date)systemDate, (MospParams)this.mospParams)));
        vo.setLblSystemDate(DateUtility.getStringJapaneseDate((Date)systemDate));
        vo.setTxtActiveDate(this.getStringDate(systemDate));
    }

    public void setDefaultList() throws MospException {
        PaidHolidayReferenceVo vo = (PaidHolidayReferenceVo)this.mospParams.getVo();
        PaidHolidayInfoReferenceBeanInterface getInfo = this.timeReference().paidHolidayInfo();
        Map map = getInfo.getPaidHolidayInfo(vo.getPersonalId(), this.getSystemDate());
        vo.setLblFormerDate(String.valueOf(map.get("FormerYearDay")));
        vo.setLblFormerTime(String.valueOf(map.get("FormerTime")));
        vo.setLblDate(String.valueOf(map.get("CurrentYearDay")));
        vo.setLblTime(String.valueOf(map.get("CurrentTime")));
        vo.setLblGivingDate(String.valueOf(map.get("GivingDay")));
        vo.setLblGivingTime(String.valueOf(map.get("GivingTime")));
        vo.setLblCancelDate(String.valueOf(map.get("CancelDay")));
        vo.setLblCancelTime(String.valueOf(map.get("CancelTime")));
        vo.setLblUseDate(String.valueOf(map.get("UseDay")));
        vo.setLblUseTime(String.valueOf(map.get("UseTime")));
    }

    protected Map<String, Object> getPaidHolidayMap(Date targetYearMonth) throws MospException {
        PaidHolidayReferenceVo vo = (PaidHolidayReferenceVo)this.mospParams.getVo();
        PaidHolidayInfoReferenceBeanInterface paidHolidayInfo = this.timeReference().paidHolidayInfo();
        int targetYear = DateUtility.getYear((Date)targetYearMonth);
        int targetMonth = DateUtility.getMonth((Date)targetYearMonth);
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffDtoInterface cutoffDto = cutoffUtil.getCutoffForPersonalId(vo.getPersonalId(), targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return Collections.emptyMap();
        }
        Date firstDate = cutoffUtil.getCutoffFirstDate(cutoffDto.getCutoffCode(), targetYear, targetMonth);
        Date lastDate = cutoffUtil.getCutoffLastDate(cutoffDto.getCutoffCode(), targetYear, targetMonth);
        return paidHolidayInfo.getPaidHolidayReferenceInfo(vo.getPersonalId(), firstDate, lastDate);
    }

    private String getViewYearMonth(Date targetYearMonth) {
        return this.getStringYear(targetYearMonth) + this.mospParams.getName("Year") + this.getStringMonth(targetYearMonth) + this.mospParams.getName("Month");
    }

    public void setList() throws MospException {
        PaidHolidayReferenceVo vo = (PaidHolidayReferenceVo)this.mospParams.getVo();
        vo.setTxtLblPreviousYear(vo.getPltSelectYear());
        int fiscalYear = MonthUtility.getFiscalYear((Date)this.getSystemDate(), (MospParams)this.mospParams);
        int viewPeriod = 0;
        int editActivateYear = this.getInt(vo.getPltSelectYear());
        Date startDate = MonthUtility.getFiscalYearFirstDate((int)editActivateYear, (MospParams)this.mospParams);
        if (editActivateYear < fiscalYear) {
            viewPeriod = 12;
        }
        if (editActivateYear > fiscalYear) {
            viewPeriod = 0;
        }
        if (editActivateYear == fiscalYear) {
            viewPeriod = DateUtility.getMonthDifference((Date)startDate, (Date)this.getSystemDate());
        }
        String[] aryLblViewYearMonth = new String[viewPeriod];
        String[] aryLblFormerDate = new String[viewPeriod];
        String[] aryLblFormerTime = new String[viewPeriod];
        String[] aryLblCurrentDate = new String[viewPeriod];
        String[] aryLblCurrentTime = new String[viewPeriod];
        String[] aryLblGivingDate = new String[viewPeriod];
        String[] aryLblGivingTime = new String[viewPeriod];
        String[] aryLblCancelDate = new String[viewPeriod];
        String[] aryLblCancelTime = new String[viewPeriod];
        String[] aryLblUseDate = new String[viewPeriod];
        String[] aryLblUseTime = new String[viewPeriod];
        Date targetYearMonth = startDate;
        for (int i = 0; i < viewPeriod; ++i) {
            Map map = this.getPaidHolidayMap(targetYearMonth);
            aryLblViewYearMonth[i] = this.getViewYearMonth(targetYearMonth);
            aryLblFormerDate[i] = map.get("FormerYearDay") == null ? "" : ((Double)map.get("FormerYearDay")).toString();
            aryLblFormerTime[i] = map.get("FormerTime") == null ? "" : ((Integer)map.get("FormerTime")).toString();
            aryLblCurrentDate[i] = map.get("CurrentYearDay") == null ? "" : ((Double)map.get("CurrentYearDay")).toString();
            aryLblCurrentTime[i] = map.get("CurrentTime") == null ? "" : ((Integer)map.get("CurrentTime")).toString();
            aryLblGivingDate[i] = map.get("GivingDay") == null ? "" : ((Double)map.get("GivingDay")).toString();
            aryLblGivingTime[i] = map.get("GivingTime") == null ? "" : ((Integer)map.get("GivingTime")).toString();
            aryLblCancelDate[i] = map.get("CancelDay") == null ? "" : ((Double)map.get("CancelDay")).toString();
            aryLblCancelTime[i] = map.get("CancelTime") == null ? "" : ((Integer)map.get("CancelTime")).toString();
            aryLblUseDate[i] = map.get("UseDay") == null ? "" : ((Double)map.get("UseDay")).toString();
            aryLblUseTime[i] = map.get("UseTime") == null ? "" : ((Integer)map.get("UseTime")).toString();
            targetYearMonth = DateUtility.addMonth((Date)targetYearMonth, (int)1);
        }
        vo.setAryLblViewYearMonth(aryLblViewYearMonth);
        vo.setAryLblFormerDate(aryLblFormerDate);
        vo.setAryLblFormerTime(aryLblFormerTime);
        vo.setAryLblDate(aryLblCurrentDate);
        vo.setAryLblTime(aryLblCurrentTime);
        vo.setAryLblGivingDate(aryLblGivingDate);
        vo.setAryLblGivingTime(aryLblGivingTime);
        vo.setAryLblCancelDate(aryLblCancelDate);
        vo.setAryLblCancelTime(aryLblCancelTime);
        vo.setAryLblUseDate(aryLblUseDate);
        vo.setAryLblUseTime(aryLblUseTime);
    }
}

