/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeRegistBeanInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.WorkTypeCardVo;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeCardAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5220";
    public static final String CMD_SELECT_SHOW = "TM5221";
    public static final String CMD_REGIST = "TM5225";
    public static final String CMD_DELETE = "TM5227";
    public static final String CMD_INSERT_MODE = "TM5271";
    public static final String CMD_ADD_MODE = "TM5273";

    protected BaseVo getSpecificVo() {
        return new WorkTypeCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void regist() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        this.restCheck();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.checkAutoBeforeOverWork();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        WorkTypeDtoInterface dto = regist.getInitDto();
        WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            this.setDtoFieldsItem(itemDto, item);
            itemRegist.insert(itemDto);
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        this.restCheck();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.checkAutoBeforeOverWork();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        WorkTypeDtoInterface dto = regist.getInitDto();
        WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            this.setDtoFieldsItem(itemDto, item);
            itemRegist.add(itemDto);
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        this.restCheck();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.checkAutoBeforeOverWork();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        WorkTypeDtoInterface dto = regist.getInitDto();
        WorkTypeItemDtoInterface itemDto = itemRegist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        for (String item : itemRegist.getCodesWorkTypeItem()) {
            this.setDtoFieldsItem(itemDto, item);
            itemRegist.update(itemDto);
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setEditUpdateMode(dto.getWorkTypeCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        WorkTypeRegistBeanInterface regist = this.time().workTypeRegist();
        WorkTypeDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        Date date = MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth()));
        regist.delete(dto);
        this.time().workTypeItemRegist().delete(vo.getTxtWorkTypeCode(), date);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        this.setDefaultValues();
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String workTypeCode, Date activateDate) throws MospException {
        WorkTypeReferenceBeanInterface reference = this.timeReference().workType();
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        WorkTypeDtoInterface dto = reference.findForKey(workTypeCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        for (String workTypeItemCode : itemRegist.getCodesWorkTypeItem()) {
            WorkTypeItemDtoInterface itemDto = this.timeReference().workTypeItem().findForKey(workTypeCode, activateDate, workTypeItemCode);
            if (itemDto == null) continue;
            this.setVoFieldsItem(itemDto, workTypeItemCode);
        }
        this.setEditUpdateMode(reference.getWorkTypeHistory(workTypeCode));
    }

    public void setDefaultValues() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        vo.setTxtWorkTypeCode("");
        vo.setTxtWorkTypeName("");
        vo.setTxtWorkTypeAbbr("");
        vo.setTxtWorkStartHour("");
        vo.setTxtWorkStartMinute("");
        vo.setTxtWorkEndHour("");
        vo.setTxtWorkEndMinute("");
        vo.setTxtWorkTimeHour("0");
        vo.setTxtWorkTimeMinute("0");
        vo.setTxtRestTimeHour("0");
        vo.setTxtRestTimeMinute("0");
        vo.setTxtRestStart1Hour("");
        vo.setTxtRestStart1Minute("");
        vo.setTxtRestEnd1Hour("");
        vo.setTxtRestEnd1Minute("");
        vo.setTxtRestStart2Hour("");
        vo.setTxtRestStart2Minute("");
        vo.setTxtRestEnd2Hour("");
        vo.setTxtRestEnd2Minute("");
        vo.setTxtRestStart3Hour("");
        vo.setTxtRestStart3Minute("");
        vo.setTxtRestEnd3Hour("");
        vo.setTxtRestEnd3Minute("");
        vo.setTxtRestStart4Hour("");
        vo.setTxtRestStart4Minute("");
        vo.setTxtRestEnd4Hour("");
        vo.setTxtRestEnd4Minute("");
        vo.setTxtFrontStartHour("");
        vo.setTxtFrontStartMinute("");
        vo.setTxtFrontEndHour("");
        vo.setTxtFrontEndMinute("");
        vo.setTxtBackStartHour("");
        vo.setTxtBackStartMinute("");
        vo.setTxtBackEndHour("");
        vo.setTxtBackEndMinute("");
        vo.setTxtOverBeforeHour("");
        vo.setTxtOverBeforeMinute("");
        vo.setTxtOverPerHour("");
        vo.setTxtOverPerMinute("");
        vo.setTxtOverRestHour("");
        vo.setTxtOverRestMinute("");
        vo.setTxtHalfRestHour("");
        vo.setTxtHalfRestMinute("");
        vo.setTxtHalfRestStartHour("");
        vo.setTxtHalfRestStartMinute("");
        vo.setTxtHalfRestEndHour("");
        vo.setTxtHalfRestEndMinute("");
        vo.setCkbDirectStart("0");
        vo.setCkbDirectEnd("0");
        vo.setPltMidnightRestExclusion(String.valueOf(1));
        vo.setTxtShort1StartHour("");
        vo.setTxtShort1StartMinute("");
        vo.setTxtShort1EndHour("");
        vo.setTxtShort1EndMinute("");
        vo.setPltShort1Type("");
        vo.setTxtShort2StartHour("");
        vo.setTxtShort2StartMinute("");
        vo.setTxtShort2EndHour("");
        vo.setTxtShort2EndMinute("");
        vo.setPltShort2Type("");
        WorkTypeItemRegistBeanInterface itemRegist = this.time().workTypeItemRegist();
        vo.setTmmWorkTypeItemId(new long[itemRegist.getCodesWorkTypeItem().length]);
        vo.setPltAutoBeforeOverWork(String.valueOf(1));
    }

    protected void setDtoFields(WorkTypeDtoInterface dto) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        dto.setTmmWorkTypeId(vo.getRecordId());
        dto.setActivateDate(MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth())));
        dto.setWorkTypeCode(vo.getTxtWorkTypeCode());
        dto.setWorkTypeName(vo.getTxtWorkTypeName());
        dto.setWorkTypeAbbr(vo.getTxtWorkTypeAbbr());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(WorkTypeDtoInterface dto) {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getTmmWorkTypeId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtWorkTypeCode(dto.getWorkTypeCode());
        vo.setTxtWorkTypeName(dto.getWorkTypeName());
        vo.setTxtWorkTypeAbbr(dto.getWorkTypeAbbr());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected void setDtoFieldsItem(WorkTypeItemDtoInterface dto, String itemType) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        dto.setActivateDate(MonthUtility.getYearMonthDate((int)this.getInt(vo.getTxtEditActivateYear()), (int)this.getInt(vo.getTxtEditActivateMonth())));
        dto.setWorkTypeCode(vo.getTxtWorkTypeCode());
        dto.setPreliminary("");
        if (itemType.equals("WorkStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(0));
            dto.setWorkTypeItemCode("WorkStart");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtWorkStartHour(), vo.getTxtWorkStartMinute()));
        } else if (itemType.equals("WorkEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(1));
            dto.setWorkTypeItemCode("WorkEnd");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtWorkEndHour(), vo.getTxtWorkEndMinute()));
        } else if (itemType.equals("WorkTime")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(2));
            dto.setWorkTypeItemCode("WorkTime");
            dto.setWorkTypeItemValue(this.getTimestamp(this.getWorkTime()));
        } else if (itemType.equals("RestTime")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(3));
            dto.setWorkTypeItemCode("RestTime");
            dto.setWorkTypeItemValue(this.getTimestamp(this.getRestTime()));
        } else if (itemType.equals("RestStart1")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(4));
            dto.setWorkTypeItemCode("RestStart1");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestStart1Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestStart1Hour(), vo.getTxtRestStart1Minute()));
            }
        } else if (itemType.equals("RestEnd1")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(5));
            dto.setWorkTypeItemCode("RestEnd1");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestEnd1Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestEnd1Hour(), vo.getTxtRestEnd1Minute()));
            }
        } else if (itemType.equals("RestStart2")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(6));
            dto.setWorkTypeItemCode("RestStart2");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestStart2Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestStart2Hour(), vo.getTxtRestStart2Minute()));
            }
        } else if (itemType.equals("RestEnd2")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(7));
            dto.setWorkTypeItemCode("RestEnd2");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestEnd2Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestEnd2Hour(), vo.getTxtRestEnd2Minute()));
            }
        } else if (itemType.equals("RestStart3")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(8));
            dto.setWorkTypeItemCode("RestStart3");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestStart3Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestStart3Hour(), vo.getTxtRestStart3Minute()));
            }
        } else if (itemType.equals("RestEnd3")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(9));
            dto.setWorkTypeItemCode("RestEnd3");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestEnd3Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestEnd3Hour(), vo.getTxtRestEnd3Minute()));
            }
        } else if (itemType.equals("RestStart4")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(10));
            dto.setWorkTypeItemCode("RestStart4");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestStart4Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestStart4Hour(), vo.getTxtRestStart4Minute()));
            }
        } else if (itemType.equals("RestEnd4")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(11));
            dto.setWorkTypeItemCode("RestEnd4");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtRestEnd4Hour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtRestEnd4Hour(), vo.getTxtRestEnd4Minute()));
            }
        } else if (itemType.equals("FrontStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(12));
            dto.setWorkTypeItemCode("FrontStart");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtFrontStartHour(), vo.getTxtFrontStartMinute()));
        } else if (itemType.equals("FrontEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(13));
            dto.setWorkTypeItemCode("FrontEnd");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtFrontEndHour(), vo.getTxtFrontEndMinute()));
        } else if (itemType.equals("BackStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(14));
            dto.setWorkTypeItemCode("BackStart");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtBackStartHour(), vo.getTxtBackStartMinute()));
        } else if (itemType.equals("BackEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(15));
            dto.setWorkTypeItemCode("BackEnd");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtBackEndHour(), vo.getTxtBackEndMinute()));
        } else if (itemType.equals("OverBefore")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(16));
            dto.setWorkTypeItemCode("OverBefore");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtOverBeforeHour(), vo.getTxtOverBeforeMinute()));
        } else if (itemType.equals("OverPer")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(17));
            dto.setWorkTypeItemCode("OverPer");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtOverPerHour(), vo.getTxtOverPerMinute()));
        } else if (itemType.equals("OverRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(18));
            dto.setWorkTypeItemCode("OverRest");
            dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtOverRestHour(), vo.getTxtOverRestMinute()));
        } else if (itemType.equals("HalfRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(19));
            dto.setWorkTypeItemCode("HalfRest");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtHalfRestHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtHalfRestHour(), vo.getTxtHalfRestMinute()));
            }
        } else if (itemType.equals("HalfRestStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(20));
            dto.setWorkTypeItemCode("HalfRestStart");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtHalfRestStartHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtHalfRestStartHour(), vo.getTxtHalfRestStartMinute()));
            }
        } else if (itemType.equals("HalfRestEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(21));
            dto.setWorkTypeItemCode("HalfRestEnd");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtHalfRestEndHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtHalfRestEndHour(), vo.getTxtHalfRestEndMinute()));
            }
        } else if (itemType.equals("DirectStart")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(22));
            dto.setWorkTypeItemCode("DirectStart");
            dto.setPreliminary(vo.getCkbDirectStart());
        } else if (itemType.equals("DirectEnd")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(23));
            dto.setWorkTypeItemCode("DirectEnd");
            dto.setPreliminary(vo.getCkbDirectEnd());
        } else if (itemType.equals("ExcludeNightRest")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(24));
            dto.setWorkTypeItemCode("ExcludeNightRest");
            dto.setPreliminary(vo.getPltMidnightRestExclusion());
        } else if (itemType.equals("Short1Start")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(25));
            dto.setWorkTypeItemCode("Short1Start");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtShort1StartHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtShort1StartHour(), vo.getTxtShort1StartMinute()));
                dto.setPreliminary(vo.getPltShort1Type());
            }
        } else if (itemType.equals("Short1End")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(26));
            dto.setWorkTypeItemCode("Short1End");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtShort1EndHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtShort1EndHour(), vo.getTxtShort1EndMinute()));
            }
        } else if (itemType.equals("Short2Start")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(27));
            dto.setWorkTypeItemCode("Short2Start");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtShort2StartHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtShort2StartHour(), vo.getTxtShort2StartMinute()));
                dto.setPreliminary(vo.getPltShort2Type());
            }
        } else if (itemType.equals("Short2End")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(28));
            dto.setWorkTypeItemCode("Short2End");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getTxtShort2EndHour().isEmpty()) {
                dto.setWorkTypeItemValue(this.getDefaultTime(vo.getTxtShort2EndHour(), vo.getTxtShort2EndMinute()));
            }
        } else if (itemType.equals("AutoBefOverWork")) {
            dto.setTmmWorkTypeItemId(vo.getTmmWorkTypeItemId(29));
            dto.setWorkTypeItemCode("AutoBefOverWork");
            dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
            if (!vo.getPltAutoBeforeOverWork().isEmpty()) {
                dto.setPreliminary(vo.getPltAutoBeforeOverWork());
            }
        }
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFieldsItem(WorkTypeItemDtoInterface dto, String itemType) throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (itemType.equals("WorkStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 0);
            vo.setTxtWorkStartHour(DateUtility.getStringHour((Date)dto.getWorkTypeItemValue()));
            vo.setTxtWorkStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("WorkEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 1);
            vo.setTxtWorkEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtWorkEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("WorkTime")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 2);
            vo.setTxtWorkTimeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtWorkTimeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestTime")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 3);
            vo.setTxtRestTimeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestTimeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart1")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 4);
            vo.setTxtRestStart1Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart1Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd1")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 5);
            vo.setTxtRestEnd1Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd1Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart2")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 6);
            vo.setTxtRestStart2Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart2Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd2")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 7);
            vo.setTxtRestEnd2Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd2Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart3")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 8);
            vo.setTxtRestStart3Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart3Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd3")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 9);
            vo.setTxtRestEnd3Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd3Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestStart4")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 10);
            vo.setTxtRestStart4Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestStart4Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("RestEnd4")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 11);
            vo.setTxtRestEnd4Hour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtRestEnd4Minute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("FrontStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 12);
            vo.setTxtFrontStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtFrontStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("FrontEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 13);
            vo.setTxtFrontEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtFrontEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("BackStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 14);
            vo.setTxtBackStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtBackStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("BackEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 15);
            vo.setTxtBackEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtBackEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverBefore")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 16);
            vo.setTxtOverBeforeHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverBeforeMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverPer")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 17);
            vo.setTxtOverPerHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverPerMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("OverRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 18);
            vo.setTxtOverRestHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtOverRestMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 19);
            vo.setTxtHalfRestHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRestStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 20);
            vo.setTxtHalfRestStartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestStartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("HalfRestEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 21);
            vo.setTxtHalfRestEndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtHalfRestEndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("DirectStart")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 22);
            vo.setCkbDirectStart(dto.getPreliminary());
        } else if (itemType.equals("DirectEnd")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 23);
            vo.setCkbDirectEnd(dto.getPreliminary());
        } else if (itemType.equals("ExcludeNightRest")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 24);
            vo.setPltMidnightRestExclusion(dto.getPreliminary());
        } else if (itemType.equals("Short1Start")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 25);
            vo.setTxtShort1StartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort1StartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
            vo.setPltShort1Type(dto.getPreliminary());
        } else if (itemType.equals("Short1End")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 26);
            vo.setTxtShort1EndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort1EndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("Short2Start")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 27);
            vo.setTxtShort2StartHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort2StartMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
            vo.setPltShort2Type(dto.getPreliminary());
        } else if (itemType.equals("Short2End")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 28);
            vo.setTxtShort2EndHour(this.getWorkTypeItemHour(dto.getWorkTypeItemValue()));
            vo.setTxtShort2EndMinute(DateUtility.getStringMinute((Date)dto.getWorkTypeItemValue()));
        } else if (itemType.equals("AutoBefOverWork")) {
            vo.setTmmWorkTypeItemId(dto.getTmmWorkTypeItemId(), 29);
            vo.setPltAutoBeforeOverWork(dto.getPreliminary());
        }
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected int getWorkTime() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        int minute = this.getMinute(vo.getTxtWorkStartHour(), vo.getTxtWorkStartMinute(), vo.getTxtWorkEndHour(), vo.getTxtWorkEndMinute()) - this.getRestTime();
        if (minute > 0) {
            return minute;
        }
        return 0;
    }

    protected int getRestTime() {
        return this.getRest1Time() + this.getRest2Time() + this.getRest3Time() + this.getRest4Time();
    }

    protected int getRest1Time() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getTxtRestStart1Hour().isEmpty() || vo.getTxtRestStart1Minute().isEmpty() || vo.getTxtRestEnd1Hour().isEmpty() || vo.getTxtRestEnd1Minute().isEmpty()) {
            return 0;
        }
        return this.getMinute(vo.getTxtRestStart1Hour(), vo.getTxtRestStart1Minute(), vo.getTxtRestEnd1Hour(), vo.getTxtRestEnd1Minute());
    }

    protected int getRest2Time() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getTxtRestStart2Hour().isEmpty() || vo.getTxtRestStart2Minute().isEmpty() || vo.getTxtRestEnd2Hour().isEmpty() || vo.getTxtRestEnd2Minute().isEmpty()) {
            return 0;
        }
        return this.getMinute(vo.getTxtRestStart2Hour(), vo.getTxtRestStart2Minute(), vo.getTxtRestEnd2Hour(), vo.getTxtRestEnd2Minute());
    }

    protected int getRest3Time() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getTxtRestStart3Hour().isEmpty() || vo.getTxtRestStart3Minute().isEmpty() || vo.getTxtRestEnd3Hour().isEmpty() || vo.getTxtRestEnd3Minute().isEmpty()) {
            return 0;
        }
        return this.getMinute(vo.getTxtRestStart3Hour(), vo.getTxtRestStart3Minute(), vo.getTxtRestEnd3Hour(), vo.getTxtRestEnd3Minute());
    }

    protected int getRest4Time() {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getTxtRestStart4Hour().isEmpty() || vo.getTxtRestStart4Minute().isEmpty() || vo.getTxtRestEnd4Hour().isEmpty() || vo.getTxtRestEnd4Minute().isEmpty()) {
            return 0;
        }
        return this.getMinute(vo.getTxtRestStart4Hour(), vo.getTxtRestStart4Minute(), vo.getTxtRestEnd4Hour(), vo.getTxtRestEnd4Minute());
    }

    protected void restCheck() throws MospException {
        boolean isShort2Set;
        int i;
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        int startTimeHour = this.getInt(vo.getTxtWorkStartHour());
        int startTimeMinute = this.getInt(vo.getTxtWorkStartMinute());
        int endTimeHour = this.getInt(vo.getTxtWorkEndHour());
        int endTimeMinute = this.getInt(vo.getTxtWorkEndMinute());
        int restStartTime1Hour = this.getInt(vo.getTxtRestStart1Hour());
        int restStartTime1Minute = this.getInt(vo.getTxtRestStart1Minute());
        int restEndTime1Hour = this.getInt(vo.getTxtRestEnd1Hour());
        int restEndTime1Minute = this.getInt(vo.getTxtRestEnd1Minute());
        int restStartTime2Hour = this.getInt(vo.getTxtRestStart2Hour());
        int restStartTime2Minute = this.getInt(vo.getTxtRestStart2Minute());
        int restEndTime2Hour = this.getInt(vo.getTxtRestEnd2Hour());
        int restEndTime2Minute = this.getInt(vo.getTxtRestEnd2Minute());
        int restStartTime3Hour = this.getInt(vo.getTxtRestStart3Hour());
        int restStartTime3Minute = this.getInt(vo.getTxtRestStart3Minute());
        int restEndTime3Hour = this.getInt(vo.getTxtRestEnd3Hour());
        int restEndTime3Minute = this.getInt(vo.getTxtRestEnd3Minute());
        int restStartTime4Hour = this.getInt(vo.getTxtRestStart4Hour());
        int restStartTime4Minute = this.getInt(vo.getTxtRestStart4Minute());
        int restEndTime4Hour = this.getInt(vo.getTxtRestEnd4Hour());
        int restEndTime4Minute = this.getInt(vo.getTxtRestEnd4Minute());
        int frontStartHour = this.getInt(vo.getTxtFrontStartHour());
        int frontStartMinute = this.getInt(vo.getTxtFrontStartMinute());
        int frontEndHour = this.getInt(vo.getTxtFrontEndHour());
        int frontEndMinute = this.getInt(vo.getTxtFrontEndMinute());
        int backStartHour = this.getInt(vo.getTxtBackStartHour());
        int backStartMinute = this.getInt(vo.getTxtBackStartMinute());
        int backEndHour = this.getInt(vo.getTxtBackEndHour());
        int backEndMinute = this.getInt(vo.getTxtBackEndMinute());
        int[] aryStartTimeHour = new int[]{restStartTime1Hour, restStartTime2Hour, restStartTime3Hour, restStartTime4Hour, frontStartHour, backStartHour};
        int[] aryStartTimeMinute = new int[]{restStartTime1Minute, restStartTime2Minute, restStartTime3Minute, restStartTime4Minute, frontStartMinute, backStartMinute};
        int[] aryEndTimeHour = new int[]{restEndTime1Hour, restEndTime2Hour, restEndTime3Hour, restEndTime4Hour, frontEndHour, backEndHour};
        int[] aryEndTimeMinute = new int[]{restEndTime1Minute, restEndTime2Minute, restEndTime3Minute, restEndTime4Minute, frontEndMinute, backEndMinute};
        Date startTime = TimeUtility.getDateTime((int)startTimeHour, (int)startTimeMinute);
        Date endTime = TimeUtility.getDateTime((int)endTimeHour, (int)endTimeMinute);
        String errMes = this.mospParams.getName("RestTime", new String[]{"Time"});
        if (!endTime.after(startTime)) {
            this.mospParams.addErrorMessage("TMW0236", new String[0]);
            return;
        }
        if (startTimeHour >= 24) {
            String[] rep = new String[]{this.mospParams.getName("StartWork", new String[]{"Moment"}), 24 + this.mospParams.getName("Hour", new String[]{"From", "Ahead", "Of", "Time"})};
            this.mospParams.addErrorMessage("PFW0105", rep);
            return;
        }
        for (i = 0; i < aryStartTimeHour.length; ++i) {
            if (aryStartTimeHour[i] == 0 && aryStartTimeMinute[i] == 0 && aryEndTimeHour[i] == 0 && aryEndTimeMinute[i] == 0) continue;
            if (startTimeHour > aryStartTimeHour[i]) {
                this.mospParams.addErrorMessage("TMW0237", new String[]{errMes});
                return;
            }
            if (startTimeHour == aryStartTimeHour[i] && startTimeMinute > aryStartTimeMinute[i]) {
                this.mospParams.addErrorMessage("TMW0237", new String[]{errMes});
                return;
            }
            if (endTimeHour < aryEndTimeHour[i]) {
                this.mospParams.addErrorMessage("TMW0237", new String[]{errMes});
                return;
            }
            if (endTimeHour != aryEndTimeHour[i] || endTimeMinute >= aryEndTimeMinute[i]) continue;
            this.mospParams.addErrorMessage("TMW0237", new String[]{errMes});
            return;
        }
        for (i = 0; i < aryStartTimeHour.length - 2; ++i) {
            if (aryStartTimeHour[i] == 0 && aryStartTimeMinute[i] == 0 && aryEndTimeHour[i] == 0 && aryEndTimeMinute[i] == 0) continue;
            for (int j = i; j < aryStartTimeHour.length - 2; ++j) {
                if (i == j || aryStartTimeHour[j] == 0 && aryStartTimeMinute[j] == 0 && aryEndTimeHour[j] == 0 && aryEndTimeMinute[j] == 0) continue;
                if (aryEndTimeHour[i] > aryStartTimeHour[j]) {
                    this.mospParams.addErrorMessage("TMW0238", new String[]{errMes});
                    return;
                }
                if (aryEndTimeHour[i] != aryStartTimeHour[j] || aryEndTimeMinute[i] <= aryStartTimeMinute[j]) continue;
                this.mospParams.addErrorMessage("TMW0238", new String[]{errMes});
                return;
            }
        }
        Date defaultTime = DateUtility.getDefaultTime();
        int short1StartHour = this.getInt(vo.getTxtShort1StartHour());
        int short1StartMinute = this.getInt(vo.getTxtShort1StartMinute());
        int short1EndHour = this.getInt(vo.getTxtShort1EndHour());
        int short1EndMinute = this.getInt(vo.getTxtShort1EndMinute());
        int short2StartHour = this.getInt(vo.getTxtShort2StartHour());
        int short2StartMinute = this.getInt(vo.getTxtShort2StartMinute());
        int short2EndHour = this.getInt(vo.getTxtShort2EndHour());
        int short2EndMinute = this.getInt(vo.getTxtShort2EndMinute());
        Date short1StartTime = TimeUtility.getDateTime((int)short1StartHour, (int)short1StartMinute);
        Date short1EndTime = TimeUtility.getDateTime((int)short1EndHour, (int)short1EndMinute);
        Date short2StartTime = TimeUtility.getDateTime((int)short2StartHour, (int)short2StartMinute);
        Date short2EndTime = TimeUtility.getDateTime((int)short2EndHour, (int)short2EndMinute);
        boolean isShort1Set = !short1StartTime.equals(defaultTime) || !short1EndTime.equals(defaultTime);
        boolean bl = isShort2Set = !short2StartTime.equals(defaultTime) || !short2EndTime.equals(defaultTime);
        if (isShort1Set) {
            if (!short1StartTime.equals(startTime)) {
                TimeMessageUtility.addErrorShort1TimeBoundary((MospParams)this.mospParams);
            }
            if (short1EndTime.after(endTime)) {
                TimeMessageUtility.addErrorShort1OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short1EndTime.after(short1StartTime)) {
                TimeMessageUtility.addErrorShort1EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort2Set) {
            if (!short2EndTime.equals(endTime)) {
                TimeMessageUtility.addErrorShort2TimeBoundary((MospParams)this.mospParams);
            }
            if (short2StartTime.before(startTime)) {
                TimeMessageUtility.addErrorShort2OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short2EndTime.after(short2StartTime)) {
                TimeMessageUtility.addErrorShort2EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort1Set && isShort2Set && !vo.getPltShort1Type().equals("0") && vo.getPltShort2Type().equals("0")) {
            TimeMessageUtility.addErrorShortTypePair((MospParams)this.mospParams);
        }
    }

    protected void checkAutoBeforeOverWork() throws MospException {
        WorkTypeCardVo vo = (WorkTypeCardVo)this.mospParams.getVo();
        if (vo.getPltAutoBeforeOverWork().equals(String.valueOf(1))) {
            return;
        }
        int short1StartHour = this.getInt(vo.getTxtShort1StartHour());
        int short1StartMinute = this.getInt(vo.getTxtShort1StartMinute());
        int short1EndHour = this.getInt(vo.getTxtShort1EndHour());
        int short1EndMinute = this.getInt(vo.getTxtShort1EndMinute());
        if (short1StartHour == 0 && short1StartMinute == 0 && short1EndHour == 0 && short1EndMinute == 0) {
            return;
        }
        if (vo.getPltShort1Type().equals(String.valueOf(0))) {
            return;
        }
        TimeMessageUtility.addErrorAnotherItemInvalid((MospParams)this.mospParams);
    }

    protected Date getDefaultTime(String hour, String minute) throws MospException {
        AttendanceCalcBeanInterface calc = this.time().attendanceCalc();
        Date defaultDate = DateUtility.getDefaultTime();
        return calc.getAttendanceTime(defaultDate, hour, minute);
    }

    private int getMinute(String startHour, String startMinute, String endHour, String endMinute) {
        return this.getMinute(Integer.parseInt(startHour), Integer.parseInt(startMinute), Integer.parseInt(endHour), Integer.parseInt(endMinute));
    }

    private int getMinute(int startHour, int startMinute, int endHour, int endMinute) {
        return this.getMinute(startHour * 60 + startMinute, endHour * 60 + endMinute);
    }

    private int getMinute(int startMinute, int endMinute) {
        int minute = endMinute - startMinute;
        if (minute >= 0) {
            return minute;
        }
        return 0;
    }

    private Date getTimestamp(int minute) throws MospException {
        return DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)minute);
    }

    private String getWorkTypeItemHour(Date time) throws MospException {
        return DateUtility.getStringHour((Date)time, (Date)DateUtility.getDefaultTime());
    }

    protected int getInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

