/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.settings.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.WorkTypePatternSearchBeanInterface;
import jp.mosp.time.comparator.settings.WorkTypePatternCodeComparator;
import jp.mosp.time.dto.settings.WorkTypePatternDtoInterface;
import jp.mosp.time.settings.base.TimeSettingAction;
import jp.mosp.time.settings.vo.WorkTypePatternListVo;

public class WorkTypePatternListAction
extends TimeSettingAction {
    public static final String CMD_SHOW = "TM5810";
    public static final String CMD_SEARCH = "TM5812";
    public static final String CMD_RE_SHOW = "TM5813";
    public static final String CMD_SORT = "TM5818";
    public static final String CMD_PAGE = "TM5819";

    public WorkTypePatternListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new WorkTypePatternListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() {
        WorkTypePatternListVo vo = (WorkTypePatternListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(WorkTypePatternCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        WorkTypePatternListVo vo = (WorkTypePatternListVo)this.mospParams.getVo();
        WorkTypePatternSearchBeanInterface search = this.timeReference().workTypePatternSearch();
        Date activeDate = MonthUtility.getYearMonthTargetDate((int)this.getInt(vo.getTxtSearchActivateYear()), (int)this.getInt(vo.getTxtSearchActivateMonth()), (MospParams)this.mospParams);
        search.setActivateDate(activeDate);
        search.setPatternCode(vo.getTxtSearchPatternCode());
        search.setPatternName(vo.getTxtSearchPatternName());
        search.setPatternAbbr(vo.getTxtSearchPatternAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(WorkTypePatternCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void setDefaultValues() {
        WorkTypePatternListVo vo = (WorkTypePatternListVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtSearchActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtSearchActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtSearchActivateDay(DateUtility.getStringDay((Date)date));
        vo.setTxtSearchPatternCode("");
        vo.setTxtSearchPatternName("");
        vo.setTxtSearchPatternAbbr("");
        vo.setPltSearchInactivate(String.valueOf(0));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        WorkTypePatternListVo vo = (WorkTypePatternListVo)this.mospParams.getVo();
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblActivateMonth = new String[list.size()];
        String[] aryLblPatternCode = new String[list.size()];
        String[] aryLblPatternName = new String[list.size()];
        String[] aryLblPatternAbbr = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkTypePatternDtoInterface dto = (WorkTypePatternDtoInterface)list.get(i);
            aryLblActivateDate[i] = DateUtility.getStringDate((Date)dto.getActivateDate());
            aryLblActivateMonth[i] = DateUtility.getStringYearMonth((Date)dto.getActivateDate());
            aryLblPatternCode[i] = dto.getPatternCode();
            aryLblPatternName[i] = dto.getPatternName();
            aryLblPatternAbbr[i] = dto.getPatternAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblActivateMonth(aryLblActivateMonth);
        vo.setAryLblPatternCode(aryLblPatternCode);
        vo.setAryLblPatternName(aryLblPatternName);
        vo.setAryLblPatternAbbr(aryLblPatternAbbr);
        vo.setAryLblInactivate(aryLblInactivate);
    }
}

