/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.WorkTypeEntity;

public class AttendanceUtility {
    private AttendanceUtility() {
    }

    public static Date getStartTime(ApplicationEntity applicationEntity, RequestEntity requestEntity, WorkTypeEntity workTypeEntity, Date recordTime) throws MospException {
        Date scheduledTime = workTypeEntity.getStartTime(requestEntity);
        boolean isAutoBeforeOverwork = false;
        WorkTypeItemDtoInterface workTypeItemDto = workTypeEntity.getWorkTypeItem("AutoBefOverWork");
        if (workTypeItemDto != null) {
            isAutoBeforeOverwork = workTypeItemDto.getPreliminary().equals(String.valueOf(String.valueOf(0)));
        }
        int overtimeMinutesBeforeWork = requestEntity.getOvertimeMinutesBeforeWork(false);
        if (isAutoBeforeOverwork) {
            int beforeOvertimeInt = DateUtility.getHour((Date)recordTime) * 60;
            int scheduledTimeInt = DateUtility.getHour((Date)scheduledTime) * 60;
            overtimeMinutesBeforeWork = scheduledTimeInt - beforeOvertimeInt;
        }
        Date overScheduledTime = DateUtility.addMinute((Date)scheduledTime, (int)(-overtimeMinutesBeforeWork));
        if (workTypeEntity.isDirectStart()) {
            return scheduledTime;
        }
        if (recordTime.compareTo(overScheduledTime) > 0) {
            if (applicationEntity.useScheduledTime() && !isAutoBeforeOverwork) {
                return applicationEntity.getRoundedStartTime(recordTime);
            }
            return applicationEntity.getRoundedActualStartTime(recordTime);
        }
        if (applicationEntity.useScheduledTime() && !isAutoBeforeOverwork) {
            return overScheduledTime;
        }
        return applicationEntity.getRoundedActualStartTime(recordTime);
    }
}

