/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeUtility {
    public static final int DATE_UNLIMITED_YEAR = 5874897;
    public static final int DATE_YEAR_LAST_MONTH = 31;
    public static final String MAIN_MENU_TIME_INMPUT = "menuTimeInput";
    public static final String MENU_OVERTIME_REQUEST = "OvertimeRequest";
    public static final String MENU_HOLIDAY_REQUEST = "HolidayRequest";
    public static final String MENU_WORK_ON_HOLIDAY_REQUEST = "WorkOnHolidayRequest";
    public static final String MENU_SUB_HOLIDAY_REQUEST = "SubHolidayRequest";
    public static final String MENU_WORK_TYPE_CHANGE_REQUEST = "WorkTypeChangeRequest";
    public static final String MENU_DIFFERENCE_REQUEST = "DifferenceRequest";
    public static final String MENU_CANCELLATION_REQUEST = "CancellationRequest";
    public static final int MILLI_SEC_PER_HOUR = 3600000;

    private TimeUtility() {
    }

    public static Date getDateTime(Date date, Date time) throws MospException {
        if (time == null) {
            return null;
        }
        int hour = DateUtility.getHour((Date)time, (Date)DateUtility.getDefaultTime());
        int minute = DateUtility.getMinute((Date)time);
        return TimeUtility.getDateTime((Date)date, (int)hour, (int)minute);
    }

    public static Date getDateTime(int hour, int minute) throws MospException {
        return TimeUtility.getDateTime((Date)DateUtility.getDefaultTime(), (int)hour, (int)minute);
    }

    public static Date getDateTime(Date date, int hour, int minute) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(11, hour);
        cal.set(12, minute);
        return cal.getTime();
    }

    public static int getMinutes(Date targetTime) throws MospException {
        return TimeUtility.getMinutes((Date)targetTime, (Date)DateUtility.getDefaultTime());
    }

    public static int getMinutes(Date targetTime, Date targetDate) throws MospException {
        if (targetTime == null || targetDate == null) {
            return 0;
        }
        long defference = targetTime.getTime() - targetDate.getTime();
        return (int)(defference / 60000L);
    }

    public static Date getCutoffFirstDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    public static Date getCutoffLastDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getYearMonthTermLastDate((int)targetYear, (int)targetMonth, (int)cutoffDay);
    }

    protected static int adjustCutoffDay(int cutoffDay) {
        if (cutoffDay == 0) {
            return cutoffDay;
        }
        if (cutoffDay > 15) {
            return cutoffDay;
        }
        return cutoffDay + 100;
    }

    public static Date getCutoffTermTargetDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public static Date getCutoffCalculationDate(int cutoffDate, int targetYear, int targetMonth) throws MospException {
        return TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth);
    }

    public static Date getCutoffMonth(int cutoffDate, Date targetDate) throws MospException {
        int cutoffDay = TimeUtility.adjustCutoffDay((int)cutoffDate);
        return MonthUtility.getTargetYearMonth((Date)targetDate, (int)cutoffDay);
    }

    public static Set<String> getTimeFunctionSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        set.add("4");
        set.add("5");
        set.add("6");
        set.add("7");
        return set;
    }

    public static Date getUnlimitedDate() throws MospException {
        return DateUtility.getDate((int)5874897, (int)12, (int)31);
    }

    public static List<Date> getDateList(Date firstDate, Date lastDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        if (firstDate == null || lastDate == null) {
            return list;
        }
        Date date = (Date)firstDate.clone();
        while (!date.after(lastDate)) {
            list.add(date);
            date = DateUtility.addDay((Date)date, (int)1);
        }
        return list;
    }

    public static int getRoundMinute(int time, int type, int unit) {
        if (time <= 0 || type == 0 || unit <= 0) {
            return time;
        }
        if (type == 1 || type == 2) {
            int remainder = time % unit;
            if (remainder == 0) {
                return time;
            }
            int rounded = time - remainder;
            if (type == 1) {
                return rounded;
            }
            if (type == 2) {
                return rounded + unit;
            }
        }
        return time;
    }

    public static String getTimeDelimiterSeparated(int minute, String delimiter) {
        int h = minute / 60;
        int m = minute % 60;
        StringBuffer sb = new StringBuffer();
        sb.append(h);
        sb.append(delimiter);
        if (m < 10) {
            sb.append(0);
        }
        sb.append(m);
        return sb.toString();
    }

    public static boolean isPrescribedHoliday(String workTypeCode) {
        return "prescribed_holiday".equals(workTypeCode);
    }

    public static boolean isLegalHoliday(String workTypeCode) {
        return "legal_holiday".equals(workTypeCode);
    }

    public static boolean isHoliday(String workTypeCode) {
        return TimeUtility.isPrescribedHoliday((String)workTypeCode) || TimeUtility.isLegalHoliday((String)workTypeCode);
    }

    public static boolean isWorkOnPrescribedHoliday(String workTypeCode) {
        return "work_on_prescribed".equals(workTypeCode);
    }

    public static boolean isWorkOnLegalHoliday(String workTypeCode) {
        return "work_on_legal".equals(workTypeCode);
    }

    public static boolean isOvertimeRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isOvertimeRequestAvailable(MospParams mospParams) {
        return PlatformUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"OvertimeRequest");
    }

    public static boolean isHolidayRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isHolidayRequestAvailable(MospParams mospParams) {
        return PlatformUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"HolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isWorkOnHolidayRequestAvailable(MospParams mospParams) {
        return PlatformUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkOnHolidayRequest");
    }

    public static boolean isSubHolidayRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isSubHolidayRequestAvailable(MospParams mospParams) {
        return PlatformUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"SubHolidayRequest");
    }

    public static boolean isWorkTypeChangeRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isWorkTypeChangeRequestAvailable(MospParams mospParams) {
        return PlatformUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuTimeInput", (String)"WorkTypeChangeRequest");
    }

    public static boolean isDifferenceRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"DifferenceRequest");
    }

    public static boolean isCancellationRequestValid(MospParams mospParams) {
        return PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)"menuTimeInput", (String)"CancellationRequest");
    }

    public static double getRoundHalfUp2(double value) {
        BigDecimal bi = new BigDecimal(String.valueOf(value));
        return bi.setScale(2, 4).doubleValue();
    }

    public static double getMinuteToHour(double minutes) {
        double dotMinutes = minutes / 60.0;
        return TimeUtility.getRoundHalfUp2((double)dotMinutes);
    }

    public static boolean isPaidHolidayRequest(HolidayRequestDtoInterface dto) {
        if (dto.getHolidayType1() != 1) {
            return false;
        }
        return Integer.toString(1).equals(dto.getHolidayType2());
    }

    public static boolean isStockHolidayRequest(HolidayRequestDtoInterface dto) {
        if (dto.getHolidayType1() != 1) {
            return false;
        }
        return Integer.toString(2).equals(dto.getHolidayType2());
    }

    public static boolean isHolidayTimesHalf(double holidayTimes) {
        return holidayTimes == 0.5;
    }

    public static Date getDefaultTime(String hour, String minute) throws MospException {
        Date defaultDate = DateUtility.getDefaultTime();
        StringBuffer sb = new StringBuffer();
        if (hour.length() == 1) {
            sb.append(0);
        }
        sb.append(hour);
        if (minute.length() == 1) {
            sb.append(0);
        }
        sb.append(minute);
        long attendanceTime = defaultDate.getTime();
        attendanceTime += (long)(Integer.valueOf(hour) * 3600000);
        return new Date(attendanceTime += (long)(Integer.valueOf(minute) * 3600000 / 60));
    }
}

