
function savedVinSet(answer){
    // セットが保存された後の処理
    
    // セット名ポップアップメニューを更新
    getSetnames();
    
    // ポップアップメニューが default では空白なので以下も空白にする
    elmFor("setMenuContents").innerHTML = "";
}
function saveVinSet(){
    // 一括テンプレートをサーバへ保存
    // 一括メニュー・ポップアップが表示されていれば選択された一括メニュー項目を取得
    var title = elmFor("setNameF").value;
    if (title.length == 0){
        alert("セット名を入れてから登録してください");
        return;
    } else if (selectedGroupMenu()){
        if (!confirm("セット登録をこの内容で上書きしていいですか？")) return;
    }
    
    // 現在表示されているレコード・セットをテンプレートとして登録
    var args = new Object();
    args.owner = owner();
    args.title = title;
    args.records = archives();
    
    NRCallVin("PUT_TREATMENT_GROUP", args, savedVinSet);

    function selectedGroupMenu(){
        // 一括が選択されているなら true を返す
        var gcode = groupCode() * 1; // 選択されているポップアップのコード：一括はコード0
        var itemName = (gcode == 0) ? selectedLimitedMenu() : ""; // 選択されたポップアップ名
        
        var elm = elmFor("setNameF");
        if (elm){
            var title = elm.value;
            
            return (itemName && isSame(itemName, title)) ? true : false;
        } else {
            return false;
        }
    }
}

function rmoveSet(){
    var selectedName = elmFor("setNamePop").value;
    if (!confirm(selectedName + "　のセット登録を削除していいですか？")) return;
    
    // 現在表示されているレコード・セットをテンプレートとして登録
    var args = new Object();
    args.owner = owner();
    args.title = selectedName;
    
    NRCallVin("REMOVE_TREATMENT_GROUP", args, savedVinSet);
}

function gotSetItem(answer){
    // サーバが返したセット内容を表示
    var buff = "";
    var selectedName = elmFor("setNamePop").value;
    var obj = JSON.parse(answer);
    for (key in obj){
        if (key == selectedName){
            var rec = obj[key];
            for (label in rec){
                if (label == "ProgressSection.treatment"){
                    var st = convertSTRING(rec[label], "\n", "<br>");
                    buff += st;
                }
            }
        }
    }
    var elm = elmFor("setMenuContents");
    elm.innerHTML = buff;

    // 選択されたセット名を入力欄へ転記
    elmFor("setNameF").value = selectedName;
}
function setNameSelected(elm){
    // セット名がポップアップメニューから選択された
    var selectedName = elm.value;
    if (selectedName.length == 0){
        // 選択されたポップアップメニューが空白なら「診療入力ツール」の内容を表示
        var buff = convertSTRING(archives(), "\n", "<br>");
        elmFor("setMenuContents").innerHTML = buff;
        
        // セット名入力欄を初期化
        var fd = elmFor("setNameF");
        fd.value = "";
        fd.setAttribute("placeholder", "セット名");
    } else {
        var div = elmFor("removeSetButtonArea");
        div.innerHTML = "";
        if (selectedName.length > 0){
            // 一括メニューが選択されている時だけ削除メニューを表示
            var im = newIMAGE(div, "removeSet/expandIcon","./remove-field.png","remove");
            im.setAttribute("onclick", "rmoveSet()");
            im.style.marginLeft = "5px";
            //setInfoTip("removeSet", "このセットを削除"); // INFO -- floatPanel では infoTip 動作しない
        }
        // セット名に対応するセット内容をサーバへリクエスト
        var args = new Object();
        args["owner"] = owner();
        NRCall("GET_GROUP_MENU", args, gotSetItem);
    }
}
function gotSetnames(answer){
    // サーバから得た一括メニューをポップアップメニューに表示
    var obj = JSON.parse(answer);
    var names = [""];
    for (label in obj){
        if (label.length == "") continue;
        if (label.charAt(0) == "_") continue;
        names.push(label);
    }
    
    // 一括メニューのポップアップを表示
    var elm = elmFor("setNamePopupArea");
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, "setNamePop", names, "");
    pu.setAttribute("onchange", "setNameSelected(this)");
}
function getSetnames(){
    // ラベル「セット名」の位置に、既存セットのポップアップメニューを表示
    var args = new Object();
    args.code = "00";
    
    NRCallVin("GET_CHILD_SELECTOR", args, gotSetnames);
}

function openSetEditor(button){
    // セット登録 編集ペーンを開く
    var elm = elmFor("_floatPanel");
    if (elm.innerHTML.length > 0){
        closeFloatPanel();
        return;
    }
    
    // フロート・パネルを生成
    var pos = getPosition(button);
    var w = 500;
    var x = pos.x; // 表示するx座標
    var y = pos.y + 20; // 表示するy座標
    var panel = new FloatPanel("_floatPanel", x, y, w, "セット登録","openHelp('vinSetHelp.html')");
    if (!panel) return;
    var frame = panel.contents;
    frame.style.opacity = "1.0"; // dom.js を上書き
    frame.style.backgroundColor = "#ffd"; // dom.js を上書き
    frame.style.padding = "10px";
    frame.style.borderRadius = "0 0 6px 6px";
    
    // ポップアップメニューなど ========================
    var dv = newDIV(frame, "");

    // セット名ポップアップ ---------------------------
    var sp = newSPAN(dv, "setNamePopupArea");
    getSetnames();
    
    // セット名入力欄 --------------------------------
    // 約束処方名入力（一括メニューが開いていればそのメニュー・アイテムを default 表示）
    var gcode = groupCode() * 1; // 選択されているポップアップのコード：一括はコード0
    var menuItem = (gcode == 0) ? selectedLimitedMenu() : ""; // 選択されたポップアップ名

    var sp = newSPAN(dv, "");
    var fd = newFIELD(sp, "setNameF", "", 20, menuItem);
    fd.setAttribute("placeholder", "セット名");
    fd.focus();
    fd.style.marginLeft = "5px";
    
    // 削除ボタン -----------------------------------
    var sp = newSPAN(dv, "removeSetButtonArea");
    
    // CONTENTS ===================================
    var div = newDIV(frame, "setMenuContents");
    div.style.padding = "10px";
    div.style.fontSize = "9pt";
    var buff = convertSTRING(archives(), "\n", "<br>");
    div.innerHTML = buff;
    
    // 登録ボタン ===================================
    var div = newDIV(frame, "");
    div.style.textAlign = "right";
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "登録";
    bt.setAttribute("onclick", "saveVinSet()");
}
