<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function fwrite_stream($fp, $string) {
        for ($written = 0; $written < strlen($string); $written += $fwrite) {
            $fwrite = fwrite($fp, substr($string, $written));
            if ($fwrite === false) {
                return $written;
            }
        }
        return $written;
    }
    
    function suffix($filename){
        // ファイル名末尾の拡張子を返す
        $array = explode(".", $filename);
        
        if (count($array) > 1)
            return '.'.$array[count($array) - 1];
        else
            return "";
    }
    
    function getDir($dir){
        // $dir 内のファイルをリストアップ
        $results = array();
        $array = array();
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // folder は除外する
            $path = "$dir/$filename";
            if (scandir($path)) continue;
            
            $array[] = $filename;
        }
        rsort($array); // 逆順にソート
        $results['path'] = $dir;
        $results['files'] = $array;
        
        return $results;
    }
    
    
    /* ########################################
     ### 以下でも $_POST['command'] と同じに機能する ###
     if (isset($_REQUEST['command'])) {
     $command = $_REQUEST['command'];
     }
     ########################################## */
    
    $command = $_POST['command'];
    $owner = $_POST['owner'];
    $logoName = $_POST['filename'];
    
    // 以下は Web サーバ経由でなく Draw から dir を辿るので絶対パスでなく相対パス
    // $homeDir = "../../Users"; // /X/NOA の場合
    $homeDir = "../Users";
    
    if (! file_exists($homeDir)) mkdir($homeDir);
    $dir = "$homeDir/$owner";
    if (! file_exists($dir)) mkdir($dir);
    $dir = "$dir/LOGO";
    if (! file_exists($dir)) mkdir($dir);
    
    if ($command == "PUT_IMAGE"){ // "SAVE_IMAGE"
        // $files が指定されていない場合は $calendarLogo を削除する
        $files = $_FILES['files']['name'];
        $tmpFiles = $_FILES['files']['tmp_name'];
        
        if ($files){ // ファイルを保存
            $count = count($files);
            for ($i=0; $i < $count; $i++){
                $filename = $files[$i];
                $tmp = $tmpFiles[$i];
                if (strlen($filename) > 0){
                    if (!is_uploaded_file($tmp)){
                        echo "<p>$filename を保存できませんでした</p>";
                        break;
                    } else {
                        $sfx = suffix($filename);
                        $path = "$dir/$logoName$sfx";
                        copy($tmp, $path);
                        echo "<SEPARATOR>";
                        echo "<img src=$path><br>";
                        echo "SAVED: $path <br>";
                    }
                }
            }
            
            $uri = $_SERVER['HTTP_REFERER'];
            echo "<p><A HREF=$uri>元の画面へ戻る</A></p>";
        } else { // ファイルを削除
            if ($handle = opendir("$dir")) {
                while (false !== ($item = readdir($handle))) {
                    if ($item != "." && $item != "..") {
                        $ary = explode(".", $item);
                        if (strcmp($ary[0], $logoName) == 0){
                            $sfx = suffix($item);
                            $path = "$dir/$logoName$sfx";
                            unlink($path);
                            echo "<SEPARATOR>";
                            echo "removing $path <br>\n";
                            break;
                        }
                    }
                }
                closedir($handle);
            }
        }
    } else if ($command == "GET_IMAGE"){
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // folder は除外する
            $ary = explode(".", $filename);
            if (strcmp($ary[0], $logoName) == 0){
                $sfx = suffix($filename);
                $path = "$dir/$logoName$sfx";
                if (scandir($path)) continue;
                
                echo "<SEPARATOR>";
                // $path を取り出すため $path を '' で囲む
                echo "<img src='$path' width=50 height=50>";
                return;
            }
        }
        echo "<SEPARATOR>";
        echo ""; // ロゴ・イメージがなかった
    } else {
        echo "<p>key( $command ) is wrong *****</p>";
    }
    
?>