<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC15"
	title	= "インクルードファイル検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select ADDRESS,FILENAME,TAGNAME,
				SRC_FILE,MODIFIED,FILEPATH,FGOMIT,FGJ,UNIQ,DYUPD,USRUPD,PGUPD
		from GF75
	</jsp:text>
	<og:where>
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "FGOMIT      = '{@FGOMIT}'"         />
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "ADDRESS     like '{@ADDRESS}%'"    />
		<og:and value = "FILENAME    like '{@FILENAME}%'"   />
		<og:and value = "TAGNAME     like '{@TAGNAME}%'"    />
		<og:and value = "MODIFIED {@CONDITION} '{@MODIFIED}'" />
		<og:and value = "SRC_FILE    like '{@SRC_FILE}%'"   />
	</og:where>
	<jsp:text>
		order by SYSTEM_ID,ADDRESS,FILENAME,TAGNAME
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="TAGNAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
		keys="command,FULLTAG,VIEW,VERNO"
		vals="NEW,[TAGNAME],,4.0.0" />
	<og:link column="FILENAME" href="[FILEPATH]" target="_blank" type="text/plain" useGamenId="false" />
</og:viewLink>

<og:link href="group.jsp" keys="command,SYSTEM_ID" vals="NEW,{@SYSTEM_ID}" >{@LBL.GROUPSRC}</og:link>
<br />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="update" lbl="DELETE" command="DELETE" accesskey="D" keys="minRow" vals="1" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ,UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
