/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.KanaFilter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileDownload
extends HttpServlet {
    private static final long serialVersionUID = 4000L;
    private static final String[][] CONTENT_TYPE_TABLE = new String[][]{{"jpg", "image/pjpeg"}, {"gif", "image/gif"}, {"txt", "text/plain"}, {"xls", "application/vnd.ms-excel"}, {"odp", "application/vnd.oasis.opendocument.presentation"}, {"ods", "application/vnd.oasis.opendocument.spreadsheet"}, {"odt", "application/vnd.oasis.opendocument.text"}};
    private static final int EXTENTION = 0;
    private static final int CONTENT_TYPE = 1;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        boolean bl = HybsSystem.sysBool("USE_FILEDOWNLOAD_HAN_ZEN");
        String string2 = httpServletRequest.getParameter("file");
        String string3 = httpServletRequest.getParameter("name");
        boolean bl2 = StringUtil.nval((String)httpServletRequest.getParameter("inline"), (boolean)false);
        String string4 = bl2 ? "inline" : "attachment";
        string2 = new String(string2.getBytes("ISO-8859-1"), "UTF-8");
        boolean bl3 = HybsSystem.sysBool("USE_FILEDOWNLOAD_CHECKKEY");
        if (bl3 && ((string = httpServletRequest.getParameter("key")) == null || !string.equals(HybsCryptography.getMD5((String)string2)))) {
            String string5 = "\u30a2\u30af\u30bb\u30b9\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002(URL\u30c1\u30a7\u30c3\u30af)";
            throw new HybsSystemException(string5);
        }
        string2 = HybsSystem.url2dir(string2);
        string = this.getContentType(string2);
        httpServletResponse.setContentType(string);
        string3 = string3 == null || string3.length() == 0 ? this.getFileName(string2) : new String(string3.getBytes("ISO-8859-1"), "UTF-8");
        if (bl) {
            string3 = KanaFilter.han2zen((String)string3);
        }
        string3 = httpServletRequest.getHeader("User-Agent").indexOf("MSIE") == -1 ? MimeUtility.encodeWord((String)string3, (String)"UTF-8", (String)"B") : new String(string3.getBytes("Windows-31J"), "ISO-8859-1");
        httpServletResponse.setHeader("Content-disposition", string4 + "; filename=\"" + string3 + "\"");
        httpServletResponse.setHeader("Cache-Control", "public");
        FileInputStream fileInputStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string2);
            servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
                servletOutputStream.flush();
            }
        }
        catch (Throwable throwable) {
            Closer.ioClose(fileInputStream);
            Closer.ioClose(servletOutputStream);
            throw throwable;
        }
        Closer.ioClose((Closeable)fileInputStream);
        Closer.ioClose((Closeable)servletOutputStream);
    }

    private String getExtention(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf(HybsSystem.FS);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private String getContentType(String string) {
        String string2 = this.getExtention(string);
        for (int i = 0; i < CONTENT_TYPE_TABLE.length; ++i) {
            if (!CONTENT_TYPE_TABLE[i][0].equalsIgnoreCase(string2)) continue;
            return CONTENT_TYPE_TABLE[i][1];
        }
        return "application/octet-stream";
    }
}

