<og:query command="{@command}" debug="{@debug}" dbid="{@DBID1}" maxRowCount="{@maxRowCount}">
	select	UPPER(TABLE_NAME) AS TABLE_NAME,UPPER(CLM) AS CLM,NAME_JA,CLS_NAME,
			COALESCE(EDITOR,(CASE
						WHEN ( UPPER(CLM) LIKE 'CD%' OR UPPER(CLM) LIKE 'FG%' OR UPPER(CLM) LIKE 'KB%' )
							AND USE_LENGTH <= '2' THEN 'MENU'
						ELSE 'TEXT'
						END)
			) AS EDITOR,
			COALESCE(RENDERER,(CASE
						WHEN ( UPPER(CLM) LIKE 'CD%' OR UPPER(CLM) LIKE 'FG%' OR UPPER(CLM) LIKE 'KB%' )
							AND USE_LENGTH <= '2' THEN 'MENU'
						ELSE 'LABEL'
						END)
			) AS RENDERER,
			COALESCE(DBTYPE,(CASE 
						WHEN CLS_NAME = 'NUMBER'      THEN 'S9'
						WHEN CLS_NAME = 'INTEGER'     THEN 'S9'
						WHEN CLS_NAME LIKE 'VARCHAR%' THEN
							CASE WHEN LENGTH(USE_LENGTH) = 1 THEN 'X'
								 WHEN LENGTH(USE_LENGTH) = 3 THEN 'KX'
								 WHEN USE_LENGTH    <= '30'  THEN 'X'
							     WHEN USE_LENGTH    >  '30'  THEN 'XK'
							     ELSE 'X'
							END
						END)
			) AS DBTYPE,
			USE_LENGTH,DATA_DEFAULT,UNIQ,SYSTEM_ID,0 SEQ
	from GF05 A
	where A.SYSTEM_ID in ( '{@SYSTEM_ID1}','{@AST1}')
	and   A.TBLSYU    = '{@TBLSYU1}'
	and   A.FGJ       = '1'
	order by TABLE_NAME, CLM
</og:query>

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID2}" maxRowCount="{@maxRowCount}" scope="request">
	select '' TABLE_NAME,CLM,NAME_JA,CLS_NAME,EDITOR,RENDERER,DBTYPE,USE_LENGTH,DATA_DEFAULT,UNIQ,SYSTEM_ID,0 SEQ
	from GEA03 A
	where A.SYSTEM_ID in ( '{@SYSTEM_ID2}','{@AST2}')
	and   A.FGJ       = '1'
	ORDER BY A.CLM
</og:query>

<og:tableMerge
	action        = "MINUS"
	masterScope   = "session"
	masterKeys    = "CLM"
	slaveScope    = "request"
	display       = "true"
/>

<og:value key="lblKey" value="A" />

<og:hidden name="SQL">
	INSERT INTO GEA03
		(SYSTEM_ID,CLM,NAME_JA,CLS_NAME,RENDERER,EDITOR,
		 DBTYPE,USE_LENGTH,DATA_DEFAULT,KBSAKU,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		('{@SYSTEM_ID2}',[CLM],[NAME_JA],[CLS_NAME],[RENDERER],[EDITOR],
		 [DBTYPE],[USE_LENGTH],[DATA_DEFAULT],'1',
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
</og:hidden>

<og:hidden name="SQL2">
	INSERT INTO GEA08
		(SYSTEM_ID,CLM,NAME_JA,LNAME,KBSAKU,KBLBL,LANG,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		('{@SYSTEM_ID2}',[CLM],[NAME_JA],[NAME_JA],'1','1','ja',
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
</og:hidden>

<og:hidden name="SQLD2">
	UPDATE GEA08 SET
			FGJ       = '9',
			DYUPD     = '{@USER.YMDH}',
			USRUPD    = '{@USER.ID}',
			PGUPD    = '{@GUI.KEY}'
	WHERE SYSTEM_ID = '{@SYSTEM_ID2}'
	AND   CLM       = [CLM]
	AND   LANG    = 'ja'
	AND   KBSAKU != '0'
</og:hidden>
