/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.daemon;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.report.GE50Access;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.HybsTimerTask;

import org.opengion.fukurou.mail.MailReceiveListener ;
import org.opengion.fukurou.mail.MailRX ;

import java.util.Date;

/**
 * 【メールデーモン】メールサーバーを監視して、EXCELファイルのDB登録処理のデーモンです。
 * 指定の条件でメールサーバーを監視し、添付のEXCELファイルを取り出します。
 * 添付ファイルは、EXCEL取り込みインターフェースに則り、要求番号.xls にリネームして
 * 所定のディレクトリ(EXCEL_IN_FILE_URLで定義)にセーブし、帳票要求テーブルに登録します。(GE50)
 * それ以降の処理は、EXCEL帳票デーモン以下の共通処理で処理されます。
 * EXCEL取り込み処理は、このメール自動取り込みと、ファイルアップロードの方式を
 * サポートしています。
 *
 * @og.rev 3.8.0.0 (2005/06/07) 新規追加
 * @og.rev 4.3.4.4 (2009/01/01) プラグイン化
 * @og.group デーモン
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Daemon_MailReceive extends HybsTimerTask {

	private int			loopCnt		= 0;
	private static final int LOOP_COUNTER = 24;		// カウンタを24回に設定

	private MailRX	mailRX		= null;

	/**
	 * このタイマータスクによって初期化されるアクションです。
	 * パラメータを使用した初期化を行います。
	 *
	 */
	@Override
	public void initDaemon() {

		String	host	 = StringUtil.nval( getValue( "HOST"   ) , HybsSystem.sys( "COMMON_MAIL_SERVER" ) );
		String	user	 = StringUtil.nval( getValue( "USER"   ) , HybsSystem.sys( "MAIL_DAEMON_DEFAULT_USER" ) );
		String	passwd	 = StringUtil.nval( getValue( "PASSWD" ) , HybsSystem.sys( "MAIL_DAEMON_DEFAULT_PASS" ) );

		mailRX = new MailRX();
		mailRX.setHost( host );
		mailRX.setUser( user );
		mailRX.setPasswd( passwd );
		mailRX.setDelete( true );

	// 現段階では、Subjectによるメール取得振分は行いません。
	// 条件に合わないエラーメールを取り出す機会がなくなるためです。
	//	String	subject	 = getValue( "SUBJECT" );
	//	if( subject != null && subject.length() > 0 ) {
	//		HybsEntry entry = new HybsEntry( "Subject",subject );
	//		mailRX.addMatchTerm( entry );
	//	}

		String	receiveListener	 = getValue( "RECEIVE_LISTENER" );
		MailReceiveListener listener = (MailReceiveListener)HybsSystem.newInstance( receiveListener );
		mailRX.setMailReceiveListener( listener );
	}

	/**
	 * タイマータスクのデーモン処理の開始ポイントです。
	 *
	 * @og.rev 5.3.0.0 (2010/12/01) エラーハンドリングを修正
	 *
	 */
	@Override
	protected void startDaemon() {
		if( loopCnt % LOOP_COUNTER == 0 ) {
			loopCnt = 1;
			System.out.println();
			System.out.print( toString() + " " + new Date()  + " " );
		}
		else {
			System.out.print( "." );
			loopCnt++ ;
		}

		try {
			mailRX.start();
		}
//		catch( Throwable ex ) {
//			GE50Access GE50 = new GE50Access( "CYYYYY","M_Daemon","MailReceive" );
//
//			GE50.setSystemId( "ERR" );
//			GE50.makeYkno();
//
//			GE50.insertGE50( GE50Access.FG_ERR1 );
//
//			String errMsg = StringUtil.stringStackTrace( ex );
//			GE50.insertErrorGE56( errMsg );
//
//			LogWriter.log( errMsg );
//		}
	 	// 5.3.0.0 (2010/12/01) エラーハンドリングを修正
		catch( Throwable ex ) {
			String errMsg = StringUtil.stringStackTrace( ex ) ;
			System.out.println( errMsg );
			LogWriter.log( errMsg );

			GE50Access ge50 = new GE50Access( "CYYYYY","M_Daemon","MailReceive" );

			ge50.setSystemId( "ERR" );
			ge50.makeYkno();

			ge50.insertErrorGE56( errMsg );
			ge50.insertGE50( GE50Access.FG_ERR1 );

		}
	}
}
