/**************************************************************************/
/* GF22 ( ＴＡＧＬＩＢ属性定義 )                                          */
/*                                                                        */
/* Created : 2012/07/28 16:35:01                                          */
/**************************************************************************/
CREATE TABLE GF22 (
   VERNO       VARCHAR2(10)                 NOT NULL      /* 10  バージョン   */
 , PRE_FIX     VARCHAR2(10)                 NOT NULL      /* 20  名前空間     */
 , TAGNAME     VARCHAR2(30)                 NOT NULL      /* 30  タグ名称     */
 , VALUENAME   VARCHAR2(30)                 NOT NULL      /* 40  属性名称     */
 , SEQ         NUMBER(7)        DEFAULT 0   NOT NULL      /* 50  順           */
 , TAGCLASS    VARCHAR2(100)                NOT NULL      /* 60  TAGクラス名  */
 , REQUIRED    VARCHAR2(1)                                /* 70  必須         */
 , RTEXPRVALUE VARCHAR2(1)                                /* 80  動的計算属性 */
 , VAL_TYPE    VARCHAR2(100)                              /* 90  TYPE         */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET       VARCHAR2(14)                               /* 820 登録日時     */
 , PGSET       VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET      VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET      VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD       VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD       VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD      VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD      VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 5120K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF22S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF22T00 
BEFORE INSERT ON GF22
FOR EACH ROW 
BEGIN 
SELECT GF22S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

