<!-- PostgreSQL  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select TABLE_NAME,CONSTRAINT_NAME AS INDEX_NAME,COLUMN_NAME AS CLM,ORDINAL_POSITION AS SEQNO,
			'{@SYSTEM_ID}' AS SYSTEM_ID,'{@TBLSYU}' AS TBLSYU
		from information_schema.key_column_usage
		where CONSTRAINT_SCHEMA = 'public'
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'"  />
	</og:where>
		order by TABLE_NAME,CONSTRAINT_NAME,ORDINAL_POSITION
  </og:query>
</og:equals>

<!-- ORACLE  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select TABLE_NAME,INDEX_NAME,COLUMN_NAME AS CLM,COLUMN_POSITION AS SEQNO,
			'{@SYSTEM_ID}' AS SYSTEM_ID,'{@TBLSYU}' AS TBLSYU
		from USER_IND_COLUMNS
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_IND_COLUMNS.TABLE_NAME
					)
		and   INSTR(TABLE_NAME,'$') < 1
		and   INSTR(INDEX_NAME,'$') < 1
		and   INSTR(COLUMN_NAME,'$') < 1
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
		</og:where>
		order by TABLE_NAME,INDEX_NAME,COLUMN_POSITION
  </og:query>
</og:equals>

<!-- FIREBIRD  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select a.RDB$RELATION_NAME		AS TABLE_NAME, 
				a.RDB$INDEX_NAME		AS INDEX_NAME, 
				b.RDB$FIELD_NAME		AS CLM, 
				b.RDB$FIELD_POSITION	AS SEQNO, 
				'{@SYSTEM_ID}' AS SYSTEM_ID,'{@TBLSYU}' AS TBLSYU
		from RDB$INDICES a inner join RDB$INDEX_SEGMENTS b
		on   a.RDB$INDEX_NAME = b.RDB$INDEX_NAME
		where a.RDB$SYSTEM_FLAG = 0
		<og:where startKey="and">
			<og:and value = "a.RDB$RELATION_NAME like '{@TABLE_NAME}%'" />
		</og:where>
		order by a.RDB$RELATION_NAME,a.RDB$INDEX_NAME,b.RDB$FIELD_POSITION
  </og:query>
</og:equals>
