/* version: 0.0.1 
 * author : Sen Li
 * date   : 2012/05/10
 */
var editMode 		= "Layout";		// Layout レイアウト編集 Value 設定値の編集
var countPro 		= 5;			// データノードの属性数( 行, 列, 値, 色, ステータス )
var cellWidth		= "75px";		// セル幅
var cellHeight		= "30px";		// セル高さ
var inputWidth		= "50";			// 入力欄の高さ
var divHeight		= "50";			// ポップアップの高さ
var countStatus		= 6;			// ステータス数
var showStatus		= "false";		// ステータス表示（true:表示 false:非表示）
var editColor		= "false";		// セル背景色の編集可否（true:編集可 false:編集不可）
var writable		= "false";		// セルの編集可否（true:編集可 false:編集不可）
var separator		= ":";			// セル名称と設定値の間の区切り文字
var paramVal		= "";			// セル設定値の初期値
var paramColor		= "";			// セル背景色の初期値
var notEditBgColor	= "gray"		// 編集不可の時の色

//
var SYS_BACKGROUND	  = "white";
var SYS_EDIT		  = "可";
var SYS_NOTEDIT		  = "不可";
var SYS_MODE_LAYOUT	  = "Layout";
var SYS_MODE_VALUE	  = "Value";

var mTable			= null			// マトリクステーブル
//
var cellObjs		= null;			// セルオブジェクト
var cellVals		= null;			// セル設定値
//
var startCell 		= null;			// 選択開始セル
var endCell			= null;			// 選択終了セル
var rowStart 		= 0;			// 開始行
var colStart 		= 0;			// 開始列
var rowEnd   		= 0;			// 終点行
var colEnd   		= 0;			// 終点列
var rowCount		= 0;			// 行数
var colCount		= 0;			// 列数
var colors			= new Array( "white", "blue", "lightblue", "green", "lightgreen", "orange", "red", "pink" ,"purple", "brown", "black" );
var winWidth		= getClientWidth();
var winHeight		= getClientHeight();						// IEの高さを取得
var mouseX			= 0;
var mouseY			= 0;
var fgEditing		= "0";			// 編集中
var theImg;

// データノード
function dataNode( inRow, inCol, inLocation, inVal, inColor, inCellEdit, inStatus ){ 
	//iBar要素の属性設定
	this.row    	= inRow;										// 行番号
	this.col    	= inCol;										// 列番号
	this.location	= inLocation;									// ロケーション名
	this.value  	= inVal; 										// 値
	this.color  	= inColor;										// 色
	this.cellEdit 	= inCellEdit;									// セルの編集可非
	this.status 	= inStatus;										// ステータス
	this.size   	= 4;											// 属性の数
}

// データの更新
function setData( fgLocationName ,inLocationName , fgCellEdit ,inCellEdit ,fgValue ,inValue, fgColor ,inColor, fgStatus ,inStatus  ,inWhere)
{
	if( inWhere == null ) { return false; }
	$.post(  "entry.jsp"
			,{   FGNMLOC 	: fgLocationName		// ロケーション名称を更新する(1)／しない(0)
				,NMLOC   	: inLocationName		// ロケーション名称
				,FGCELLEDIT : fgCellEdit			// セル書き込み可フラグの更新する(1)／しない(0)
				,CELLEDIT	: inCellEdit			// セル書き込み可フラグ
				,FGVALUE   	: fgValue				// 設定値を更新する(1)／しない(0)
				,VALUE   	: inValue				// セル設定値
				,FGCOLOR   	: fgColor				// セル背景色を更新する(1)／しない(0)
				,COLOR   	: inColor				// セル背景色
				,FGSTATUS  	: fgStatus				// ステータスを更新する(1)／しない(0)
				,STATUS  	: inStatus				// ステータス
				,WHERE   	: inWhere				// 行列条件
			 }
			,function( data ){
				$("#FEEDBACK").html( data );
			}
	);
}

// セル中身編集（ロケーション名称）
function editInput1( inInput ,inSelectEdit ,inButtonOk ){ 
	// TDノード
	var objCell = inInput.parentNode;
	var indexId = ( objCell.row -1 ) * colCount + ( objCell.col - 1 ) * 1;

	// セル中身の再設定
	// ステータス表示
	if( showStatus == "true" && cellVals[indexId].status !="" ){
		var imgStatus			  = document.createElement("img");
		imgStatus.src 			  = "../image/status_" + cellVals[indexId].status + ".png";
		imgStatus.style.width	  = "15px";
		imgStatus.style.height	  = "15px";
		cellObjs[indexId].appendChild( imgStatus );
	}
	// 値
	var sep = ( inInput.value == "" || cellVals[indexId].value=="" ) ? "" :separator;
	cellObjs[indexId].appendChild( document.createTextNode( inInput.value + sep + cellVals[indexId].value )); 
	//
	if( inSelectEdit.value == "1" ){
		cellObjs[indexId].style.backgroundColor = cellVals[indexId].color;
	}
	else{
		cellObjs[indexId].style.backgroundColor = notEditBgColor;
	}
	// 更新処理
	setData( '1' 											// ロケーション名称を更新する(1)／しない(0)
			,inInput.value                                  // ロケーション名称
			,'1'                                            // セル書き込み可フラグの更新する(1)／しない(0)
			,inSelectEdit.value                             // セル書き込み可フラグ
			,'0'                                            // 設定値を更新する(1)／しない(0)
			,null                                           // セル設定値
			,'0'                                            // セル背景色を更新する(1)／しない(0)
			,null                                           // セル背景色
			,'0'                                            // ステータスを更新する(1)／しない(0)
			,null                                           // ステータス
			,'[' + objCell.row + '_' + objCell.col + ']'    // 行列条件
		);                                                  
	// セル設定値設定
	cellVals[indexId].location = inInput.value;
	// 編集用のノードを削除する。
	cellObjs[indexId].removeChild( inInput );
	cellObjs[indexId].removeChild( inSelectEdit );
	cellObjs[indexId].removeChild( inButtonOk );
	fgEditing = "0";
}
// セル要素中身編集（設定値）
function editInput2( inInput ,inColor ,inButtonOk ){ 
	// TDノード
	var objCell = inInput.parentNode;
	var indexId = ( objCell.row -1 ) * colCount + ( objCell.col - 1 ) * 1;
	var cellColor;
	if( inInput.value == "" ){
		cellColor = editColor == "true" ? inColor.value : SYS_BACKGROUND;
	}
	else{
		cellColor = inColor.value;
	}

	// セル中身の再設定
	// ステータス表示
	if( showStatus == "true" && cellVals[indexId].status != "" ){
		var imgStatus			  = document.createElement("img");
		imgStatus.src 			  = "../image/status_" + cellVals[indexId].status + ".png";
		imgStatus.style.width	  = "15px";
		imgStatus.style.height	  = "15px";
		//
		if( writable == "true" ){
			imgStatus.attachEvent( "ondblclick"  , function(){ editStatus( event );return false; } );
		}
		cellObjs[indexId].appendChild( imgStatus );
	}
	// 値
	var sep = ( cellVals[indexId].location == "" || inInput.value=="" ) ? "" :separator;
	cellObjs[indexId].appendChild( document.createTextNode( cellVals[indexId].location + sep + inInput.value )); 
	//
	if( cellVals[indexId].cellEdit == "1" ){
		cellObjs[indexId].style.backgroundColor = cellColor;
	}
	else{
		cellObjs[indexId].style.backgroundColor = notEditBgColor;
	}
	// 更新処理
	setData( '0' 											// ロケーション名称を更新する(1)／しない(0)
			,null                                           // ロケーション名称
			,'0'                                            // セル書き込み可フラグの更新する(1)／しない(0)
			,null                                           // セル書き込み可フラグ
			,'1'                                            // 設定値を更新する(1)／しない(0)
			,inInput.value                                  // セル設定値
			,'1'                                            // セル背景色を更新する(1)／しない(0)
			,cellColor                                      // セル背景色
			,'0'                                            // ステータスを更新する(1)／しない(0)
			,null                                           // ステータス
			,'[' + objCell.row + '_' + objCell.col + ']'    // 行列条件
		);                                                  
	// セル設定値設定
	cellVals[indexId].value = inInput.value;
	cellVals[indexId].color = cellColor;
	// 編集用のノードを削除する。
	cellObjs[indexId].removeChild( inInput );
	cellObjs[indexId].removeChild( inColor );
	cellObjs[indexId].removeChild( inButtonOk );
	fgEditing = "0";
}

// ステータスの編集
function editRadio( evt ,inIndexId ){ 
	if ( evt == null ){ return false; };
	var theRadio  = evt.srcElement;
	var objParent = theRadio.parentNode;
	theImg.src = "../image/status_" + theRadio.statusVal + ".png";
	// 更新処理
	setData( '0' 											// ロケーション名称を更新する(1)／しない(0)
			,null                                           // ロケーション名称
			,'0'                                            // セル書き込み可フラグの更新する(1)／しない(0)
			,null                                           // セル書き込み可フラグ
			,'0'                                            // 設定値を更新する(1)／しない(0)
			,null                                           // セル設定値
			,'0'                                            // セル背景色を更新する(1)／しない(0)
			,null                                           // セル背景色
			,'1'                                            // ステータスを更新する(1)／しない(0)
			,theRadio.statusVal                             // ステータス
			,'[' + cellObjs[inIndexId].row + '_' + cellObjs[inIndexId].col + ']'  // 行列条件
		);                       
	cellVals[inIndexId].status = theRadio.statusVal ;
	objParent.parentNode.removeChild( objParent );
}

// セル要素の編集
function editTd( evt ){ 
	// イベントがなければ処理しない
	if ( evt == null || fgEditing == "1" ){ return false; };
	var theCell = evt.srcElement;
	// セルのインデックス
	var indexId = ( theCell.row - 1 ) * colCount + (theCell.col - 1) * 1 ;
	//
	if( theCell.tagName == "TD" && ( cellVals[indexId].cellEdit == "1" || editMode == SYS_MODE_LAYOUT )){
		// 編集中フラグ
		fgEditing		= "1";
		// 子ノードを削除
		while ( cellObjs[indexId].hasChildNodes() ) {
		    cellObjs[indexId].removeChild( cellObjs[indexId].firstChild );
	    }
		// レイアウト編集の場合
		if( editMode == SYS_MODE_LAYOUT ){
			var mInput		= document.createElement("input");
			mInput.value	= cellVals[indexId].location;

			mInput.style.border = "solid gray 1px";
			mInput.style.width  = inputWidth;
			theCell.appendChild( mInput );

			var mSelectEdit = document.createElement("select");
			// option要素作成
			var option1 = document.createElement( "option" );
			// option要素のvalue属性に選択項目データ
			option1.value = "1";
			if( cellVals[indexId].cellEdit == "1" ){
				option1.selected = true;
			}
			// テキストノード作成
			var text = document.createTextNode( SYS_EDIT );
			// テキストノードをoption要素に追加
			option1.appendChild( text );
			// option要素をselect要素に追加
			mSelectEdit.appendChild( option1 );
			var option2 = document.createElement( "option" );
			// option要素のvalue属性に選択項目データ
			option2.value = "0";
			if( cellVals[indexId].cellEdit == "0" ){
				option2.selected = true;
			}
			// テキストノード作成
			var text = document.createTextNode( SYS_NOTEDIT );
			// テキストノードをoption要素に追加
			option2.appendChild( text );
			// option要素をselect要素に追加
			mSelectEdit.appendChild( option2 );
			theCell.appendChild( mSelectEdit );
			// OKボタン
			var mButtonOK	  			= document.createElement("button");
			mButtonOK.style.width 		= "25px";
			mButtonOK.style.margin		= "1px";
			mButtonOK.value				= "OK";
			mButtonOK.attachEvent( "onclick", function(){ editInput1( mInput ,mSelectEdit ,mButtonOK ); } );
			theCell.appendChild( mButtonOK );
			mInput.focus();
			mInput.focus();
		}
		else{
			var mInput		= document.createElement("input");
			mInput.value	= cellVals[indexId].value == "" ? paramVal : cellVals[indexId].value;

			mInput.style.border = "solid gray 1px";
			mInput.style.width  = inputWidth;
			theCell.appendChild( mInput );
			// 色編集を使う
			if( editColor == "true" ){
				var mSelectColor			= document.createElement("select");
				for( i = 0;  i < colors.length; i++ ){
					// option要素作成
					var option = document.createElement( "option" );
					// option要素のvalue属性に選択項目データ
					option.value = colors[i];
					//
					if( colors[i] == ( paramColor.length > 0 ? paramColor : cellVals[indexId].color )){
						option.selected = true;
					}
					option.style.backgroundColor = colors[i];
					// テキストノード作成
					var text = document.createTextNode( colors[i] );
					// テキストノードをoption要素に追加
					option.appendChild(text);
					// option要素をselect要素に追加
					mSelectColor.appendChild( option );
				}
			}
			// 色編集を使わない
			else{
				var mSelectColor = document.createElement("hidden");
				mSelectColor.value = paramColor == "" ? cellVals[indexId].color : paramColor;
			}
			theCell.appendChild( mSelectColor );

			// OKボタン
			var mButtonOK	  			= document.createElement("button");
			mButtonOK.style.width 		= "25px";
			mButtonOK.style.margin		= "1px";
			mButtonOK.value				= "OK";
			mButtonOK.attachEvent( "onclick", function(){ editInput2( mInput ,mSelectColor ,mButtonOK ); } );
			theCell.appendChild( mButtonOK );
			// フォーカスをあてる。
			mInput.focus();
			mInput.focus();
		}
	}
}

// 複数セルの同時編集（設定値と色）
function editBlock1( inInput, inColor, inDiv ){ 
	var strWhere = "";
	var cellColor;
	if( inInput.value == "" ){
		cellColor = editColor == "true" ? inColor.value : SYS_BACKGROUND;
	}
	else{
		cellColor = inColor.value;
	}
	for( i= rowStart ; i <= rowEnd ;i++ ){
		for( j=colStart ; j <= colEnd ;j++ ){
			strWhere =strWhere + "[" + i +"_" + j + "]";
		}
	}
	var indexId = new Number( 0 );
	for( i = rowStart ; i <= rowEnd ;i++ ){
		for( j = colStart ; j <= colEnd ;j++ ){
			indexId = ( i - 1 ) * colCount + (j - 1) * 1 ;
			if( cellVals[indexId].cellEdit == "1" ){
				theText = cellObjs[indexId].lastChild;
				var sep = ( cellVals[indexId].location == "" || inInput.value=="" ) ? "" :separator;
				theText.nodeValue = cellVals[indexId].location + sep + inInput.value;

				cellObjs[indexId].style.backgroundColor = cellColor;
				cellVals[indexId].color 				= cellColor;
				cellVals[indexId].value					= inInput.value;
			}
		}
	}
	// 更新処理
	setData( '0' 								// ロケーション名称を更新する(1)／しない(0)
			,null                               // ロケーション名称
			,'0'                                // セル書き込み可フラグの更新する(1)／しない(0)
			,null                               // セル書き込み可フラグ
			,'1'                                // 設定値を更新する(1)／しない(0)
			,inInput.value                      // セル設定値
			,'1'                                // セル背景色を更新する(1)／しない(0)
			, cellColor                         // セル背景色
			,'0'                                // ステータスを更新する(1)／しない(0)
			,null                               // ステータス
			,strWhere                           // 行列条件
		);                                      
	inDiv.parentNode.removeChild( inDiv ) ;
	// 編集中フラグの解除
	fgEditing = "0";
}
// 複数セルの同時編集（セルの書込み可非）
function editBlock2( inSelect, inDiv ){ 
	var strWhere = "";
	var cellColor;
	for( i= rowStart ; i <= rowEnd ;i++ ){
		for( j=colStart ; j <= colEnd ;j++ ){
			strWhere =strWhere + "[" + i +"_" + j + "]";
		}
	}
	var indexId = new Number( 0 );
	for( i = rowStart ; i <= rowEnd ;i++ ){
		for( j = colStart ; j <= colEnd ;j++ ){
			indexId = ( i - 1 ) * colCount + (j - 1) * 1 ;
			// 子ノードを削除
			while ( cellObjs[indexId].hasChildNodes() ) {
			    cellObjs[indexId].removeChild( cellObjs[indexId].firstChild );
		    }
			// セル中身の再設定
			// ステータス表示
			if( showStatus == "true" && cellVals[indexId].status != "" ){
				var imgStatus			  = document.createElement("img");
				imgStatus.src 			  = "../image/status_" + cellVals[indexId].status + ".png";
				imgStatus.style.width	  = "15px";
				imgStatus.style.height	  = "15px";
				cellObjs[indexId].appendChild( imgStatus );
			}
			// 値
			var sep = ( cellVals[indexId].location == "" || cellVals[indexId].value=="" ) ? "" :separator;
			cellObjs[indexId].appendChild( document.createTextNode( cellVals[indexId].location + sep + cellVals[indexId].value )); 
			//
			if( inSelect.value == "1" ){
				cellVals[indexId].cellEdit	  = "1";
				// 背景色
				cellObjs[indexId].style.backgroundColor 	= cellVals[indexId].color;
			}
			else{
				cellVals[indexId].cellEdit	  = "0";
				cellObjs[indexId].style.backgroundColor 	= notEditBgColor;
			}
		}
	}
	// 更新処理
	setData( '0' 								// ロケーション名称を更新する(1)／しない(0)
			,null                               // ロケーション名称
			,'1'                                // セル書き込み可フラグの更新する(1)／しない(0)
			,inSelect.value                     // セル書き込み可フラグ
			,'0'                                // 設定値を更新する(1)／しない(0)
			, null                              // セル設定値
			,'0'                                // セル背景色を更新する(1)／しない(0)
			,null                               // セル背景色
			,'0'                                // ステータスを更新する(1)／しない(0)
			,null                               // ステータス
			,strWhere                           // 行列条件
		);                                      
	inDiv.parentNode.removeChild( inDiv ) ;
	// 編集中フラグの解除
	fgEditing = "0";
}

// ステータス画像要素の編集（ステータスノード）
function editStatus( evt ){ 
	// イベントがなければ処理しない
	if ( evt == null){ return false; };
	theImg = evt.srcElement;

	if( theImg.tagName == "IMG" ){
	var indexId = ( theImg.parentNode.row - 1 ) * colCount + ( theImg.parentNode.col - 1 ) * 1;
	//編集ポップアップの表示
	var mDiv = document.createElement("div");
	mDiv.style.position 		= "absolute";
	mDiv.style.left 			= evt.x;
	mDiv.style.top  			= evt.y;
	mDiv.style.width  			= 40 * countStatus + 50;
	mDiv.style.height 			= 20;
	mDiv.align  				= "center";
	mDiv.style.border 			= "solid black 1px";
	mDiv.style.padding			= "5";
	mDiv.style.backgroundColor 	= "lightSkyBlue";
	// 色の入力欄
	for( i = 0;  i <= countStatus; i++ ){
		// radio要素作成
		var radio 				= document.createElement("input");
		radio.type				= "radio";
		radio.statusVal			= i;
		radio.attachEvent( "onclick", function(){ editRadio( evt ,indexId ); } );

		mDiv.appendChild( radio );
		var imgStatus	 		= document.createElement("img");
		imgStatus.src	 		= "../image/status_" + i + ".png";
		imgStatus.style.width	= "15px";
		imgStatus.style.height	= "15px";
		mDiv.appendChild( imgStatus );
	}
	// Cancelボタン
	var mImgCancel  			= document.createElement("img");
	mImgCancel.src	 			= "../image/status_Close.png";
	mImgCancel.style.width		= "15px";
	mImgCancel.style.height		= "15px";
	mImgCancel.style.marginLeft	= "30px";
	mImgCancel.attachEvent( "onclick", function(){ clearBlock( mDiv ); } );
	mDiv.appendChild( mImgCancel );
	//
	mTable.parentNode.appendChild( mDiv );

	}
}

// 選択範囲のクリア
function clearBlock( inDiv ){ 
	var indexId = new Number( 0 );
	if( rowStart > 0 && rowEnd > 0 && colStart > 0 && colEnd > 0 ){
		for( i = rowStart ; i <= rowEnd ;i++ ){
			for( j = colStart ; j <= colEnd ;j++ ){
				indexId = ( i - 1 ) * colCount + (j - 1) * 1 ;
				cellObjs[indexId].style.backgroundColor = cellVals[indexId].cellEdit=="1" ? cellVals[indexId].color : notEditBgColor;
			}
		}
	}
	inDiv.parentNode.removeChild( inDiv ) ;
	// 編集中フラグの解除
	fgEditing = "0";
}

//マウスダウンのイベント処理
function mouseDown( evt ){
	// イベントがなければ処理しない
	if ( evt == null || fgEditing == "1"){ return false; };

	// 発信源の特定（移動開始セル）
	startCell = evt.srcElement ? evt.srcElement: evt.target;
	// TDタグが見つかるまで
	while( startCell.tagName != "TD" && startCell.parentNode ){
		startCell = startCell.parentNode;
	}
	// TD以外処理しない
	if( startCell.tagName != "TD" ){
		startCell = null;
		return false;
	}
	// マウス移動の判定用
	mouseX = evt.x;
	mouseY = evt.y;
}

//マウス移動のイベント処理
function mouseMove( evt ){
	// イベントがなければ処理しない
	if ( evt == null){ return false; };
	
	// 発信源の特定（移動先セル）
	endCell = evt.srcElement ? evt.srcElement : evt.target;
	// TDタグが見つかるまで
	while( endCell.tagName != "TD" && endCell.parentNode ){
		endCell = endCell.parentNode;
	}

	// TD以外処理しない
	if(( endCell.tagName != "TD" || startCell == null || mTable == null ||( mouseX == evt.x && mouseY == evt.y ))){ 
		event.returnValue = false;
		return false; 
	}

	// 選択範囲
	rowStart = new Number( parseInt( startCell.row ) <= parseInt( endCell.row ) ? startCell.row : endCell.row   );
	colStart = new Number( parseInt( startCell.col ) <= parseInt( endCell.col ) ? startCell.col : endCell.col   );
	rowEnd   = new Number( parseInt( startCell.row ) <= parseInt( endCell.row ) ? endCell.row   : startCell.row );
	colEnd   = new Number( parseInt( startCell.col ) <= parseInt( endCell.col ) ? endCell.col   : startCell.col );

	// 
	for( i = 0; i < cellObjs.length; i++ ){
		cellObjs[i].style.backgroundColor = cellVals[i].cellEdit=="1" ? cellVals[i].color : notEditBgColor;
	}
	// 
	for( i = rowStart; i <= rowEnd; i++ ){
		var startIndex = ( i - 1 ) * colCount + ( colStart - 1 );
		var endIndex   = ( i - 1 ) * colCount + ( colEnd   - 1 );
		for( j = startIndex; j <= endIndex ; j++ ){
			// セル編集可の場合のみ色変化させる
			if( cellVals[j].cellEdit == "1" || editMode == SYS_MODE_LAYOUT ){
				cellObjs[j].style.backgroundColor = "lightblue";
			}
		}
	}
	//
	return false;

}

//マウスアップのイベント処理
function mouseUp( evt ){
	// イベントがなければ処理しない
	if ( evt == null){ return false; };

	endCell = evt.srcElement ? evt.srcElement : evt.target;
	// TDタグが見つかるまで
	while( endCell.tagName != "TD" && endCell.parentNode ){
		endCell = endCell.parentNode;
	}

	if(( startCell == null || ( mouseX == evt.x && mouseY == evt.y ))){
		startCell   = null;
		return false;
	}

	// 選択範囲
	rowStart = new Number( parseInt( startCell.row ) <= parseInt( endCell.row ) ? startCell.row : endCell.row );
	colStart = new Number( parseInt( startCell.col ) <= parseInt( endCell.col ) ? startCell.col : endCell.col );
	rowEnd   = new Number( parseInt( startCell.row ) <= parseInt( endCell.row ) ? endCell.row   : startCell.row );
	colEnd   = new Number( parseInt( startCell.col ) <= parseInt( endCell.col ) ? endCell.col   : startCell.col );
	//
	var indexStart = ( rowStart - 1 ) * colCount + ( colStart - 1 );
	var indexEnd   = ( rowEnd   - 1 ) * colCount + ( colEnd   - 1 );

	var cellEditExist = false;
	//
	for( i = rowStart; i <= rowEnd; i++ ){
		var startIndex = ( i - 1 ) * colCount + ( colStart - 1 );
		var endIndex   = ( i - 1 ) * colCount + ( colEnd   - 1 );
		for( j = startIndex; j <= endIndex ; j++ ){
			// セル編集可の場合
			if( cellVals[j].cellEdit == "1" || editMode == SYS_MODE_LAYOUT ){
				cellEditExist = true;
			}
		}
	}
	// 編集可のセルが存在する場合
	if( cellEditExist ){ 
		// 編集中フラグ
		fgEditing = "1";
		//編集ポップアップの表示
		var mDiv = document.createElement("div");
		var mDivWidth = inputWidth * 1 + 100;
		var mDivLeft  = endCell.offsetLeft + endCell.offsetWidth;
		var mDivTop   = endCell.offsetTop  + endCell.offsetHeight;
		// ポップアップは画面からはみ出さないようにする。
		mDivLeft = ( mDivLeft * 1 + mDivWidth * 1 + 20 ) > winWidth  ? ( mDivLeft - mDivWidth ) : mDivLeft;
		mDivTop  = ( mDivTop  * 1 + divHeight * 1 + 20 ) > winHeight ? ( mDivTop  - divHeight ) : mDivTop;
		//
		mDiv.style.position 		= "absolute";
		mDiv.style.left 			= mDivLeft;
		mDiv.style.top  			= mDivTop;
		mDiv.style.width  			= mDivWidth;
		mDiv.style.height 			= divHeight;
		mDiv.align  				= "center";
		mDiv.style.border 			= "solid black 1px";
		mDiv.style.padding			= "5";
		mDiv.style.backgroundColor 	= "lightSkyBlue";
		if( cellEditExist && editMode == SYS_MODE_VALUE ){ 
			// 値の入力欄
			var mInputValue	  			= document.createElement("input");
			mInputValue.style.width 	= inputWidth;
			mInputValue.style.border	= "solid gray 1px";
			
			var theCellVals 			= startCell.innerText.split( separator );
			if( paramVal != null && paramVal != "" ){
				mInputValue.value 		= paramVal;
			}
			else{
				mInputValue.value 		= cellVals[indexStart].value;
			}

			mDiv.appendChild( mInputValue );
			// 色編集を使う
			if( editColor == "true" ){
				var mSelectColor			= document.createElement("select");
				for( i = 0;  i < colors.length; i++ ){
					// option要素作成
					var option = document.createElement( "option" );
					// option要素のvalue属性に選択項目データ
					option.value = colors[i];
					//
					if( colors[i] == ( paramColor.length > 0 ? paramColor : cellVals[indexStart].color )){
						option.selected = true;
					}
					option.style.backgroundColor = colors[i];
					// テキストノード作成
					var text = document.createTextNode( colors[i] );
					// テキストノードをoption要素に追加
					option.appendChild(text);
					// option要素をselect要素に追加
					mSelectColor.appendChild( option );
				}
			}
			// 色編集を使わない
			else{
				var mSelectColor = document.createElement("hidden");
				mSelectColor.value = paramColor == "" ? cellVals[indexStart].color : paramColor ;
			}
			mDiv.appendChild( mSelectColor );
			var mBr   = document.createElement("br");
			mDiv.appendChild( mBr );

			// OKボタン
			var mButtonOK	  			= document.createElement("button");
			mButtonOK.style.width 		= "55px";
			mButtonOK.style.margin		= "3px";
			mButtonOK.value				= "OK";
			mButtonOK.attachEvent( "onclick", function(){ editBlock1( mInputValue, mSelectColor, mDiv ); } );
			mDiv.appendChild( mButtonOK );
			// Cancelボタン
			var mButtonCancel  			= document.createElement("button");
			mButtonCancel.style.width 	= "55px";
			mButtonCancel.style.margin	= "3px";
			mButtonCancel.value			= "Cancel";
			mButtonCancel.attachEvent( "onclick", function(){ clearBlock( mDiv ); } );
			mDiv.appendChild( mButtonCancel );
			//
			mTable.parentNode.appendChild( mDiv );
			mInputValue.focus();
		}
		if( editMode == SYS_MODE_LAYOUT ){ 
			// 編集可非の入力欄
			var mSelectEdit = document.createElement("select");
			// option要素作成
			var option1 = document.createElement( "option" );
			// option要素のvalue属性に選択項目データ
			option1.value = "1";
			if( cellVals[indexStart].cellEdit == "1" ){
				option1.selected = "true";
			}
			// テキストノード作成
			var text = document.createTextNode( SYS_EDIT );
			// テキストノードをoption要素に追加
			option1.appendChild( text );
			// option要素をselect要素に追加
			mSelectEdit.appendChild( option1 );
			var option2 = document.createElement( "option" );
			// option要素のvalue属性に選択項目データ
			option2.value = "0";
			if( cellVals[indexStart].cellEdit == "0" ){
				option2.selected = "true";
			}
			// テキストノード作成
			var text = document.createTextNode( SYS_NOTEDIT );
			// テキストノードをoption要素に追加
			option2.appendChild( text );
			// option要素をselect要素に追加
			mSelectEdit.appendChild( option2 );
			//
			mDiv.appendChild( mSelectEdit );
			var mBr   = document.createElement("br");
			mDiv.appendChild( mBr );

			// OKボタン
			var mButtonOK	  			= document.createElement("button");
			mButtonOK.style.width 		= "55px";
			mButtonOK.style.margin		= "1px";
			mButtonOK.value				= "OK";
			mButtonOK.attachEvent( "onclick", function(){ editBlock2( mSelectEdit ,mDiv ); } );
			mDiv.appendChild( mButtonOK );

			// Cancelボタン
			var mButtonCancel  			= document.createElement("button");
			mButtonCancel.style.width 	= "55px";
			mButtonCancel.style.margin	= "3px";
			mButtonCancel.value			= "Cancel";
			mButtonCancel.attachEvent( "onclick", function(){ clearBlock( mDiv ); } );
			mDiv.appendChild( mButtonCancel );
			//
			mTable.parentNode.appendChild( mDiv );
			mSelectEdit.focus();
		}
	}
	// 
	startCell   = null;
	// セルの中身を非選択にする。
	return false;
}

// メイン処理（画面から呼び出す）
function adjustMatrix(){
	// // viewTableのオブジェクトの取得
	var objViewTable = document.getElementById( "viewTable" );
	// viewTableが存在しなければ終了
	if( objViewTable == null ){ return false; } 

	// iMatrixオブジェクト取得
	var objMatrix = document.getElementsByTagName( "iMatrix" );
	// iMatrixが存在しなければ終了
	if( objMatrix == null || objMatrix.length == 0 ){ return false; }

	// 編集モード
	if( objMatrix[0].mode != null ){ 
		editMode 		= objMatrix[0].mode;
		if( editMode != SYS_MODE_LAYOUT && editMode != SYS_MODE_VALUE ) {
			alert("mode属性は「Layout,Value」以外の値に設定できません");
			return false;
		}
	}
	// セルの属性数（行、列、値、色、ステータス）
	if( objMatrix[0].countPro != null ){ 
	    countPro 		= new Number( objMatrix[0].countPro );	
	}
	// セル幅
	if( objMatrix[0].cellWidth != null ){ 
	    cellWidth		= objMatrix[0].cellWidth;	
	}
	// セル高さ
	if( objMatrix[0].cellHeight != null ){ 
	    cellHeight		= objMatrix[0].cellHeight;	
	}
	// セル値の入力欄の幅
	if( objMatrix[0].inputWidth != null ){ 
		inputWidth = objMatrix[0].inputWidth; 
	}
	// ステータスの数
	if( objMatrix[0].countStatus != null ){
	    countStatus		= objMatrix[0].countStatus;	
	}
	// ステータスの表示(true)/非表示(false)
	if( objMatrix[0].showStatus != null ){
	    showStatus		= objMatrix[0].showStatus;	
	}
	// セルの編集可(true)/編集不可(false)
	if( objMatrix[0].writable != null ){
	    writable		= objMatrix[0].writable;	
	}
	// セル背景色の編集可(true)/編集不可(false)
	if( objMatrix[0].editColor != null ){
	    editColor		= objMatrix[0].editColor;
	}
	// セル名称と値の間の区切り文字
	if( objMatrix[0].separator != null ){
	    separator		= objMatrix[0].separator;	
	}
	// パラメータ：設定値
	if( objMatrix[0].paramVal != null ){
	    paramVal		= objMatrix[0].paramVal;	
	}
	// パラメータ：背景色
	if( objMatrix[0].paramColor != null ){
	    paramColor		= objMatrix[0].paramColor;	
	}
	// パラメータ：背景色
	if( objMatrix[0].notEditBgColor != null ){
	    notEditBgColor	= objMatrix[0].notEditBgColor;	
	}

	//
//	var winWidth 	 = getClientWidth();						// IEの幅を取得
//	var winHeight	 = getClientHeight();						// IEの高さを取得
	var parentNode	 = objViewTable.parentNode;					// viewTableの親ノード
	var viewRowCount = objViewTable.rows.length;				// viewTableの行数
	var viewColCount = objViewTable.rows[0].cells.length;		// viewTableの列数
	var cellCount 	 = viewRowCount * viewColCount / countPro;	// データノードの数
	//
	var indexId 	 = 0;
	//
	cellObjs 		 = new Array( cellCount );					// セルオブジェクト
	cellVals  	 	 = new Array( cellCount );					// セルのロケーション名称

	// viewTableよりデータノードを作成する。
	for( i = 0; i < viewRowCount; i++ ){
		for( j = 0; j < viewColCount; j += countPro ){
			cellVals[indexId++] = new dataNode( objViewTable.rows[i].cells[j  ].innerText									// 行番号
												 ,objViewTable.rows[i].cells[j+1].innerText									// 列番号
												 ,objViewTable.rows[i].cells[j+2].innerText									// ロケーション名
												 ,objViewTable.rows[i].cells[j+3].innerText									// 値
												 ,objViewTable.rows[i].cells[j+4].innerText									// 色
												 ,objViewTable.rows[i].cells[j+5].innerText									// セル編集可非
												 ,showStatus == "true" ? objViewTable.rows[i].cells[j+6].innerText : null	// ステータス
												);
		}
	}
	// テーブルの出力
	mTable 				= document.createElement("table");
	var lastRow 		= 1;
	mTable.id  			= "MatrixTable";
	mTable.style.border = "solid black 1px";
	mTable.style.borderCollapse = "collapse";
	mTable.style.margin = "10px";
	mTable.style.cellspacing  = "0";
	mTable.style.cellspadding = "0";

	// ダブルクリックの処理（セルの編集）
	if( writable == "true" ){
		// マウスでの選択
		mTable.attachEvent( "onmousedown", function(){ mouseDown( event );return false; } );
		mTable.attachEvent( "onmousemove", function(){ mouseMove( event );return false; } );
		mTable.attachEvent( "onmouseup"  , function(){ mouseUp(   event );return false; } );
		mTable.attachEvent( "ondblclick" , function(){ editTd(    event );return false; } );
	}
	for( i = 0; i < cellCount; ){
		var objRow  = mTable.insertRow();								// 行要素作成
		while( cellVals[i].row == lastRow ){							// 同じ行の要素出力
			cellObjs[i] 					  = objRow.insertCell();	// 新規セル作成
			cellObjs[i].style.width 		  = cellWidth;				// 幅
			cellObjs[i].style.height		  = cellHeight;				// 高さ
			cellObjs[i].style.border 		  = "solid lightgrey 1px";	// ボーダー
			cellObjs[i].row 				  = cellVals[i].row;		// 高さ
			cellObjs[i].col					  = cellVals[i].col;		// 高さ
			// ステータス表示
			if( showStatus=="true" && cellVals[i].status != "" ){
				var imgStatus			  = document.createElement("img");
				imgStatus.src 			  = "../image/status_" + cellVals[i].status + ".png";
				imgStatus.style.width	  = "15px";
				imgStatus.style.height	  = "15px";
				if( writable == "true" && cellVals[i].cellEdit == "1" && editMode == SYS_MODE_VALUE ){
					imgStatus.attachEvent( "ondblclick"  , function(){ editStatus( event );return false; } );
				}
				// セルにステータス画像を出力する。
				cellObjs[i].appendChild( imgStatus );
			}
			var sep = ( cellVals[i].location == "" || cellVals[i].value=="" ) ? "" :separator;
			cellObjs[i].appendChild( document.createTextNode( cellVals[i].location + sep + cellVals[i].value )); // 値
			//
			if( cellVals[i].cellEdit == "1" ){
				cellObjs[i].style.backgroundColor = cellVals[i].color;	// 色
			}
			else{
				cellObjs[i].style.backgroundColor = notEditBgColor;   // 色
			}
			i++;														// 次のノード
			if( i == cellCount ){ break; }
		}
		// 改行
		if( i == cellCount ){ break; }									// 全ノード出力終了
		lastRow  = cellVals[i].row;
	}
	rowCount = mTable.rows.length;
	colCount = mTable.rows[0].cells.length;

	parentNode.insertBefore( mTable, objViewTable );					// テーブルの出力
	parentNode.removeChild( objViewTable );								// viewTableの削除
};
