/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public final class ExcelStyleFormat {
    private static final String VERSION = "6.2.0.0 (2015/02/27)";
    private static final String[] DATE_TYPE = new String[]{"yyyyMMdd", "yyyyMMddHHmmss", "HHmmss"};
    private final DateFormat[] dtFormat = new DateFormat[DATE_TYPE.length];
    private final StylesTable stylesTable;
    private final Map<Integer, Integer> extFmtIdx = new HashMap<Integer, Integer>();
    private final Map<Integer, String> fmtStrMap = new HashMap<Integer, String>();
    private int extFmtCnt;

    public ExcelStyleFormat() {
        this.stylesTable = null;
    }

    public ExcelStyleFormat(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public void addExtFmtRec(ExtendedFormatRecord extendedFormatRecord) {
        short s = extendedFormatRecord.getFormatIndex();
        short s2 = extendedFormatRecord.getXFType();
        if (s2 == 0) {
            this.extFmtIdx.put(this.extFmtCnt, Integer.valueOf(s));
        }
        ++this.extFmtCnt;
    }

    public void addFmtRec(FormatRecord formatRecord) {
        int n = formatRecord.getIndexCode();
        String string = formatRecord.getFormatString();
        this.fmtStrMap.put(n, string);
    }

    public String getNumberValue(String string, String string2) {
        int n;
        XSSFCellStyle xSSFCellStyle;
        String string3 = null;
        if (this.stylesTable != null && string != null && !string.isEmpty() && (string3 = (xSSFCellStyle = this.stylesTable.getStyleAt(n = Integer.parseInt(string))).getDataFormatString()) == null) {
            short s = xSSFCellStyle.getDataFormat();
            string3 = BuiltinFormats.getBuiltinFormat((int)s);
        }
        return this.getNumberValue(string3, Double.parseDouble(string2));
    }

    public String getNumberValue(NumberRecord numberRecord) {
        short s = numberRecord.getXFIndex();
        int n = this.extFmtIdx.get(s);
        String string = n < 164 ? BuiltinFormats.getBuiltinFormat((int)n) : this.fmtStrMap.get(n);
        return this.getNumberValue(string, numberRecord.getValue());
    }

    private String getNumberValue(String string, double d) {
        return this.isDateFormat(string) ? this.dateFormat(d) : NumberToTextConverter.toText((double)d);
    }

    private boolean isDateFormat(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty() && !"General".equalsIgnoreCase(string) && (string.contains("\u5e74") || string.contains("\u6708") || string.contains("\u65e5") || string.contains("yy") || string.contains("y/m") || string.contains("m/d") || string.contains("h:m"))) {
            bl = true;
        }
        return bl;
    }

    private String dateFormat(double d) {
        int n = 0;
        n = d < 1.0 ? 2 : (Double.compare(d, Math.floor(d)) != 0 ? 1 : 0);
        DateFormat dateFormat = this.dtFormat[n];
        if (dateFormat == null) {
            this.dtFormat[n] = dateFormat = new SimpleDateFormat(DATE_TYPE[n], Locale.JAPAN);
        }
        Date date = DateUtil.getJavaDate((double)d);
        return dateFormat.format(date);
    }
}

