<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<style type="text/css">
	option.A1 { font-weight:bold; 
				font-size:20pt; !important;
				background-color:#bfefdf;
				color:navy;	
			  }
		.A2 { background-color:white;
			}
		.A3 { background-color:white;
			}
</style>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<!-- 項目 -->
	<og:columnSet command="INSERT" columnId="SYSTEM_ID" action="SET" value="{@MEM.SYSTEM_ID}"/>
	<og:columnSet command="INSERT" columnId="KBFAQ" action="SET" value="0"/>
	<og:columnSet command="COPY" columnId="KBFAQ" action="SET" value="0"/>
</og:entry>
<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp"  target="RESULT">
<og:columnEditor columns="TITLE" must="true"/>
<og:columnEditor columns="SYSTEM_ID" must="true" defaultVal="{@SYS.SYSTEM.ID}" optionAttributes="readonly" style="border-style:solid;border:0px;background:transparent;"/>
<og:columnEditor columns="NAIYO" editor="TEXTAREA"/>
<og:equals val1="INSERT|COPY" val2="{@command}" contains="true">
	<og:columnEditor columns="CDBNRUI" editor="DBMENU" eventColumn="SYSTEM_ID,SYSCODE" must="true" dbid="RESOURCE"
		param="SELECT CDBNRUI,TITLE,'' A,'' B,'A'{@DBF.CON}KBFAQ FLG FROM GE80 WHERE KBFAQ != '0' AND FGJ IN ('0','1') AND SYSTEM_ID = '{@SYSTEM_ID}' AND ( ('{@SYSCODE}' is null AND SYSCODE='*') OR SYSCODE = '{@SYSCODE}') ORDER BY SEQNO"/>
</og:equals>

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" keys="UPDFLG" vals="0"/>
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType = "HTMLFormatTextField"			
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	noWritable   = "{@noWritable}"
	skip		 = "true"
>
<table>
	<tr>
		<td>[#SYSTEM_ID]</td><td>[$SYSTEM_ID]</td>				<!-- ｼｽﾃﾑID -->
		<td>[#SYSCODE]</td><td>[$SYSCODE]</td>					<!-- ｼｽﾃﾑｺｰﾄﾞ -->
	</tr>
	<tr>
		<td>[#QANO]</td><td>[$QANO]</td>						<!-- 質問番号 -->
	</tr>
	<tr>
		<td>[#CDBNRUI]</td><td>[$CDBNRUI]</td>					<!-- 分類名 -->
		<td>[#KNRNGUI]</td><td>[$KNRNGUI]</td>					<!-- 関連画面ID -->
	</tr>
	<tr>
		<td>[#TITLE]</td><td colspan="3">[$TITLE]</td>			<!-- ﾀｲﾄﾙ -->
	</tr>
	<tr>
		<td>[#NAIYO]</td><td colspan="3">[$NAIYO]</td>			<!-- 対応方法 -->
	</tr>
	<tr>
		<td>[#TAG]</td><td>[$TAG]</td>							<!-- ﾀｸﾞ	-->
	</tr>
	<tr>
		<td>[#SEQNO]</td><td>[$SEQNO]</td>						<!-- 表示順 -->
		<td>[#FGJ]</td><td>[$FGJ]</td>							<!-- 状況 -->
	</tr>
</table>
</og:view>
<og:value command="SETTBL" key="SYSCODE"/>
	<og:hidden name="SYSCODE1" value="{@SYSCODE}"/>
<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
