/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value="/wsdemo")
public class WebSocketDemo {
    @OnOpen
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        System.out.println(session.getId() + " was connected.");
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        System.out.println(session.getId() + " was closed by " + closeReason.getCloseCode() + "[" + closeReason.getCloseCode().getCode() + "]");
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        System.out.println(session.getId() + " was error.");
        throwable.printStackTrace();
    }

    @OnMessage
    public void onMessage(String string, Session session) throws IOException {
        for (Session session2 : session.getOpenSessions()) {
            session2.getBasicRemote().sendText(string);
        }
    }

    @OnMessage
    public void onMessage(ByteBuffer byteBuffer, Session session) throws IOException {
        session.getBasicRemote().sendBinary(this.grayScall(byteBuffer));
    }

    private ByteBuffer grayScall(ByteBuffer byteBuffer) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteBuffer.array()));
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }
}

