<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0008"
	title    = "ユーザーパラメータ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command = "{@command}" dbid="{@DBID}" maxRowCount="{@maxRowCount}" >
		select '1' as WRITABLE,A.SYSTEM_ID,A.USERID,'' TITLE,A.PARAM_ID,A.PARAM,'' CONTENTS,
				'5' as PARAM_LVL,A.UNIQ,A.FGJ
		from GE16 A
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
		and   A.USERID    = '{@USERID}'
	<og:where startKey="and">
		<og:and value = "A.FGJ		 =	  '{@FGJ}'"			/>
		<og:and value = "A.PARAM_ID like '{@PARAM_ID}'"	/>
		<og:and value = "A.PARAM	 like '{@PARAM}'" 		/>
	</og:where>
		union
		select '1' as WRITABLE,SYSTEM_ID,'------' as USERID,TITLE,PARAM_ID,PARAM,CONTENTS,PARAM_LVL,0 as UNIQ,FGJ
		from GE12
		where SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
		and   PARAM_LVL = '4'
	<og:where startKey="and">
		<og:and value = "FGJ		=	 '{@FGJ}'"			/>
		<og:and value = "PARAM_ID	like '{@PARAM_ID}'"	/>
		<og:and value = "TITLE		like '{@TITLE}'"		/>
		<og:and value = "CONTENTS	like '{@CONTENTS}'"	/>
		<og:and value = "PARAM		like '{@PARAM}'" 		/>
	</og:where>
		order by PARAM_ID,SYSTEM_ID DESC,PARAM_LVL DESC
</og:query>

<!-- PARAM_ID キーでグループ化します。先行優先です。-->
<og:tableMerge
	action        = "GROUP"
	masterKeys    = "PARAM_ID"
	display       = "false"
/>

<og:tableFilter classId="DBSELECT" selectedAll="true">
	select A.TITLE, A.CONTENTS
	from GE12 A
	where A.SYSTEM_ID	in ( '{@SYSTEM_ID}','**' )
	and A.PARAM_ID		= [PARAM_ID]
	and A.PARAM_LVL =	'4'
	<og:where startKey="and">
		<og:and value = "A.FGJ          =    '{@FGJ}'"          />
	</og:where>
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:tableFilter>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="PARAM" onMark="PASS" markList="[PARAM_ID]" >
		<span>****</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_ID" onMark="[PARAM_LVL]" markList="5" >
		<span style="background-color:#ccff00">[PARAM_ID]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="TITLE"    size="100" />
<og:columnEditor column="CONTENTS" editor="AUTOAREA" param="3-15,100-100" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="TITLE,PARAM_LVL" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,PARAM_ID,PARAM_LVL,TITLE,USERID"  />
		<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
		<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"/>

	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GE12" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:column  name="USERID"    useRequestValue="false" td="no" />
			<og:submit  action="COPY"    noWritable="PARAM_LVL"  lbl="SYS{@LBL.COPY}" keys="sysins" vals="true" />
		</fieldset>
	</og:equals>
</og:writeCheck>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
>
<jsp:directive.include file="view.jsp" />
</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
