<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0017"
	title    = "ロールマスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_ROLES" value="ROLE" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_ROLES" value="ROLES" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,ROLES,NMROLE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select '1' as WRITABLE,{@C_ROLES},NMROLE,KBROLE,SYSTEM_ID,FGJ,UNIQ
		from GEA05
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "{@C_ROLES}	like '{@ROLES}'"	/>
		<og:and value = "NMROLE		like '{@NMROLE}'"	/>
		<og:and value = "KBROLE		=	 '{@KBROLE}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,KBROLE,{@C_ROLES}" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,{@C_ROLES},KBROLE" must="true" />

<og:viewLink command="{@command}">
	<og:link column="{@C_ROLES}" gamenId="GE0019" href="index.jsp" target="CONTENTS" onLink="[KBROLE]" markList="1"
		keys="command,SYSTEM_ID,ROLES,KBROLE"
		vals="NEW,[SYSTEM_ID],[{@C_ROLES}],1" />
	<og:link column="{@C_ROLES}" gamenId="GE0019" href="index.jsp" target="CONTENTS" onLink="[KBROLE]" markList="2"
		keys="command,SYSTEM_ID,ROLES,KBROLE"
		vals="NEW,[SYSTEM_ID],[{@C_ROLES}],2" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,{@C_ROLES},KBROLE"  />
	<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
	<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"/>

	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GEA05" /></strong></legend>
		<og:column  name="SYSTEM_ID" useRequestValue="false" must="true" td="no" />
		<og:submit  action="COPY" noWritable="null" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
	</fieldset>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
