<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2201"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "H.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="{@SYS.DEV_DBID}">
		SELECT	PGID , NMPG , HPGID , SEQ , SYSTEM_ID , FGJ , UNIQ
		FROM	GF90
	<og:where>
		<og:and value = "SYSTEM_ID		=		'{@SYSTEM_ID}'"	/>
		<og:and value = "PGID			LIKE	'{@PGID}'"		/>
		<og:and value = "NMPG			LIKE	'{@NMPG}'"		/>
		<og:and value = "FGJ			=		'{@FGJ}'"		/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SEQ,PGID" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。-->
<og:columnEditor columns="SYSTEM_ID,PGID,NMPG" must="true" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- LinkTag で、画面遷移を行う場合は、gamenId属性を使用してください。-->
	<!-- LinkTag のuseGamenId属性 を "false" に設定すると、GAMENID,BACK_GAMENIDなどのリクエスト情報が付加されません。-->
	<!-- 項目 -->
	<og:link column="PGID" gamenId="GF2202" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,PGID,NMPG"
		vals="NEW,[SYSTEM_ID],[PGID],[NMPG]" />
	<og:link column="NMPG" href="jspOut.jsp" target="RESULT"
		keys="command,SYSTEM_ID,PGID,HPGID"
		vals="NEW,[SYSTEM_ID],[PGID],[HPGID]" />
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="update" command="COPY"   lbl="COPY"   accesskey="C"  
			keys="lblKey,noWritable" vals='"MSG0045","UNIQ"' />
	<og:submit value="update" command="MODIFY" lbl="MODIFY" accesskey="M" 
			keys="noWritable" vals='"UNIQ"' />
	<og:submit  value="update" command="DELETE" lbl="DELETE" accesskey="Z" />

　　　　<og:link gamenId="GF2200" href="index.jsp" target="_top"
		keys="command,SYSTEM_ID" vals="NEW,{@SYSTEM_ID}" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
