<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC16"
	title	= "JSPファイル一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" >
	<!-- where 条件は、UNIQ だけで特定できるが、不測の事態を避ける意味で、別のキーも入れておく -->
	<og:tableUpdateParam
		sqlType		= "{@sqlType}"
		table		= "GF76"
		omitNames	= "SNIPPET"
		where		= "UNIQ=[UNIQ] and SYSTEM_ID=[SYSTEM_ID] and TBLSYU=[TBLSYU] and FILEPATH=[FILEPATH]"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
