<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2005"
	title	= "ｶﾗﾑ定義ﾏｽﾀ"
	date	= "2014/05/16"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
	<!-- データが選ばれていなければエラー -->
	<og:columnCheck command="{@command}" >
		<jsp:directive.include file="/jsp/common/history_back.jsp" />
	</og:columnCheck>
<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<!-- 項目 -->
	<og:columnSet command="INSERT" columnId="CLM"    action="NULLSET"	value="{@MEM.CLM}" />
	<og:columnSet command="COPY"   columnId="CLM"    action="NULLSET"	value="{@MEM.CLM}" />
</og:entry>

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="ENTRY" />
	<og:submit  action="RESET" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	columnBulkSet	= "*"
	noWritable		= "{@noWritable}"
	columnWritable	= "{@columnWritable}" />

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
