<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	filename    = "tempUpload.xls"
	maxPostSize = "20000000"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1"
/>

<og:file fileURL="{@USER.ID}" file1="tempUpload.xls" action="existsLength" >
	<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
	<og:text>fileURL="{@USER.ID}" file1="tempUpload.xls"</og:text>
</og:file>

<og:readTable
	command		= "NEW"
	readerClass = "Excel"
	useNumber   = "false"
	skipRowCount= "3"
	modifyType	= "A"
	fileURL		= "{@USER.ID}"
	filename	= "tempUpload.xls"
	encode		= "UnicodeLittle"
	adjustColumns	= "*"
	checkColumns	= "*"
	sheetNos    = "{@sheetNos}"
	sheetConstKeys	= "TABLE_NAME,NAME_JA"
	sheetConstAdrs	= "1-2,1-7"
	nullBreakClm	= "CLM"
	columns		= "SEQNO,CLM,CLS_NAME,USE_LENGTH,PHY_LENGTH,NOT_NULL,DATA_DEFAULT,CLM_NAME,BIKO,TABLE_NAME,NAME_JA"
	maxRowCount	= "0"
	debug		= "{@debug}"
/>

<og:value command="SET" key="LENGTH_FUNC">
case when [PHY_LENGTH] is null then [USE_LENGTH] else [USE_LENGTH] || ',' || [PHY_LENGTH] end
</og:value>

<!-- 登録処理をおこないます。 -->
<!-- constObjKey="GF" で、DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD を自動セットします。 -->
<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
	<og:tableUpdateParam
		constObjKey = "GF"
		sqlType		= "INSERT"
		table		= "GF80"
		omitNames	= "PHY_LENGTH"
		funcKeys	= "USE_LENGTH"
		funcVals	= "{@LENGTH_FUNC}"
		constKeys	= "KBCLM,SYSTEM_ID,TBLSYU,FGJ"
		constVals	= "0,{@MEM.SYSTEM_ID},{@MEM.TBLSYU},1"
	/>
</og:tableUpdate>
<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
