<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6040"
	title	= "Submit(HTML5)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLE_CLM2"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="entry" lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset" lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<table>
<tr><th>フォーム</th>													<th>説明</th></tr>
<tr><og:column type="search" 		name="search"	 help="/help/oracletext-ja.pdf"	> …… 検索テキストの入力欄を作成する		</og:column></tr>
<tr><og:column type="tel"			name="tel"				defaultVal="あ" > …… 電話番号の入力欄を作成する			</og:column></tr>
<tr><og:column type="url"			name="url"				defaultVal="あ" > …… URLの入力欄を作成する				</og:column></tr>
<tr><og:column type="email"			name="email"			defaultVal="あ" > …… メールアドレスの入力欄を作成する		</og:column></tr>
<tr><og:column type="datetime"		name="datetime"			defaultVal="あ" > …… 協定世界時による日時の入力欄を作成する</og:column></tr>
<tr><og:column type="date"			name="date"				defaultVal="あ" > …… 日付の入力欄を作成する				</og:column></tr>
<tr><og:column type="month"			name="month"			defaultVal="あ" > …… 月の入力欄を作成する					</og:column></tr>
<tr><og:column type="week"			name="week"				defaultVal="あ" > …… 週の入力欄を作成する					</og:column></tr>
<tr><og:column type="time"			name="time"				defaultVal="あ" > …… 時間の入力欄を作成する				</og:column></tr>
<tr><og:column type="datetime-local" name="datetime-local"	defaultVal="あ" > …… ローカル日時の入力欄を作成する		</og:column></tr>
<tr><og:column type="number"		name="number"			defaultVal="あ" > …… 数値の入力欄を作成する				</og:column></tr>
<tr><og:column type="color"			name="color"			defaultVal="あ" > …… 色の入力欄を作成する					</og:column></tr>
<tr><og:column type="range"			name="range" 			defaultVal="30" > …… レンジ入力欄を作成する({@range})		</og:column></tr>
</table>

<table>
<tr><th>属性テスト</th>																	<th>説明</th></tr>
<tr><og:column 				name="autofocus"	autofocus="autofocus"								> …… 入力欄にカーソルを当てて自動フォーカスする		</og:column></tr>
<tr><og:column 				name="placeholder"	placeholder="テキストを入力してください"			> …… 入力欄に初期表示する内容を指定する				</og:column></tr>
<tr><og:column 				name="required"		required="required"									> …… 入力必須であることを示す							</og:column></tr>
<tr><og:column 				name="pattern"		pattern="[0-9]*" title="[0-9]*パターン"	defaultVal="A"	> …… 正規表現で入力値のパターンを指定する ([0-9]*)	</og:column></tr>
<tr><og:column type="number" name="min_max"		min="2" max="10"				defaultVal="12"			> …… 入力できる最小値と最大値を指定する (min="2" max="10")	</og:column></tr>
<tr><og:column type="number" name="step"		step="0.5"						defaultVal="3.14"		> …… 入力欄で刻むステップ値を指定する (step="0.5") 	</og:column></tr>
<tr><og:column 				name="AAA"		autocomplete="on"	list="AAA.sel"					> …… 入力候補を提示して入力内容を自動補完する(autocomplete)</og:column></tr>
<!-- list に、datalist タグの id を指定します。column タグは、自動で name 属性と同じ id を出力するので、注意 -->
<tr><og:column 				name="BBB"			list="BBB.sel"										> …… 入力候補を提示して入力内容を自動補完する(autocomplete="on" は初期値)	</og:column></tr>
<tr><og:input 				name="CCC"			list="CCC.sel"										> …… 入力候補を提示して入力内容を自動補完する(inputタグ)					</og:input></tr>
<tr><og:column 				name="DDD"			list="CCC.sel"										> …… 入力候補を提示して入力内容を自動補完する(liet="h_CCC"を流用)		</og:column></tr>
<tr><og:select name="sel">
		<og:queryOption>
			select EMPNO,ENAME from EMP order by EMPNO
		</og:queryOption>
	</og:select></tr>
</table>

<table>
	<tr><th colspan="2">属性テスト</th>							<th colspan="2">説明</th></tr>
	<og:text>
	<tr><td>progress</td><td><progress min="0" max="100" value="{@range}" /></td>
		<td>min="0" max="100" value="{@range}"</td><td>タスク完了までの進行状況を示す</td></tr>
	</og:text>
	<tr><td>progress</td><td><progress min="0" max="100" /></td>
		<td>min="0" max="100"</td><td>タスク完了までの進行状況を示す</td></tr>
	<og:text>
	<tr><td>meter</td><td><meter min="0" max="100" value="{@range}" low="20" high="80" optimum="50" /></td>
		<td>min="0" max="100" value="{@range}" low="20" high="80" optimum="50"</td><td>規定範囲内の測定値を表す</td></tr>
	</og:text>
	<tr></tr>
</table>

<!-- 互換モードの時、option の BODY 部だけ表示されてしまう。 -->
<!-- このサンプルは、たまたま、BODY部に記述していないので、互換モードでも見えません。 -->
<og:datalist id="AAA.sel">
	<og:option value="ウィキペディア" />
	<og:option value="ウィルス対策"   />
	<og:option value="ウィンドウズ"   />
</og:datalist>

<!-- 互換モードの時、option の BODY 部だけ表示されてしまうので、div で隠す -->
<div style="display:none;">
	<og:datalist id="BBB.sel">
		<og:option value="1112"  >MARRY2</og:option>
		<og:option value="1114"  >JOHN</og:option>
		<og:option value="1115"  >SALA</og:option>
		<og:option value="1555"  >MIKE</og:option>
		<og:option value="7782"  >CLARK</og:option>
		<og:option value="7844"  >TURNER1B</og:option>
		<og:option value="7876"  >ADAMS</og:option>
		<og:option value="7900"  >JAMES</og:option>
	</og:datalist>
</div>

<!-- datalist タグの場合は、出力される HTMLデータ に、display:none; を含めています。 -->
<og:datalist id="CCC.sel">
	<og:queryOption>
		select EMPNO,ENAME from EMP order by EMPNO
	</og:queryOption>
</og:datalist>

</form>

<br /><hr /><br />

<!-- 入力欄とボタンの修飾 -->
<!-- 角を丸くする のに、default.css で、指定します。 -->

<form method="POST" action="forward.jsp" target="RESULT">

<table>
	<tr><og:column type="search" name="search" help="/help/oracletext-ja.pdf" > …… 角を丸くする </og:column></tr>

	<tr><td></td><td><og:submit value="result" lbl="SUBMIT" clazz="circle"  style="width:100px;" /></td></tr>
	<tr><td></td><td><og:submit value="result" lbl=" " img="{@SYS.JSP}/image/dogrun.gif" clazz="circle"
			style="width:100px;height:100px;" /></td></tr>
	<tr><td></td><td><span clazz="circle" style="color:red; background-color:yellow;">…… 角を丸くする</span></td></tr>
	<tr><td></td><td><span style="border-radius:9px;-moz-border-radius:9px; -webkit-border-radius:9px;color:red; background-color:yellow;">…… 角を丸くする</span></td></tr>
</table>
</form>


<br /><hr /><br />

<form onSubmit="return oneClick();" method="POST" enctype="multipart/form-data" action="upload.jsp" target="RESULT">
<table>
	<tr><og:input type="file" name="multiple" optionAttributes="multiple" > …… 複数の値を入力・選択できるようにする</og:input></tr>
	<tr><og:input name="filename" lbl="ZIP fileName" value="upload.zip" >
			<og:submit  value="entry" lbl="UPLOAD" accesskey="U" />
		</og:input>
	</tr>
</table>
</form>

<hr />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
