<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6300"
	title	= "画面リフレッシュ"
	date	= "2014/12/16"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
		select  a.FGKAN,a.YKNO,a.LISTID,b.LISTNAME,a.JOKEN,
				a.SUDATA,a.SUPAGE,
				a.OUT_DIR,a.OUT_FILE,a.DYSET
		from    GE50 a left outer join GE54 b
		on		a.SYSTEM_ID = b.SYSTEM_ID
		and		a.LISTID    = b.LISTID
		where	a.SYSTEM_ID =  'GE'
		and		a.FGJ       in ( '0','1' )
--		and		a.DYSET     like '{@DATE.YMD}%'
--		and		a.USRSET    =  '{@USER.ID}'
	<og:where startKey="and">
		<og:and value = "a.JOKEN	=	'{@PRT_JOKEN}'"	/>
		<og:and value = "a.PGPSET	=	'{@PGPSET}'"	/>
		<og:and value = "a.DYSET   &gt;= '{@STTIME}'"	/>
	</og:where>
	order by a.SYSTEM_ID,a.YKNO DESC
</og:query>


<og:viewLink command="NEW">
	<og:link column="OUT_FILE" href="{@SYS.JSP}/fileDownload" useGamenId="false" target="_blank"
		onLink="[FGKAN]" markList="2" useHrefEncode="true"
		keys="file,name" vals="[OUT_DIR]/[OUT_FILE],[OUT_FILE]" />

	<og:link column="DYSET" href="[OUT_DIR]/[OUT_FILE]" useGamenId="false" target="_NEW" useHrefEncode="true" />
</og:viewLink>

<og:text>{@DATE.YMDHMSF}</og:text>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "NEW"
	writable	 = "false"
	scope        = "request"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	noDisplay	 = "OUT_DIR"
/>

<!-- 完了状態を確認する。 FGKAN が、1:登録 と 3:実行中 がなくなるまで -->
<og:value command="SQL" >
	select count(*) as CNT from GE50
		where	SYSTEM_ID =  '{@SYS.SYSTEM_ID}'
		and		FGKAN     in ( '1','3' )
		and		FGJ       in ( '0','1' )
		and		DYSET     like '{@DATE.YMD}%'
		and		USRSET    =  '{@USER.ID}'
	<og:where startKey="and">
		<og:and value = "JOKEN	= '{@PRT_JOKEN}'"	/>
		<og:and value = "PGPSET	= '{@PGPSET}'"		/>
		<og:and value = "DYSET	&gt;= '{@STTIME}'"	/>
	</og:where>
</og:value>

<!-- history.back() で、戻る回数を数えるための変数:history.go( 数値 ) -->
<og:value command="SET" action="EXEC" key="CNT1" value="{@CNT2} + 1" />

<og:equals val1="{@CNT}" val2="0" notEquals="true" >
	<og:responseHeader refresh="2" refreshURL="{@SYS.JSP}/common/reportView.jsp?PRT_JOKEN={@PRT_JOKEN}&amp;PGPSET={@PGPSET}&amp;STTIME={@STTIME}&amp;CNT2={@CNT1}" />
</og:equals>

<!-- 登録完了のﾒｯｾｰｼﾞを表示します｡ refresh 引数がない場合は表示しません。 -->
<og:errorMessage command="RENEW" clear="{@clear}" displayMsg="{@NVL.displayMsg MSG0074}" />
<br />

<!-- history.back() で、戻る回数を指定 -->
<form>
<og:input type="button" onClick="history.go( -{@CNT1} )" lbl="MSG0079" accesskey="R" td="false" />
</form>
<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
